/* Copyright 2021 DmNosachev
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include QMK_KEYBOARD_H


const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
/*
,---------------------------------------------------------------------------------------------------------,  ,-----,
| F11 |  | F12 |  |  F1  |  F2  |  F3  |  F4  |  F5  |   |  F6  |  F7  |  F8  |  F9  | F10  | |PgUp |PgDn |  | NO  |
|-------------------------------------------------------------------------------------------| |-----------|  |-----|-----------------,
| Esc  |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  0  |  —- | +=  |  ~` |BkSpc | |Home | End |  |  *  |  /  |  -  |  +  |
|-------------------------------------------------------------------------------------------| |-----------|  |-----------------------|
|  Tab  |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  | {[  | }]  |   Enter   | | Ins | Del |  |  7  |  8  |  9  | +=  |
|--------------------------------------------------------------------------------|          | `-----------'  |-----------------------|
|  Ctrl  |  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  | :;  | "'  | |\  |          | |    Up     |  |  4  |  5  |  6  |  .  |
|--------------------------------------------------------------------------------`----------' |-----------|  |-----------------------|
|   Shift  |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  <, |  >. | ?/  |  NO |    Shift     | |Left |Right|  |  1  |  2  |  3  | <,  |
|-------------------------------------------------------------------------------------------| |-----------|  |-----------------------|
|Caps | Alt | App | GUI |   Space     |   Space     |    Enter        | Ctrl  |       | Alt | |   Down    |  |  0  |  0  |   Enter   |
`-------------------------------------------------------------------------------------------' `-----------'  '-----------------------'
                               |  Del | BackSp|
                               `--------------'
*/
    [0] = LAYOUT(
    KC_F11,   KC_F12,   KC_F1,  KC_F2,  KC_F3,  KC_F4,  KC_F5,     KC_F6,  KC_F7,  KC_F8,  KC_F9,  KC_F10,   KC_PGUP, KC_PGDN,   _______,
    KC_ESC,  KC_1, KC_2, KC_3, KC_4, KC_5, KC_6, KC_7, KC_8, KC_9, KC_0, KC_MINS, KC_EQL, KC_GRV, KC_BSPC,   KC_HOME, KC_END,    KC_PAST, KC_PSLS, KC_PMNS, KC_PPLS,
    KC_TAB, KC_Q, KC_W, KC_E, KC_R, KC_T, KC_Y, KC_U, KC_I, KC_O, KC_P, KC_LBRC, KC_RBRC,     KC_ENT,        KC_INS,  KC_DEL,    KC_P7,   KC_P8,   KC_P9,   KC_EQL,
    KC_LCTL, KC_A, KC_S, KC_D, KC_F, KC_G, KC_H, KC_J, KC_K, KC_L, KC_SCLN, KC_QUOT, KC_BSLS,                     KC_UP,         KC_P4,   KC_P5,   KC_P6,   KC_PDOT,
    KC_LSFT, KC_Z, KC_X, KC_C, KC_V, KC_B, KC_N, KC_M, KC_COMM, KC_DOT, KC_SLSH,  _______, KC_RSFT,          KC_LEFT, KC_RIGHT,  KC_P1,   KC_P2,   KC_P3,   KC_COMM,
    KC_CAPS, KC_LALT, KC_APP,  KC_LGUI,     KC_SPACE,    KC_SPACE,      KC_ENT,     KC_RCTL,   KC_RALT,           KC_DOWN,       KC_P0,   KC_P0,   KC_PENT,
                                              KC_DEL, KC_BSPC
    ),

    [1] = LAYOUT(
    _______,  _______,   _______,  _______,  _______,  _______,  _______,     _______,  _______,  _______,  _______,  _______,               _______, _______,   _______,
    _______,  _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,  _______, _______,   _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,    _______,         _______, _______,   _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,                           _______,      _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,                      _______, _______,  _______, _______, _______, _______,
    _______, _______, _______,          _______,       _______,         _______,     _______,     _______,   _______,                              _______,      _______, _______,    _______,
                                          _______, _______
    ),

    [2] = LAYOUT(
    _______,  _______,   _______,  _______,  _______,  _______,  _______,     _______,  _______,  _______,  _______,  _______,               _______, _______,   _______,
    _______,  _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,  _______, _______,   _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,    _______,         _______, _______,   _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,                           _______,      _______, _______, _______, _______,
    _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,                      _______, _______,  _______, _______, _______, _______,
    _______, _______, _______,          _______,       _______,         _______,     _______,     _______,   _______,                              _______,      _______, _______,    _______,
                                          _______, _______
    )
};
