#pragma once

#define RGBLIGHT_EFFECT_BREATHE_TABLE

// clang-format off

// Breathing center: 1.85
// Breathing max:    100

const uint8_t PROGMEM rgblight_effect_breathe_table[] = {
#if RGBLIGHT_BREATHE_TABLE_SIZE == 256
    0x0D, 0x0E, 0x0E, 0x0F, 0x0F, 0x10, 0x10, 0x11,
    0x11, 0x12, 0x13, 0x13, 0x14, 0x14, 0x15, 0x16,
    0x16, 0x17, 0x18, 0x18, 0x19, 0x19, 0x1A, 0x1B,
    0x1B, 0x1C, 0x1D, 0x1E, 0x1E, 0x1F, 0x20, 0x20,
    0x21, 0x22, 0x22, 0x23, 0x24, 0x25, 0x25, 0x26,
    0x27, 0x28, 0x28, 0x29, 0x2A, 0x2B, 0x2B, 0x2C,
    0x2D, 0x2E, 0x2E, 0x2F, 0x30, 0x31, 0x31, 0x32,
    0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x38, 0x38,
    0x39, 0x3A, 0x3B, 0x3B, 0x3C, 0x3D, 0x3D, 0x3E,
    0x3F, 0x40, 0x40, 0x41, 0x42, 0x42, 0x43, 0x44,
    0x44, 0x45, 0x46, 0x46, 0x47, 0x48, 0x48, 0x49,
    0x4A, 0x4A, 0x4B, 0x4B, 0x4C, 0x4C, 0x4D, 0x4D,
    0x4E, 0x4E, 0x4F, 0x4F, 0x50, 0x50, 0x51, 0x51,
    0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x54, 0x54,
    0x54, 0x54, 0x55, 0x55, 0x55, 0x55, 0x55, 0x56,
    0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56,
    0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56,
    0x56, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x54,
    0x54, 0x54, 0x53, 0x53, 0x53, 0x52, 0x52, 0x51,
    0x51, 0x51, 0x50, 0x50, 0x4F, 0x4F, 0x4E, 0x4E,
    0x4D, 0x4D, 0x4C, 0x4C, 0x4B, 0x4B, 0x4A, 0x4A,
    0x49, 0x48, 0x48, 0x47, 0x46, 0x46, 0x45, 0x44,
    0x44, 0x43, 0x42, 0x42, 0x41, 0x40, 0x40, 0x3F,
    0x3E, 0x3D, 0x3D, 0x3C, 0x3B, 0x3B, 0x3A, 0x39,
    0x38, 0x38, 0x37, 0x36, 0x35, 0x34, 0x34, 0x33,
    0x32, 0x31, 0x31, 0x30, 0x2F, 0x2E, 0x2E, 0x2D,
    0x2C, 0x2B, 0x2B, 0x2A, 0x29, 0x28, 0x28, 0x27,
    0x26, 0x25, 0x25, 0x24, 0x23, 0x22, 0x22, 0x21,
    0x20, 0x20, 0x1F, 0x1E, 0x1E, 0x1D, 0x1C, 0x1B,
    0x1B, 0x1A, 0x19, 0x19, 0x18, 0x18, 0x17, 0x16,
    0x16, 0x15, 0x14, 0x14, 0x13, 0x13, 0x12, 0x11,
    0x11, 0x10, 0x10, 0x0F, 0x0F, 0x0E, 0x0E, 0x0D
#endif

#if RGBLIGHT_BREATHE_TABLE_SIZE == 128
    0x0D, 0x0E, 0x0F, 0x10,
    0x11, 0x13, 0x14, 0x15,
    0x16, 0x18, 0x19, 0x1A,
    0x1B, 0x1D, 0x1E, 0x20,
    0x21, 0x22, 0x24, 0x25,
    0x27, 0x28, 0x2A, 0x2B,
    0x2D, 0x2E, 0x30, 0x31,
    0x33, 0x34, 0x36, 0x38,
    0x39, 0x3B, 0x3C, 0x3D,
    0x3F, 0x40, 0x42, 0x43,
    0x44, 0x46, 0x47, 0x48,
    0x4A, 0x4B, 0x4C, 0x4D,
    0x4E, 0x4F, 0x50, 0x51,
    0x51, 0x52, 0x53, 0x54,
    0x54, 0x55, 0x55, 0x55,
    0x56, 0x56, 0x56, 0x56,
    0x56, 0x56, 0x56, 0x56,
    0x56, 0x55, 0x55, 0x54,
    0x54, 0x53, 0x53, 0x52,
    0x51, 0x50, 0x4F, 0x4E,
    0x4D, 0x4C, 0x4B, 0x4A,
    0x49, 0x48, 0x46, 0x45,
    0x44, 0x42, 0x41, 0x40,
    0x3E, 0x3D, 0x3B, 0x3A,
    0x38, 0x37, 0x35, 0x34,
    0x32, 0x31, 0x2F, 0x2E,
    0x2C, 0x2B, 0x29, 0x28,
    0x26, 0x25, 0x23, 0x22,
    0x20, 0x1F, 0x1E, 0x1C,
    0x1B, 0x19, 0x18, 0x17,
    0x16, 0x14, 0x13, 0x12,
    0x11, 0x10, 0x0F, 0x0E
#endif

#if RGBLIGHT_BREATHE_TABLE_SIZE == 64
    0x0D, 0x0F,
    0x11, 0x14,
    0x16, 0x19,
    0x1B, 0x1E,
    0x21, 0x24,
    0x27, 0x2A,
    0x2D, 0x30,
    0x33, 0x36,
    0x39, 0x3C,
    0x3F, 0x42,
    0x44, 0x47,
    0x4A, 0x4C,
    0x4E, 0x50,
    0x51, 0x53,
    0x54, 0x55,
    0x56, 0x56,
    0x56, 0x56,
    0x56, 0x55,
    0x54, 0x53,
    0x51, 0x4F,
    0x4D, 0x4B,
    0x49, 0x46,
    0x44, 0x41,
    0x3E, 0x3B,
    0x38, 0x35,
    0x32, 0x2F,
    0x2C, 0x29,
    0x26, 0x23,
    0x20, 0x1E,
    0x1B, 0x18,
    0x16, 0x13,
    0x11, 0x0F
#endif
};

static const int table_scale = 256 / sizeof(rgblight_effect_breathe_table);
