# Helix 5 rows JIS layout

## コンセプト

このキーマップは日本語JISキーボード配列を利用しているユーザーが無理なく操作出来るというコンセプトで作成しました。以下の特徴があります。  

* 日本語の長音記号をレイヤーを移動せずに入力可能なように考慮しています
* 入りきらない記号関連をLowerレイヤーに位置関係を維持して配置しています
* 十字キーを凸配置にしています
* Ctrl,Shift,Tab,漢字,Esc,GUI(Win),Appの各キーは位置関係を維持して配置しています
* Lower/Raiseキーマップは暗記しないでも使えるようにわかりやすい配置を考慮しています

　またこのキーマップにはHelixの分割されたキーボードを通常通りに使用する「NORMAL」キーマップと、キー位置の最適化のためにHelixの分割されたキーボードの左右を交換して使う「EXCHANGE」キーマップをバイナリの書き換えなしに切り替えられるようにしています。これらにはさらに以下の特徴があります。  

### NORMALキーマップ

* Nキーを左人差し指で、Bキーを右人差し指で押下することが可能

### EXCHANGEキーマップ

* Pro micro下の2キーを有効に使うことにより、NORMALのベースキーマップに```[{```,```}]```,```/?```の各キーを追加し、```\_```キー以外の入力をベースマップで可能にしています
* 漢字キー,Enterキーの押し間違いを避けるためPro micro下の2キーに移動しています

## カスタマイズ

Normal/Exchangeにそれぞれ、Base,Lower,Raiseの各レイヤーを備え、2マップ3レイヤー、共通1レイヤー（Adjust）の全7種のレイヤーを備えています。  
ファームの書き換えなしにキーマップを別のものに切り替えられるので、片方は通常のキーマップ、もう片方は画像や動画編集用のキーマップや別の変態配置のキーマップにすれば、状況に応じて簡単に切り替えられます。

## 配列

### NORMAL

　Adjust + ModNrmキーでNORMALキーマップに切り替わります。  

#### Baseレイヤー  

```
 ,-----------------------------------------.             ,-----------------------------------------.
 | Esc  |  1!  |  2"  |  3#  |  4$  |  5%  |             |  6&  |  7'  |  8(  |  9)  |   0  |  -=  |
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 | KANJI|   Q  |   W  |   E  |   R  |   T  |             |   Y  |   U  |   I  |   O  |   P  |  @`  |
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 | Tab  |   A  |   S  |   D  |   F  |   G  |             |   H  |   J  |   K  |   L  |  ;+  |  :*  |
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 | Shift|   Z  |   X  |   C  |   V  |   B  |   N  |   B  |   N  |   M  |  ,<  |  .>  |  Up  |Enter |
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |Adjust|Lower |Space |Bksp  |Space |Space |Raise | APP  | Left | Down |Right |
 `-------------------------------------------------------------------------------------------------'
```

#### Lowerレイヤー  

　記号キーと、BackSpace位置にDeleteキーを配置しています。  
　例えば```|```キーを入力する場合、Lower + Shift + \キーで入力することが出来ます。

```
 ,-----------------------------------------.             ,-----------------------------------------.
 |      |      |      |      |      |      |             |      |      |      |  -=  |  ^~  |  \|  |
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 |      |      |      |      |      |      |             |      |      |      |      |  @`  |  [{  |
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 |      |      |      |      |      |      |             |      |      |      |  ;+  |  :*  |  ]}  |
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 |      |      |      |      |      |      |      |      |      |      |  ,<  |  .>  |  /?  |  \_  |
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 |      |      |      |      |      |      | Del  |      |      |      |      |      |      |      |
 `-------------------------------------------------------------------------------------------------'
```

#### Raiseレイヤー  

　rules.mkのMOUSEKEY_ENABLEをyesにした場合マウスキーを利用できます。ただしバイナリ容量を食いますのでmakeした時に確認できるバイナリサイズがオーバーしていないことに十分注意してください。  
　また、F1-F12キーをHHKBライクに使えるように横並びにしました。  

```
 ,-----------------------------------------.             ,-----------------------------------------.
 |      |  F1  |  F2  |  F3  |  F4  |  F5  |             |  F6  |  F7  |  F8  |  F9  | F10  | F11  |
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 |      |      |      |      |      |      |             | F12  |      |      |      | Home |PageUp|
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 |      |      |      |      |      |      |             |      |      |      |      | End  |PageDn|
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 |      |MsBtn1|MsBtn2|      |      |      |      |      |      |      |      |      | MsUp |      |
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 |      |      |      |      |      |      |      |      |      |      |      |MsLeft|MsDown|MsRght|
 `-------------------------------------------------------------------------------------------------'
```

### EXCHANGEキーマップ

　Adjust + ModExcキーでEXCHANGEキーマップに切り替わります。  
　HelixのUSBやフォンケーブルの接続は変更せず、分割された左右のキーボードを入れ替えて使います。  

#### Baseレイヤー  

　ちょっと無理やりですが```[{```,```}]```キーを突っ込んでいます。  

```
        ,-----------------------------------------.,-----------------------------------------.
        | Esc  |  1!  |  2"  |  3#  |  4$  |  5%  ||  6&  |  7'  |  8(  |  9)  |   0  |  -=  |
        |------+------+------+------+------+------||------+------+------+------+------+------|
        | Tab  |   Q  |   W  |   E  |   R  |   T  ||   Y  |   U  |   I  |   O  |   P  |  @`  |
        |------+------+------+------+------+------||------+------+------+------+------+------|
        |      |   A  |   S  |   D  |   F  |   G  ||   H  |   J  |   K  |   L  |  ;+  |  :*  |
 ,------+------+------+------+------+------+------||------+------+------+------+------+------+------.
 |KANJI | Shift|   Z  |   X  |   C  |   V  |   B  ||   N  |   M  |  ,<  |  .>  |  /?  |  Up  |Enter |
 |------+------+------+------+------+------+------||------+------+------+------+------+------+------|
 |Adjust| Ctrl | GUI  | Alt  |  [{  |Lower | Bksp ||Space |Raise |  }]  | APP  | Left | Down |Right |
 `------------------------------------------------'`------------------------------------------------'
```

#### Lowerレイヤー  

　記号キーと、BackSpace位置にDeleteキーを配置しています。  
　PageDown/Up, Home/EndをCtrl+十字キーの延長線上で使用できるように配置しています。  

```
        ,-----------------------------------------.,-----------------------------------------.
        |      |      |      |      |      |      ||      |      |      |  -=  |  ^~  |  \|  |
        |------+------+------+------+------+------||------+------+------+------+------+------|
        |      |      |      |      |      |      ||      |      |      |      |  @`  |  [{  |
        |------+------+------+------+------+------||------+------+------+------+------+------|
        |      |      |      |      |      |      ||      |      |      |  ;+  |  :*  |  ]}  |
 ,------+------+------+------+------+------+------||------+------+------+------+------+------+------.
 |      |      |      |      |      |      |      ||      |  ,<  |  .>  |  /?  |  \_  |PageUp|      |
 |------+------+------+------+------+------+------||------+------+------+------+------+------+------|
 |      |      |      |      |      |      | Del  ||      |      |      |      | Home |PageDn| End  |
 `------------------------------------------------'`------------------------------------------------'
```

#### Raiseレイヤー  

　rules.mkのMOUSEKEY_ENABLEをyesにした場合マウスキーを利用できます。ただしバイナリ容量を食いますのでmakeした時に確認できるバイナリサイズがオーバーしていないことに十分注意してください。  
　また、F1-F12キーをHHKBライクに使えるように横並びにしました。  
　マウスキーは十字キーの延長線上で使用できるように配置しています。  

```
        ,-----------------------------------------.,-----------------------------------------.
        |      |  F1  |  F2  |  F3  |  F4  |  F5  ||  F6  |  F7  |  F8  |  F9  |  F10 |  F11 |
        |------+------+------+------+------+------||------+------+------+------+------+------|
        |      |      |      |      |      |      || F12  |      |      |      |      |      |
        |------+------+------+------+------+------||------+------+------+------+------+------|
        |      |      |      |      |      |      ||      |      |      |      |      |      |
 ,------+------+------+------+------+------+------||------+------+------+------+------+------+------.
 |      |      |MsBtn1|MsBtn2|      |      |      ||      |      |      |      |      | MsUp |      |
 |------+------+------+------+------+------+------||------+------+------+------+------+------+------|
 |      |      |      |      |      |      |      ||      |      |      |      |MsLeft|MsDown|MsRght|
 `------------------------------------------------'`------------------------------------------------'
```

### NORMAL/EXCHANGE共通レイヤー

Adjustレイヤー

　NORMAL/EXCHANGE共通で利用するレイヤーです。共通で使えるように両側同じ並びで同じものを配置しています。  

```
 ,-----------------------------------------.             ,-----------------------------------------.
 |      | Reset|RGBRST|Aud on|Audoff|      |             |      | Reset|RGBRST|Aud on|Audoff|      |
 |------+------+------+------+------+------|             |------+------+------+------+------+------|
 |      |ModNrm|ModExc| Mac  | Win  |      |             |      |ModNrm|ModExc| Mac  | Win  |      |
 |------+------+------+------+------+------|             |------+------+------+------+------|------+
 |      |RGB ON| HUE+ | SAT+ | VAL+ |      |             |      |RGB ON| HUE+ | SAT+ | VAL+ |      |
 |------+------+------+------+------+------+------+------+------+------+------+------+------|------+
 |      | MODE | HUE- | SAT- | VAL- |      |      |      |      | MODE | HUE- | SAT- | VAL- |      |
 |------+------+------+------+------+------+------+------+------+------+------+------+------+------|
 |      |      |      |      |      |      |      |      |      |      |      |      |      |      |
 `-------------------------------------------------------------------------------------------------'
```

## コンパイルの仕方

　Defaultキーマップのreadmeを参照してください。  
