/* Copyright 2021 HorrorTroll <https://github.com/HorrorTroll>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "quantum.h"

#define XXX KC_NO

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴──┬┴──┬┴──┬───┼───┼───┤
 * │40  │41  │42  │46                      │48 │49 │4A │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴───┴───┴───┴───┴───┴───┘
 */

#define LAYOUT_all( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48, K49, K4A, K4B, K4C, K4D  \
) { \
    { K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
    { K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, K49, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40  │41  │42  │46                      │48   │4A   │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_all_noblocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40  │41  │42  │46                      │48   │4A   │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_ansi_noblocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40  │41  │42  │46                      │48   │4A   │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_ansi_noblocker_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40  │41  │42  │46                      │48   │4A   │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_iso_noblocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40  │41  │42  │46                      │48   │4A   │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_iso_noblocker_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬─┬───┼───┼───┤
 * │40  │41  │42  │46                      │48  │49  │ │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴────┴────┘ └───┴───┴───┘
 */

#define LAYOUT_65_all_blocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬─┬───┼───┼───┤
 * │40  │41  │42  │46                      │48  │49  │ │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴────┴────┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_blocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬─┬───┼───┼───┤
 * │40  │41  │42  │46                      │48  │49  │ │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴────┴────┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_blocker_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬─┬───┼───┼───┤
 * │40  │41  │42  │46                      │48  │49  │ │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴────┴────┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_blocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬─┬───┼───┼───┤
 * │40  │41  │42  │46                      │48  │49  │ │4B │4C │4D │
 * └────┴────┴────┴────────────────────────┴────┴────┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_blocker_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,  K41,  K42,               K46,               K48,  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40   │41   │46                         │48   │4A   │4B │4C │4D │
 * └─────┴─────┴───────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_all_7u_noblocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41,                  K46,                 K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├─────┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40   │41   │46                         │48   │4A   │4B │4C │4D │
 * └─────┴─────┴───────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_noblocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41,                  K46,                 K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├─────┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40   │41   │46                         │48   │4A   │4B │4C │4D │
 * └─────┴─────┴───────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_noblocker_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41,                  K46,                 K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40   │41   │46                         │48   │4A   │4B │4C │4D │
 * └─────┴─────┴───────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_noblocker( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41,                  K46,                 K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┼───┼───┤
 * │40   │41   │46                         │48   │4A   │4B │4C │4D │
 * └─────┴─────┴───────────────────────────┴─────┴─────┴───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_noblocker_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41,                  K46,                 K48,   K4A,    K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, XXX, K4A, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │41 │42   │46                         │49   │ │4B │4C │4D │
 * └─────┴───┴─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_all_7u_wk( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41, K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├─────┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │41 │42   │46                         │49   │ │4B │4C │4D │
 * └─────┴───┴─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_wk( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41, K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├─────┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │41 │42   │46                         │49   │ │4B │4C │4D │
 * └─────┴───┴─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_wk_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41, K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │41 │42   │46                         │49   │ │4B │4C │4D │
 * └─────┴───┴─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_wk( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41, K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │41 │42   │46                         │49   │ │4B │4C │4D │
 * └─────┴───┴─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_wk_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,   K41, K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │   │42   │46                         │49   │ │4B │4C │4D │
 * └─────┘   └─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_all_7u_wkl( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,        K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, XXX, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├─────┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │   │42   │46                         │49   │ │4B │4C │4D │
 * └─────┘   └─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_wkl( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,        K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, XXX, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├─────┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │   │42   │46                         │49   │ │4B │4C │4D │
 * └─────┘   └─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_wkl_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,        K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, XXX, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │   │42   │46                         │49   │ │4B │4C │4D │
 * └─────┘   └─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_wkl( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,        K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, XXX, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * ├────┴┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬─┬───┼───┼───┤
 * │40   │   │42   │46                         │49   │ │4B │4C │4D │
 * └─────┘   └─────┴───────────────────────────┴─────┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_wkl_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
    K40,        K42,                  K46,                  K49,     K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, XXX, K42, XXX, XXX, XXX, K46, XXX, XXX, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * └─┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴┬─┬───┼───┼───┤
 *   │40 │41   │46                         │48   │49 │ │4B │4C │4D │
 *   └───┴─────┴───────────────────────────┴─────┴───┘ └───┴───┴───┘
 */

#define LAYOUT_65_all_7u_hhkb( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
      K40, K41,                  K46,                  K48,   K49,   K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * └─┬───┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴┬─┬───┼───┼───┤
 *   │40 │41   │46                         │48   │49 │ │4B │4C │4D │
 *   └───┴─────┴───────────────────────────┴─────┴───┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_hhkb( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
      K40, K41,                  K46,                  K48,   K49,   K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │2C   │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┼───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │1D      │2E │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┼───┤
 * │30      │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * └─┬───┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴┬─┬───┼───┼───┤
 *   │40 │41   │46                         │48   │49 │ │4B │4C │4D │
 *   └───┴─────┴───────────────────────────┴─────┴───┘ └───┴───┴───┘
 */

#define LAYOUT_65_ansi_7u_hhkb_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,   K2C,  K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B,    K1D,    K2E, \
       K30,   K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
      K40, K41,                  K46,                  K48,   K49,   K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, XXX, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0E     │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * └─┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴┬─┬───┼───┼───┤
 *   │40 │41   │46                         │48   │49 │ │4B │4C │4D │
 *   └───┴─────┴───────────────────────────┴─────┴───┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_hhkb( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C,    K0E,   K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
      K40, K41,                  K46,                  K48,   K49,   K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, XXX, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}

/* ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐
 * │00 │01 │02 │03 │04 │05 │06 │07 │08 │09 │0A │0B │0C │0D │0E │4E │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┼───┤
 * │10   │11 │12 │13 │14 │15 │16 │17 │18 │19 │1A │1B │1C │     │1E │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┐1D  ├───┤
 * │20    │21 │22 │23 │24 │25 │26 │27 │28 │29 │2A │2B │2C │    │2E │
 * ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┼───┤
 * │30  │31 │32 │33 │34 │35 │36 │37 │38 │39 │3A │3B │3C    │3D │3E │
 * └─┬──┴┬──┴──┬┴───┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴┬─┬───┼───┼───┤
 *   │40 │41   │46                         │48   │49 │ │4B │4C │4D │
 *   └───┴─────┴───────────────────────────┴─────┴───┘ └───┴───┴───┘
 */

#define LAYOUT_65_iso_7u_hhkb_splitbs( \
    K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K4E, \
     K10,  K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C,         K1E, \
      K20,   K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K1D,  K2E, \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B,    K3C,   K3D, K3E, \
      K40, K41,                  K46,                  K48,   K49,   K4B, K4C, K4D  \
) { \
	{ K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E }, \
	{ K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, XXX, K2E }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E }, \
    { K40, K41, XXX, XXX, XXX, XXX, K46, XXX, K48, K49, XXX, K4B, K4C, K4D, K4E }  \
}
