/* Copyright 2021 imchipwood
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include QMK_KEYBOARD_H
#include "imchipwood.h"

// Layer names
enum custom_layers {
    _QWERTY,
    _NUM,
    _MED
};

// Layer definitions
const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
    [_QWERTY] = LAYOUT_ergodox_pretty(
/* Keymap 0: Basic layer
 *        ,--------------------------------------------------.                    ,--------------------------------------------------.
 *        |   =    |   1  |   2  |   3  |   4  |   5  | ESC  |                    |BkTick|   6  |   7  |   8  |   9  |   0  |   -    |
 *        |--------+------+------+------+------+-------------|                    |------+------+------+------+------+------+--------|
 *        | Tab    |   Q  |   W  |   E  |   R  |   T  | MEH  |                    |      |   Y  |   U  |   I  |   O  |   P  |   [    |
 *        |--------+------+------+------+------+------|      |                    |      |------+------+------+------+------+--------|
 *        | BkSlsh |   A  |   S  |   D  |   F  |   G  |------|                    |------|   H  |   J  |   K  |   L  |  ;   |   '    |
 *        |--------+------+------+------+------+------|MO(2) |                    |MO(2) |------+------+------+------+------+--------|
 *        | LSHIFT |   Z  |   X  |   C  |   V  |   B  |      |                    |      |   N  |   M  |   ,  |   .  |   /  |SHFT/CAP|
 *        `--------+------+------+------+------+-------------'                    `-------------+------+------+------+------+--------'
 *          |RCTRL | LALT | GUI  |L/HOME|R/END |                                                |  Up  | Down | LEFT |RIGHT |PRSCR |
 *          `----------------------------------'                                                `----------------------------------'
 *                                                       ,-------------.  ,-------------.
 *                                                       | DEL  | INS  |  | Ctrl |  Alt |
 *                                                ,------|------|------|  |------+--------+------.
 *                                                |      |      | Home |  | PgUp |        |      |
 *                                                |Enter |MO(1) |------|  |------|  Bksp  |Space |
 *                                                |      |      | End  |  | PgDn |        |      |
 *                                                `--------------------'  `----------------------'
 */
//                                                                                       Left hand   Right hand
//    ,------------------------------------------------------------------------------------------.   ,------------------------------------------------------------------------------------------.
        KC_EQL,      KC_1,        KC_2,        KC_3,        KC_4,        KC_5,        KC_ESC,          KC_GRV,      KC_6,        KC_7,        KC_8,        KC_9,        KC_0,        KC_MINS,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TAB,      KC_Q,        KC_W,        KC_E,        KC_R,        KC_T,        KC_MEH,          KC_TRNS,     KC_Y,        KC_U,        KC_I,        KC_O,        KC_P,        KC_LBRC,
//    |------------+------------+------------+------------+------------+------------+            |   |            +------------+------------+------------+------------+------------+------------|
        KC_BSLS,     KC_A,        KC_S,        KC_D,        KC_F,        KC_G,                                      KC_H,        KC_J,        KC_K,        KC_L,        KC_SCLN,     KC_QUOT,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_LSFT,     KC_Z,        KC_X,        KC_C,        KC_V,        KC_B,        MO(_MED),        MO(_MED),    KC_N,        KC_M,        KC_COMM,     KC_DOT,      KC_SLSH,     TD(TD_RSFT_CAPS),
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_LCTL,     KC_LALT,     KC_LGUI,     TD(TD_LOME), TD(TD_REND),                                                         KC_UP,       KC_DOWN,     KC_LEFT,     KC_RGHT,     KC_PSCR,
//     `---------------------------------------------------------------'                                                       `----------------------------------------------------------------'
//                                                                     ,-------------------------.   ,-------------------------.
                                                                         KC_DEL,      KC_INS,          KC_TRNS,     KC_TRNS,
//                                                        ,------------+------------+------------|   |------------+------------+------------.
                                                                                      KC_TRNS,         KC_TRNS,
//                                                        |            |            +------------|   |------------+            |            |
                                                            KC_ENT,      MO(_NUM),    KC_TRNS,         KC_TRNS,     KC_BSPC,     KC_SPC
//                                                        `--------------------------------------'   `--------------------------------------'
    ),
    [_NUM] = LAYOUT_ergodox_pretty(
/* Keymap 1: Numpad, function keys, and some convenience keys
 *        ,---------------------------------------------------.                   ,--------------------------------------------------.
 *        |         |  F1  |  F2  |  F3  |  F4  |  F5  |      |                   |  F12 |  F6  |  F7  |  F8  |  F9  |  F10 |   F11  |
 *        |---------+------+------+------+------+------+------|                   |------+------+------+------+------+------+--------|
 *        |         |      |  up  |      |      |      |      |                   |      |   7  |   8  |   9  |   *  |   /  |    ]   |
 *        |---------+------+------+------+------+------|      |                   |      |------+------+------+------+------+--------|
 *        |         | left | down |right |      |      |------|                   |------|   4  |   5  |   6  |   +  |   -  |        |
 *        |---------+------+------+------+------+------|      |                   |      |------+------+------+------+------+--------|
 *        |         |      |      |      |      |      |      |                   |      |   1  |   2  |   3  |   =  |  up  | enter  |
 *        `---------+------+------+------+------+-------------'                   `-------------+------+------+------+------+--------'
 *          |       |      |      | PgUp | PgDn |                                               |   0  |   .  | left | down |right |
 *          `-----------------------------------'                                               `----------------------------------'
 *                                                      ,-------------.   ,-------------.
 *                                                      |      |      |   |      |      |
 *                                               ,------|------|------|   |------+------+------.
 *                                               |      |      |      |   |      |      |      |
 *                                               |      |      |------|   |------| Del  | Esc  |
 *                                               |      |      |      |   |      |      |      |
 *                                               `--------------------'   `--------------------'
 */
//                                                    Left hand                   Right hand
//    ,------------------------------------------------------------------------------------------.   ,------------------------------------------------------------------------------------------.
        KC_TRNS,     KC_F1,       KC_F2,       KC_F3,       KC_F4,       TD(CTL_F5),  KC_TRNS,         KC_F12,      KC_F6,       TD(ALT_F7),  KC_F8,       KC_F9,       KC_F10,      KC_F11,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_TRNS,     KC_UP,       KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,         KC_TRNS,     KC_7,        KC_8,        KC_9,        KC_PAST,     KC_PSLS,     KC_RBRC,
//    |------------+------------+------------+------------+------------+------------+            |   |            +------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_LEFT,     KC_DOWN,     KC_RGHT,     KC_TRNS,     KC_TRNS,                                   KC_4,        KC_5,        KC_6,        KC_PPLS,     KC_PMNS,     KC_TRNS,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,         KC_TRNS,     KC_1,        KC_2,        KC_3,        KC_PEQL,     KC_UP,       KC_PENT,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_PGUP,     KC_PGDN,                                                             KC_0,        KC_PDOT,     KC_LEFT,     KC_DOWN,     KC_RGHT,
//     `---------------------------------------------------------------'                                                       `----------------------------------------------------------------'
//                                                                     ,-------------------------.   ,-------------------------.
                                                                         KC_TRNS,     KC_TRNS,         KC_TRNS,     KC_TRNS,
//                                                        ,------------+------------+------------|   |------------+------------+------------.
                                                                                      KC_TRNS,         KC_TRNS,
//                                                        |            |            +------------|   |------------+            |            |
                                                            KC_TRNS,     KC_TRNS,     KC_TRNS,         KC_TRNS,     KC_DEL,      KC_ESC
//                                                        `--------------------------------------'   `--------------------------------------'
    ),
    [_MED] = LAYOUT_ergodox_pretty(
/* Keymap 2: Media and mouse keys
 *         ,--------------------------------------------------.                   ,--------------------------------------------------.
 *         |        |      |      |      |      |      |      |                   |      |      |      |      |      |      | Mute   |
 *         |--------+------+------+------+------+-------------|                   |------+------+------+------+------+------+--------|
 *         |        |      | MsUp |      |      |      |      |                   |      | MP7  | MP8  | MP9  |      |      |        |
 *         |--------+------+------+------+------+------|      |                   |      |------+------+------+------+------+--------|
 *         |        |MsLeft|MsDown|MsRght|      |      |------|                   |------| MP4  | MP5  | MP6  |      |      |        |
 *         |--------+------+------+------+------+------|      |                   |      |------+------+------+------+------+--------|
 *         |        |      |      |      |      |      |      |                   |      | MP1  | MP2  | MP3  |      |VolUp |        |
 *         `--------+------+------+------+------+-------------'                   `-------------+------+------+------+------+--------'
 *           |      |      |      | Lclk | Rclk |                                               |      |      | Prev |VolDn | Next |
 *           `----------------------------------'                                               `----------------------------------'
 *                                                      ,-------------.   ,-------------.
 *                                                      |QK_BOOT |      |   |      |      |
 *                                               ,------|------|------|   |------+------+------.
 *                                               |      |      |      |   |      |      |      |
 *                                               |MPENT |      |------|   |------|      |Play  |
 *                                               |      |      |      |   |      |      |      |
 *                                               `--------------------'   `--------------------'
 */
//                                                    Left hand                   Right hand
//    ,------------------------------------------------------------------------------------------.   ,------------------------------------------------------------------------------------------.
        KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,         KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_MUTE,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_TRNS,     KC_MS_U,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,         KC_TRNS,     MEH(KC_P7),  MEH(KC_P8),  MEH(KC_P9),  KC_TRNS,     KC_TRNS,     KC_TRNS,
//    |------------+------------+------------+------------+------------+------------+            |   |            +------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_MS_L,     KC_MS_D,     KC_MS_R,     KC_TRNS,     KC_TRNS,                                   MEH(KC_P4),  MEH(KC_P5),  MEH(KC_P6),  KC_TRNS,     KC_TRNS,     KC_TRNS,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_TRNS,         KC_TRNS,     MEH(KC_P1),  MEH(KC_P2),  MEH(KC_P3),  KC_TRNS,     KC_VOLU,     KC_TRNS,
//    |------------+------------+------------+------------+------------+------------+------------|   |------------+------------+------------+------------+------------+------------+------------|
        KC_TRNS,     KC_TRNS,     KC_TRNS,     KC_BTN1,     KC_BTN2,                                                             KC_TRNS,     KC_TRNS,     KC_MPRV,     KC_VOLD,     KC_MNXT,
//     `---------------------------------------------------------------'                                                       `----------------------------------------------------------------'
//                                                                     ,-------------------------.   ,-------------------------.
                                                                         QK_BOOT,     KC_TRNS,         KC_TRNS,     KC_TRNS,
//                                                        ,------------+------------+------------|   |------------+------------+------------.
                                                                                      KC_TRNS,         KC_TRNS,
//                                                        |            |            +------------|   |------------+            |            |
                                                           MEH(KC_PENT), KC_TRNS,     KC_TRNS,         KC_TRNS,     KC_TRNS,     KC_MPLY
//                                                        `--------------------------------------'   `--------------------------------------'
    )
};
