// Copyright 2022 Vino Rodrigues (@vinorodrigues)
// SPDX-License-Identifier: GPL-2.0-or-later

#include "id63.h"

#define __ NO_LED

#ifdef RGB_MATRIX_ENABLE

/* Pre-key LED addresses
 * ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┐
 * │62 │61 │60 │59 │58 │57 │56 │55 │54 │53 │52 │51 │50 │  49   │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤
 * │ 48  │47 │46 │45 │44 │43 │42 │41 │40 │39 │38 │37 │36 │ 35  │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤
 * │  34  │33 │32 │31 │30 │29 │28 │27 │26 │25 │24 │23 │   22   │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┴┬───┬───┤
 * │   21   │20 │19 │18 │17 │16 │15 │14 │13 │12 │  11  │10 │ 9 │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴──┬┴──┬───┼───┼───┤
 * │ 8  │ 7  │ 6  │            5           │ 4 │ 3 │ 2 │ 1 │ 0 │
 * └────┴────┴────┴────────────────────────┴───┴───┴───┴───┴───┘
 *
 * Underglow LED addresses (as seen from top / [Esc] = top left)
 * ┌────┬────┬────┬────┬────┬────┐
 * │ 63 │ 64 │ 65 │ 66 │ 67 │ 68 │
 * ├────┴────┴────┴────┴────┴────┤
 * ├────┬────┬────┬────┬────┬────┤
 * │ 74 │ 73 │ 72 │ 71 │ 70 │ 69 │
 * └────┴────┴────┴────┴────┴────┘
 */

led_config_t g_led_config = { {
    // Key Matrix to LED Index
    {  62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49 },
    {  48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35 },
    {  34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, __, 22 },
    {  21, __, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9  },
    {  8,  7,  __, 6,  __, __, 5,  __, __, 4,  3,  2,  1,  0  },
}, {
    // LED Index to Physical Position
    // generated from: https://xelus.netlify.app/guides/KLE_to_RGB_parser
    /* NB: Reverse & upside-down order! */
    {224,64 }, {208,64 }, {192,64 }, {176,64 }, {160,64 },                       {102,64 },                       { 42,64 },            { 22,64 }, {  2,64 },
    {224,48 }, {208,48 }, {186,48 }, {164,48 }, {148,48 }, {132,48 }, {116,48 }, {100,48 }, { 84,48 }, { 68,48 }, { 52,48 }, { 36,48 },            { 10,48 },
    {214,32 },            {188,32 }, {172,32 }, {156,32 }, {140,32 }, {124,32 }, {108,32 }, { 92,32 }, { 76,32 }, { 60,32 }, { 44,32 }, { 28,32 }, {  6,32 },
    {220,16 }, {200,16 }, {184,16 }, {168,16 }, {152,16 }, {136,16 }, {120,16 }, {104,16 }, { 88,16 }, { 72,16 }, { 56,16 }, { 40,16 }, { 24,16 }, {  4,16 },
    {216,0  }, {192,0  }, {176,0  }, {160,0  }, {144,0  }, {128,0  }, {112,0  }, { 96,0  }, { 80,0  }, { 64,0  }, { 48,0  }, { 32,0  }, { 16,0  }, {  0,0  }
    // underglow LEDs (positions pushed to nearest edge to match edge key colors)
    #ifndef ID63_DISABLE_UNDERGLOW
    , {  0,0  }, { 45,0  }, { 90,0  }, {134,0  }, {179,0  }, {224,0  },
    {224,64 }, {179,64 }, {134,64 }, { 90,64 }, { 45,64 }, {  0,64 }
    #endif
}, {
    // LED Index to Flag
    /* NB: Reverse & upside-down order! */
    4, 4, 4, 1, 1,       4,       1,    1, 1,
    1, 4, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4,    1,
    1,    1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 9,
    1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1,
    1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
    // underglow LEDs
    #ifndef ID63_DISABLE_UNDERGLOW
    , 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2
    #endif
} };

#endif  // RGB_MATRIX_ENABLE
