// Copyright 2022 Vino Rodrigues (@vinorodrigues)
// SPDX-License-Identifier: GPL-2.0-or-later

#include "ansi.h"

#define __ NO_LED

#ifdef RGB_MATRIX_ENABLE

/* Per-key LED's
 * ┌───┐┌───┬───┬───┬───┐┌───┬───┬───┬───┐┌───┬───┬───┬───┐┌───┐┌───┐
 * │79 ││78 │77 │76 │75 ││74 │73 │72 │71 ││70 │69 │68 │67 ││66 ││65 │
 * ├───┼┴──┬┴──┬┴──┬┴──┬┴┴─┬─┴─┬─┴─┬─┴─┬─┴┴┬──┴┬──┴┬──┴┬──┴┴───┤├───┤
 * │64 │63 │62 │61 │60 │59 │58 │57 │56 │55 │54 │53 │52 │  51   ││50 │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤├───┤
 * │ 49  │48 │47 │46 │45 │44 │43 │42 │41 │40 │39 │38 │37 │ 36  ││35 │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤└───┘
 * │  34  │33 │32 │31 │30 │29 │28 │27 │26 │25 │24 │23 │   22   │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┘
 * │   21   │20 │19 │18 │17 │16 │15 │14 │13 │12 │11 │  10  │┌───┐
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┴┬──┴──┬───┘│ 9 │
 * │  8 │  7 │  6 │            5           │  4  │  3  │┌───┼───┼───┐
 * └────┴────┴────┴────────────────────────┴─────┴─────┘│ 2 │ 1 │ 0 │
 *                                                      └───┴───┴───┘
 * Underglow (as seen from top)
 * ┌────┬────┬────┬────┬────┬────┐
 * │ 80 │ 81 │ 82 │ 83 │ 84 │ 85 │
 * ├────┼────┴────┴────┴────┼────┤
 * │ 93 │                   │ 86 │
 * ├────┼────┬────┬────┬────┼────┤
 * │ 92 │ 91 │ 90 │ 89 │ 88 │ 87 │
 * └────┴────┴────┴────┴────┴────┘
 */

led_config_t g_led_config = { {
    // Key Matrix to LED Index
    /* Generated with: https://xelus.netlify.app/guides/KLE_to_RGB_parser */
    {   8,  21,  34,  49,  64,  79,  __,  __,  __,  __,  __ },
    {   7,  __,  33,  48,  63,  78,  __,  __,  __,  __,  __ },
    {   6,  20,  32,  47,  62,  77,  __,  __,  35,  50,  65 },
    {   0,  19,  31,  46,  61,  76,   9,  __,  36,  __,  67 },
    {   1,  18,  30,  45,  60,  75,  10,  22,  37,  52,  68 },
    {   2,  17,  29,  44,  59,  74,  11,  23,  38,  53,  69 },
    {   5,  16,  28,  43,  58,  73,  __,  __,  __,  51,  66 },
    {   3,  15,  27,  42,  57,  72,  12,  24,  39,  54,  70 },
    {   4,  14,  26,  41,  56,  71,  13,  25,  40,  55,  __ },
}, {
    /* NB: Reversed order */
    // per-key
    {224,64 }, {209,64 }, {195,64 },                       {173,61 }, {151,61 },                       { 94,61 },                       { 39,61 }, { 20,61 }, {  2,61 },
               {209,52 }, {185,49 }, {165,49 }, {151,49 }, {136,49 }, {121,49 }, {106,49 }, { 92,49 }, { 77,49 }, { 62,49 }, { 48,49 }, { 33,49 },            {  9,49 },
               {196,38 },            {173,38 }, {158,38 }, {143,38 }, {129,38 }, {114,38 }, { 99,38 }, { 84,38 }, { 70,38 }, { 55,38 }, { 40,38 }, { 26,38 }, {  6,38 },
    {224,26 }, {202,26 }, {184,26 }, {169,26 }, {154,26 }, {140,26 }, {125,26 }, {110,26 }, { 95,26 }, { 81,26 }, { 66,26 }, { 51,26 }, { 37,26 }, { 22,26 }, {  4,26 },
    {224,15 }, {198,15 }, {176,15 }, {162,15 }, {147,15 }, {132,15 }, {118,15 }, {103,15 }, { 88,15 }, { 73,15 }, { 59,15 }, { 44,15 }, { 29,15 }, { 15,15 }, {  0,15 },
    {224,0  }, {206,0  }, {187,0  }, {173,0  }, {158,0  }, {143,0  }, {125,0  }, {110,0  }, { 95,0  }, { 81,0  }, { 62,0  }, { 48,0  }, { 33,0  }, { 18,0  }, {  0,0  },
    // underglow
    {  0,0  }, { 45,0  }, { 90,0  }, {134,0  }, {179,0  }, {224,0  },
    {224,32 },
    {224,64 }, {179,64 }, {134,64 }, { 90,64 }, { 45,64 }, {  0,64 },
    {  0,32 }
}, {
    /* NB: Reversed order */
    4, 4, 4,       4, 4,       1,       4, 4, 4,
       4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,    4,
       4,    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4,
    4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4,
    4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    //
    2, 2, 2, 2, 2, 2,
    2,
    2, 2, 2, 2, 2, 2,
    2
} };

#endif
