// Copyright 2022 vinorodrigues (@vinorodrigues)
// SPDX-License-Identifier: GPL-2.0-or-later

#include "v2.h"

#define __ NO_LED

#if defined(RGB_MATRIX_ENABLE)

/* Under-, Per-Key
 * ┌───┐   ┌───┬───┬───┬───┐ ┌───┬───┬───┬───┐ ┌───┬───┬───┬───┐ ┌───┬───┬───┐
 * │102│   │101│100│99 │98 │ │97 │96 │95 │94 │ │93 │92 │91 │90 │ │89 │88 │87 │
 * └───┘   └───┴───┴───┴───┘ └───┴───┴───┴───┘ └───┴───┴───┴───┘ └───┴───┴───┘
 * ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┐ ┌───┬───┬───┐
 * │70 │71 │72 │73 │74 │75 │76 │77 │78 │79 │80 │81 │82 │  83   │ │84 │85 │86 │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤ ├───┼───┼───┤
 * │  69 │68 │67 │66 │65 │64 │63 │62 │61 │60 │59 │58 │57 │ 56  │ │55 │54 │53 │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤ └───┴───┴───┘
 * │  40  │41 │42 │43 │44 │45 │46 │47 │48 │49 │50 │51 │  52    │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────────┤     ┌───┐
 * │   39   │38 │37 │36 │35 │34 │33 │32 │31 │30 │29 │    28    │     │27 │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬────┤ ┌───┼───┼───┐
 * │ 16 │ 17 │ 18 │           19           │ 20 │ 21 │ 22 │ 23 │ │24 │25 │26 │
 * └────┴────┴────┴────────────────────────┴────┴────┴────┴────┘ └───┴───┴───┘
 *
 * Underglow (as seen from top)
 * ┌───┬───┬───┬───┬───┬───┬───┐
 * │14 │13 │12 │11 │10 │ 9 │ 8 │
 * ├───┼───┴───┴───┴───┴───┼───┤
 * │15 │                   │ 7 │
 * ├───┼───┬───┬───┬───┬───┼───┤
 * │ 0 │ 1 │ 2 │ 3 │ 4 │ 5 │ 6 │
 * └───┴───┴───┴───┴───┴───┴───┘
*/
led_config_t g_led_config = { {
    // Key Matrix to LED Index
    // partially generated from: https://xelus.netlify.app/guides/KLE_to_RGB_parser & CSV Excel formula

    { 102, __, 101, 100, 99, 98, 97, 96, 95 },
    { 70,  71,  72, 73,  74, 75, 76, 77, 78 },
    { 69,  68,  67, 66,  65, 64, 63, 62, 61 },
    { 40,  41,  42, 43,  44, 45, 46, 47, 48 },
    { 39,  __,  38, 37,  36, 35, 34, 33, 32 },
    { 16,  17,  18, 23,  22, __, 19, 21, 20 },
    { __,  87,  88, 90,  91, 92, 89, 93, 94 },
    { 80,  86,  85, 83,  __, 82, 84, 81, 79 },
    { __,  53,  54, 56,  57, 58, 55, 59, 60 },
    { __,  __,  27, 52,  __, 51, __, 50, 49 },
    { __,  26,  25, __,  28, 29, 24, 30, 31 }
}, {
    // LED Index to Physical Position
    // generated from: https://xelus.netlify.app/guides/KLE_to_RGB_parser
    // underglow
    /* colors are pushed to the edge as only the edges can be seen */
    {  0,64 }, { 37,64 }, { 75,64 }, {112,64 }, {149,64 }, {187,64 }, {224,64 },
    {224,32 },
    {224,0  }, {187,0  }, {149,0  }, {112,0  }, { 75,0  }, { 37,0  }, {  0,0  },
    {  0,32  },
    // under-, per-key
    /* pattern is complex; starts at btm-lft, zig-zags up, and ends top-lft */
    {  2,64 }, { 18,64 }, { 34,64 }, { 83,64 }, {131,64 }, {148,64 }, {164,64 }, {180,64 }, {198,64 }, {211,64 }, {224,64 },  // lf-2-rt, btm
    {211,52 }, {170,52 }, {146,52 }, {133,52 }, {120,52 }, {107,52 }, { 94,52 }, { 81,52 }, { 68,52 }, { 55,52 }, { 42,52 }, { 29,52 }, {  8,52 },  // rt-2-lf**
    {  5,40 }, { 23,40 }, { 36,40 }, { 49,40 }, { 62,40 }, { 75,40 }, { 88,40 }, {101,40 }, {114,40 }, {127,40 }, {140,40 }, {153,40 }, {174,40 },  // lf-2-rt
    {224,27 }, {211,27 }, {198,27 }, {179,27 }, {162,27 }, {149,27 }, {136,27 }, {123,27 }, {110,27 }, { 97,27 }, { 84,27 }, { 71,27 }, { 58,27 }, { 45,27 }, { 32,27 }, { 19,27 }, {  3,27 },  // rt-2-lf**
    {  0,15 }, { 13,15 }, { 26,15 }, { 39,15 }, { 52,15 }, { 65,15 }, { 78,15 }, { 91,15 }, {104,15 }, {117,15 }, {130,15 }, {143,15 }, {156,15 }, {175,15 }, {198,15 }, {211,15 }, {224,15 },  // lf-2-rt
    {224,0  }, {211,0  }, {198,0  }, {182,0  }, {169,0  }, {156,0  }, {143,0  }, {123,0  }, {110,0  }, { 97,0  }, { 84,0  }, { 65,0  }, { 52,0  }, { 39,0  }, { 26,0  }, {  0,0  },  // rt-2-lf**, top
}, {
    // LED Index to Flag
    // underglow
    2, 2, 2, 2, 2, 2, 2,
    2,
    2, 2, 2, 2, 2, 2, 2,
    2,
    // under-, per-key
    1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1,
    1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1,
    1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
} };

#endif  // RGB_MATRIX_ENABLE
