# [🐦 @rjhilgefort](https://twitter.com/rjhilgefort)'s Ergodox Infinity Layout

The layout is heavily inspired by my [Atreus 2](https://atreus.technomancy.us/2) and the layout I use for it. Hence, I basically treat my Ergodox Infinity like it's a 40% keyboard and have even taken off the caps of the keys that I don't make use of to further emphasize this. This allows for easy interop between my office setup (Ergodox) and my laptop setup (Atreus 2).

![](https://imgur.com/rJnSjLq.jpg)
![](https://imgur.com/8aSSGP1.jpg)

## Features

Here's some highlights/features of the layout.

-   Inspired by 40% keyboards, doesn't use keys that don't exist on those boards.
-   Ergonomic symbols layer.
-   Media and Numpad layer.
-   Planck-like extra tri-layer when holding the other two layers.
-   Planck conformability- leaves gutter keys for familiarity if coming from there.
-   Supports Mac and Linux as 1st class citizens giving each a dedicated base layer and a media layer for each that matches media keys for each OS. The Linux default layer focuses on `Ctrl` instead of `Super` and vice versa for Mac. (When you set Linux as your base layer, the Linux media layer is what you shift into. Same for the Mac layer when that's the base)

## Layers

#### Keymap 0: Base (Mac)

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
| Tab    |   Q  |   W  |   E  |   R  |   T  |      |           |      |   Y  |   U  |   I  |   O  |   P  |  Bksp  |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
| Ct/Esc |   A  |   S  |   D  |   F  |   G  |------|           |------|   H  |   J  |   K  |   L  |Ctrl/;|   '    |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
| Shift  |   Z  |   X  |   C  |   V  |   B  |      |           |      |   N  |   M  |   ,  |   .  |Ctrl//| Enter  |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |Shift | Tab  | ↑ L3 |Alt/Ec|                                       | ↑ L2 |Hyper |   '  |Enter |      |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,---------------.
                                       |      |      |       |      |        |
                                ,------+------+------|       |------+--------+------.
                                |      |      |      |       |      |        |      |
                                | LGui | Bksp |------|       |------| Bkspc  | Spc  |
                                |      |      |      |       |      |        |      |
                                `--------------------'       `----------------------'
```

#### Keymap 1: Base (Linux)

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
| Tab    |   Q  |   W  |   E  |   R  |   T  |      |           |      |   Y  |   U  |   I  |   O  |   P  |  Bksp  |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
| Ct/Esc |   A  |   S  |   D  |   F  |   G  |------|           |------|   H  |   J  |   K  |   L  |Ctrl/;|   '    |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
| Shift  |   Z  |   X  |   C  |   V  |   B  |      |           | LAlt |   N  |   M  |   ,  |   .  |Ctrl//| Enter  |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |Shift | Tab  | ↑ L4 |Gui/Ec|                                       | ↑ L2 |Hyper |   '  |Enter |      |
  `-----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,---------------.
                                       |      |      |       |      |        |
                                ,------+------+------|       |------+--------+------.
                                |      |      |      |       |      |        |      |
                                | Ctrl | Bksp |------|       |------| Bkspc  | Spc  |
                                |      |      |      |       |      |        |      |
                                `--------------------'       `----------------------'
```

#### Keymap 2: Symbol Layer

```
,---------------------------------------------------.           ,--------------------------------------------------.
|         |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|---------+------+------+------+------+------+------|           |------+------+------+------+------+------+--------|
|         |   \  |   /  |   [  |   ]  |   ~  |      |           |      |   |  |   =  |   +  |   -  |   _  |        |
|---------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|         |   {  |   }  |   (  |   )  |   `  |------|           |------|   ←  |   ↓  |   ↑  |   →  |      |        |
|---------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|         |   !  |   @  |   #  |   $  |   %  |      |           |      |   ^  |   &  |   *  |   (  |   )  |        |
`---------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |       |      |      | ↑ L5 |      |                                       | TRNS |      |      |      |      |
  `-----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------+------+------|       |------+------+------.
                                |      |      |      |       |      |      |      |
                                |      | Del  |------|       |------| Del  |      |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

#### Keymap 3: Media & Numbers (MAC)

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
|        |      |Scrn -| Vol+ |Scrn +|      |      |           |      |      |   7  |   8  |   9  |   *  |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |VolMut|Trak ←|Ply/Ps|Trak →|      |------|           |------|      |   4  |   5  |   6  |   +  |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |      |      | Vol- |      |      |      |           |      |      |   1  |   2  |   3  |   \  |        |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |      |      | TRNS |      |                                       | ↑ L5 |      |   .  |   =  |      |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------+------+------|       |------+------+------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |   0  |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

#### Keymap 4: Media & Numbers (Linux)

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
|        |      |Scrn -| Vol+ |Scrn +|      |      |           |      |      |   7  |   8  |   9  |   *  |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |VolMut|Trak ←|Ply/Ps|Trak →|      |------|           |------|      |   4  |   5  |   6  |   +  |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |      |      | Vol- |      |      |      |           |      |      |   1  |   2  |   3  |   \  |        |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |      |      | TRNS |      |                                       | ↑ L5 |      |   .  |   =  |      |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------+------+------|       |------+------+------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |   0  |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

#### Keymap 5: Extra

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
|        | → L0 | → L1 |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |      |      |      |      |      |------|           |------| Home | PGDN | PGUP | End  |      |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |      |      | TRNS |      |                                       | TRNS |      |      |      |      |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------|------+------+       |------+------+------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |      |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

## TODO

1. Get the LEDs to work: https://www.reddit.com/r/ergodox/comments/80hgxj/infinity_lcd_configuration_in_qmk/duxklzh/

## Building And Flashing

See the default building and flashing documentation for the Ergodox Infinity, I don't do anything beyond that.

## FAQs

> What's the case you have for your Ergodox Infinity?

It's a case made by Datamancer and I got it [on Drop.com as a group buy](https://drop.com/buy/datamancer-infinity-ergodox-hardwood-case).

> Why don't you just use the other keys?

I bounce between my Ergodox, Atreus 2, CorneKBD, and a couple of Planck keyboards. If I start using keys on my Ergo that I can't on my 40% boards, then my layouts start to diverge and muscle memory is diminished. I like to constrain my bigger boards to my smaller for continuity.
