// Copyright 2021 Karl Berggren <@bkarl>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "quantum.h"

#define ___ KC_NO

/*
 *              ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐ ┌───┐    ┌───────┐
 *              │10 │00 │11 │01 │12 │02 │13 │03 │14 │04 │15 │05 │16 │06 │17 │ │07 │    │06     │ 2u Backspace
 *              ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┤ ├───┤    └─┬─────┤
 *              │30   │20 │31 │21 │32 │22 │33 │23 │34 │24 │35 │25 │36 │26   │ │37 │      │     │
 *  2.25u       ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤ ├───┤   ┌──┴┐26  │ ISO Enter
 *  LShift      │50    │40 │51 │41 │52 │42 │53 │43 │54 │44 │55 │45 │56      │ │47 │   │56 │    │
 * ┌────────┐   ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┘ ├───┤   └───┴────┘
 * │70      │   │70  │60 │71 │61 │72 │62 │73 │63 │74 │64 │75 │65 │76    │┌───┐│57 │
 * └────────┘   ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴──┬┴──┬┴──┬───┘│66 │└───┘
 *              │80  │81  │82  │83                      │84 │85 │86 │┌───┼───┼───┐
 *              └────┴────┴────┴────────────────────────┴───┴───┴───┘│87 │77 │67 │
 *                                                                   └───┴───┴───┘
 *                              K83+K84 can be 6.25u/1u or 6u/1.25u
 *              ┌────┬────┬────┬────────────────────────┬────┬────┐
 *              │80  │81  │82  │83                      │84  │85  │ 65% with Blocker
 *              └────┴────┴────┴────────────────────────┴────┴────┘
 */

// This a shortcut to help you visually see your layout.
// The first section contains all of the arguements
// The second converts the arguments into a two-dimensional array
#define LAYOUT_all( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16, K06, K17, K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36, K26,      K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45, K56,           K47, \
         K70, K60, K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85, K86, K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, K17}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {K60, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, K86, K87} \
}

#define LAYOUT_65_iso( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16,   K06,    K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36,           K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45, K56, K26,      K47, \
         K70, K60, K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85, K86, K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, ___}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {K60, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, K86, K87} \
}

#define LAYOUT_65_iso_split_bs( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16, K06, K17, K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36,           K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45, K56, K26,      K47, \
         K70, K60, K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85, K86, K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, K17}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {K60, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, K86, K87} \
}

#define LAYOUT_65_iso_blocker( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16,   K06,    K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36,           K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45, K56, K26,      K47, \
         K70, K60, K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85,      K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, ___}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {K60, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, ___, K87} \
}

#define LAYOUT_65_iso_blocker_split_bs( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16, K06, K17, K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36,           K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45, K56, K26,      K47, \
         K70, K60, K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85,      K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, K17}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {K60, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, ___, K87} \
}

#define LAYOUT_65_ansi( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16,   K06,    K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36, K26,      K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45,      K56,      K47, \
         K70,      K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85, K86, K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, ___}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {___, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, K86, K87} \
}

#define LAYOUT_65_ansi_split_bs( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16, K06, K17, K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36, K26,      K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45,      K56,      K47, \
         K70,      K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85, K86, K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, K17}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {___, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, K86, K87} \
}

#define LAYOUT_65_ansi_blocker( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16,   K06,    K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36, K26,      K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45,      K56,      K47, \
         K70,      K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85,      K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, ___}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {___, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, ___, K87} \
}

#define LAYOUT_65_ansi_blocker_split_bs( \
         K10, K00, K11, K01, K12, K02, K13, K03, K14, K04, K15, K05, K16, K06, K17, K07, \
         K30, K20, K31, K21, K32, K22, K33, K23, K34, K24, K35, K25, K36, K26,      K37, \
         K50, K40, K51, K41, K52, K42, K53, K43, K54, K44, K55, K45,      K56,      K47, \
         K70,      K71, K61, K72, K62, K73, K63, K74, K64, K75, K65, K76,      K66, K57, \
         K80, K81, K82,                K83,                K84, K85,      K87, K77, K67  \
) { \
        {K00, K01, K02, K03, K04, K05, K06, K07}, \
        {K10, K11, K12, K13, K14, K15, K16, K17}, \
        {K20, K21, K22, K23, K24, K25, K26, ___}, \
        {K30, K31, K32, K33, K34, K35, K36, K37}, \
        {K40, K41, K42, K43, K44, K45, ___, K47}, \
        {K50, K51, K52, K53, K54, K55, K56, K57}, \
        {___, K61, K62, K63, K64, K65, K66, K67}, \
        {K70, K71, K72, K73, K74, K75, K76, K77}, \
        {K80, K81, K82, K83, K84, K85, ___, K87} \
}
