#include QMK_KEYBOARD_H

enum layer_names {
    _QW,
    _FO,
    _FL,
    _CL,
    _DL
};




// Custom macros
#define SPC_FUN LT(_FL, KC_SPC)
#define BSC_CON LT(_CL, KC_BSPC)


const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  /* 0: Qwerty layer
   * ┌─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┐
   * │ ESC │ F1  │ F2  │ F3  │ F4  │ F5  │ F6  │ F7  │ F8  │ F9  │ F10 │ F11 │ F12 │PRSCR│ INS │HOME │
   * ├─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┤
   * │  `  │  1  │  2  │  3  │  4  │  5  │  6  │  7  │  8  │  9  │  0  │  -  │  =  │BSLS │ DEL │ END │
   * ├─────┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴─────┼─────┤
   * │TAB     │  Q  │  W  │  E  │  R  │  T  │  Y  │  U  │  I  │  O  │  P  │  [  │  ]  │BSPC    │PGUP │
   * ├────────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴────────┼─────┤
   * │CAPS     │  A  │  S  │  D  │  F  │  G  │  H  │  J  │  K  │  L  │  ;  │  '  │ENTER        │PGDN │
   * ├──────┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴───────┬─────┼─────┤
   * │LSHFT │LSHFT│  Z  │  X  │  C  │  V  │  B  │  N  │  M  │  ,  │  .  │  /  │RSHFT     │ UP  │MO_CL│
   * ├──────┼─────┴─┬───┴──┬──┴─────┴────┬┴─────┼─────┴─────┴────┬┴────┬┴────┬┴────┬─────┼─────┼─────┤
   * │LCTRL │L_GUI  │L_ALT │SPC          │MO(_FL│BSPC            │R_ALT│R_GUI│R_CTR│LEFT │DOWN │RIGHT│
   * └──────┴───────┴──────┴─────────────┴──────┴────────────────┴─────┴─────┴─────┴─────┴─────┴─────┘
   */

  /* 0: QWERTY */
  [_QW] = LAYOUT(
    KC_ESC,   KC_F1,    KC_F2,    KC_F3,    KC_F4,    KC_F5,    KC_F6,    KC_F7,    KC_F8,    KC_F9,    KC_F10,   KC_F11,   KC_F12,   KC_PSCR,  KC_INS,   KC_HOME, 
    KC_GRV,   KC_1,     KC_2,     KC_3,     KC_4,     KC_5,     KC_6,     KC_7,     KC_8,     KC_9,     KC_0,     KC_MINS,  KC_EQL,   KC_BSLS,  KC_DEL,   KC_END,  
    KC_TAB,   KC_Q,     KC_W,     KC_E,     KC_R,     KC_T,     KC_Y,     KC_U,     KC_I,     KC_O,     KC_P,     KC_LBRC,  KC_RBRC,  KC_BSPC,            KC_PGUP, 
    KC_CAPS,  KC_A,     KC_S,     KC_D,     KC_F,     KC_G,     KC_H,     KC_J,     KC_K,     KC_L,     KC_SCLN,  KC_QUOT,            KC_ENT,             KC_PGDN, 
    KC_LSFT,  KC_LSFT,  KC_Z,     KC_X,     KC_C,     KC_V,     KC_B,     KC_N,     KC_M,     KC_COMM,  KC_DOT,   KC_SLSH,            KC_RSFT,  KC_UP,    MO(_CL), 
    KC_LCTL,  KC_LGUI,  KC_LALT,                      KC_SPC,   MO(_FL),  KC_BSPC,                      KC_RALT,  KC_RGUI,  KC_RCTL,  KC_LEFT,  KC_DOWN,  KC_RGHT),

  /* 1: forty: this layer emulates a forty percent keyboard so I can transition to a forty percent :)
   * ┌─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┐
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┤
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴─────┼─────┤
   * │ESC     │  Q  │  W  │  E  │  R  │  T  │  Y  │  U  │  I  │  O  │  P  │ENT  │     │        │     │
   * ├────────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴────────┼─────┤
   * │TAB      │  A  │  S  │  D  │  F  │  G  │  H  │  J  │  K  │  L  │  ;  │ '   │             │     │
   * ├──────┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴───────┬─────┼─────┤
   * │LSHFT │LSHFT│  Z  │  X  │  C  │  V  │  B  │  N  │  M  │  ,  │  .  │  /  │RSHFT     │     │MO_CL│
   * ├──────┼─────┴─┬───┴──┬──┴─────┴────┬┴─────┼─────┴─────┴────┬┴────┬┴────┬┴────┬─────┼─────┼─────┤
   * │LCTRL │L_ALT  │MO(DL)│SPCFUN       │BSPC  │MO(_CL)         │R_ALT│R_GUI│R_CTR│     │     │     │
   * └──────┴───────┴──────┴─────────────┴──────┴────────────────┴─────┴─────┴─────┴─────┴─────┴─────┘
   */

  /* 1: FORTY */
  [_FO] = LAYOUT(
    XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX, 
    XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX,  XXXXXXX, 
    KC_ESC,   KC_Q,     KC_W,     KC_E,     KC_R,     KC_T,     KC_Y,     KC_U,     KC_I,     KC_O,     KC_P,     KC_ENT,   XXXXXXX,  XXXXXXX,            XXXXXXX, 
    KC_TAB,   KC_A,     KC_S,     KC_D,     KC_F,     KC_G,     KC_H,     KC_J,     KC_K,     KC_L,     KC_SCLN,  KC_QUOT,            XXXXXXX,            XXXXXXX, 
    KC_LSFT,  KC_LSFT,  KC_Z,     KC_X,     KC_C,     KC_V,     KC_B,     KC_N,     KC_M,     KC_COMM,  KC_DOT,   KC_SLSH,            KC_RSFT,  XXXXXXX,  MO(_CL), 
    KC_LCTL,  KC_LALT,  MO(_DL),                      SPC_FUN,  KC_BSPC,  MO(_CL),                      KC_RALT,  KC_RGUI,  KC_RCTL,  XXXXXXX,  XXXXXXX,  XXXXXXX),


  /* 2: Function layer
   * ┌─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┐
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┤
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴─────┼─────┤
   * │        │     │HOME │ UP  │END  │     │     │     │     │     │     │     │     │        │VOLUP│
   * ├────────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴────────┼─────┤
   * │         │     │LEFT │DOWN │RIGHT│     │     │     │     │     │     │     │             │VOLDN│
   * ├──────┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴───────┬─────┼─────┤
   * │      │     │     │     │PGDN │PGUP │     │     │     │     │     │     │          │     │     │
   * ├──────┼─────┴─┬───┴──┬──┴─────┴────┬┴─────┼─────┴─────┴────┬┴────┬┴────┬┴────┬─────┼─────┼─────┤
   * │      │       │      │             │      │                │VOLDN│VOLUP│     │     │     │     │
   * └──────┴───────┴──────┴─────────────┴──────┴────────────────┴─────┴─────┴─────┴─────┴─────┴─────┘
   */

  /* 2: ANSI Fn layer */
  [_FL] = LAYOUT(
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______, 
    _______,  _______,  KC_HOME,  KC_UP,    KC_END,   _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,            KC_VOLU, 
    _______,  _______,  KC_LEFT,  KC_DOWN,  KC_RGHT,  _______,  _______,  _______,  _______,  _______,  _______,  _______,            _______,            KC_VOLD, 
    _______,  _______,  _______,  KC_PGDN,  KC_PGUP,  _______,  _______,  _______,  _______,  _______,  _______,  _______,            _______,  _______,  _______, 
    _______,  _______,  _______,                      _______,  _______,  _______,                      KC_VOLD,  KC_VOLU,  _______,  _______,  _______,  _______),

  /* 3: Control layer
   * ┌─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┐
   * │QK_BOOT│QWERT│FORTY│     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┤
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴─────┼─────┤
   * │   `    │  !  │  @  │  #  │  $  │  %  │  ^  │  &  │  *  │  (  │  )  │ DEL │     │        │     │
   * ├────────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴────────┼─────┤
   * │         │  1  │  2  │  3  │  4  │  5  │  6  │  7  │  8  │  9  │  0  │  \  │             │     │
   * ├──────┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴───────┬─────┼─────┤
   * │      │     │     │     │     │     │     │     │     │     │     │     │          │     │     │
   * ├──────┼─────┴─┬───┴──┬──┴─────┴────┬┴─────┼─────┴─────┴────┬┴────┬┴────┬┴────┬─────┼─────┼─────┤
   * │      │       │      │             │      │                │     │     │     │     │     │     │
   * └──────┴───────┴──────┴─────────────┴──────┴────────────────┴─────┴─────┴─────┴─────┴─────┴─────┘
   */

  /* 3:  Control layer */
  [_CL] = LAYOUT(
    QK_BOOT,  TO(_QW),  TO(_FO),  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  RGB_TOG, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  RGB_MOD, 
    KC_GRV,   KC_EXLM,  KC_AT,    KC_HASH,  KC_DLR,   KC_PERC,  KC_CIRC,  KC_AMPR,  KC_ASTR,  KC_LPRN,  KC_RPRN,  KC_DEL,   _______,  _______,            KC_VOLU, 
    _______,  KC_1,     KC_2,     KC_3,     KC_4,     KC_5,     KC_6,     KC_7,     KC_8,     KC_9,     KC_0,     KC_BSLS,            _______,            KC_VOLD, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,            _______,  RGB_SAI,  _______, 
    _______,  _______,  _______,                      _______,  _______,  _______,                      _______,  RGB_VAD,  RGB_VAI,  RGB_HUD,  RGB_SAD,  RGB_HUI),

    /* 4: Another layer for ease 
   * ┌─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┬─────┐
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │ KC_MINS,  KC_EQL,   KC_LBRC,  KC_RBRC,  KC_BSLS,
   * ├─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┼─────┤ KC_UNDS,  KC_PLUS,  KC_LCBR,  KC_RCBR,  KC_PIPE,
   * │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │     │
   * ├─────┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴─────┼─────┤
   * │        │     │     │     │     │     │     │  _  │  +  │  {  │  }  │  |  │     │        │     │
   * ├────────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴┬────┴────────┼─────┤
   * │         │     │     │     │     │     │     │  -  │  =  │  [  │  ]  │  \  │             │     │
   * ├──────┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴──┬──┴───────┬─────┼─────┤
   * │      │     │     │     │     │     │     │     │     │     │     │     │          │     │     │
   * ├──────┼─────┴─┬───┴──┬──┴─────┴────┬┴─────┼─────┴─────┴────┬┴────┬┴────┬┴────┬─────┼─────┼─────┤
   * │      │       │      │             │      │                │     │     │     │     │     │     │
   * └──────┴───────┴──────┴─────────────┴──────┴────────────────┴─────┴─────┴─────┴─────┴─────┴─────┘
   */

  /* 3: D control layer */
  [_DL] = LAYOUT(
    QK_BOOT,  TO(_QW),  TO(_FO),  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  RGB_TOG, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  RGB_MOD, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  KC_UNDS,  KC_PLUS,  KC_LCBR,  KC_RCBR,  KC_PIPE,  _______,  _______,            KC_VOLU, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  KC_MINS,  KC_EQL,   KC_LBRC,  KC_RBRC,  KC_BSLS,            _______,            KC_VOLD, 
    _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,  _______,            _______,  RGB_SAI,  _______, 
    _______,  _______,  _______,                      _______,  _______,  _______,                      _______,  RGB_VAD,  RGB_VAI,  RGB_HUD,  RGB_SAD,  RGB_HUI)
};
