#include "kbdmini.h"

const is31_led PROGMEM g_is31_leds[RGB_MATRIX_LED_COUNT] = {
    { 0, B_9,  A_9,  C_9  }, //LA33
    { 0, B_10, A_10, C_10 }, //LA37
    { 0, B_11, A_11, C_11 }, //LA41
    { 0, B_12, A_12, C_12 }, //LA45
    { 0, B_13, A_13, C_13 }, //LA49
    { 0, B_14, A_14, C_14 }, //LA53
    { 0, B_15, A_15, C_15 }, //LA57
    { 0, B_6,  A_6,  C_6  }, //LA21
    { 0, B_5,  A_5,  C_5  }, //LA17
    { 0, B_4,  A_4,  C_4  }, //LA13
    { 0, B_3,  A_3,  C_3  }, //LA9
    { 0, B_2,  A_2,  C_2  }, //LA5
    { 0, B_1,  A_1,  C_1  }, //LA1

    { 0, E_9,  D_9,  F_9  }, //LA34
    { 0, E_10, D_10, F_10 }, //LA38
    { 0, E_11, D_11, F_11 }, //LA42
    { 0, E_12, D_12, F_12 }, //LA46
    { 0, E_13, D_13, F_13 }, //LA50
    { 0, E_14, D_14, F_14 }, //LA54
    { 0, E_15, D_15, F_15 }, //LA58
    { 0, E_6,  D_6,  F_6  }, //LA22
    { 0, E_5,  D_5,  F_5  }, //LA18
    { 0, E_4,  D_4,  F_4  }, //LA14
    { 0, E_3,  D_3,  F_3  }, //LA10
    { 0, E_2,  D_2,  F_2  }, //LA6
    { 0, E_1,  D_1,  F_1  }, //LA2

    { 0, H_9,  G_9,  I_9  }, //LA35
    { 0, H_10, G_10, I_10 }, //LA39
    { 0, H_11, G_11, I_11 }, //LA43
    { 0, H_12, G_12, I_12 }, //LA47
    { 0, H_13, G_13, I_13 }, //LA51
    { 0, H_14, G_14, I_14 }, //LA55
    { 0, H_15, G_15, I_15 }, //LA59
    { 0, H_6,  G_6,  I_6  }, //LA23
    { 0, H_5,  G_5,  I_5  }, //LA19
    { 0, H_4,  G_4,  I_4  }, //LA15
    { 0, H_3,  G_3,  I_3  }, //LA11
    { 0, H_2,  G_2,  I_2  }, //LA7
    { 0, H_1,  G_1,  I_1  }, //LA3

    { 0, K_9,  J_9,  L_9  }, //LA36
    { 0, K_10, J_10, L_10 }, //LA40
    { 0, K_11, J_11, L_11 }, //LA44
    { 0, K_12, J_12, L_12 }, //LA48
    { 0, K_13, J_13, L_13 }, //LA52
    { 0, K_14, J_14, L_14 }, //LA56
    { 0, K_15, J_15, L_15 }, //LA60
    { 0, K_6,  J_6,  L_6  }, //LA24
    { 0, K_5,  J_5,  L_5  }, //LA20
    { 0, K_4,  J_4,  L_4  }, //LA16
    { 0, K_3,  J_3,  L_3  }, //LA12
    { 0, K_2,  J_2,  L_2  }, //LA8
    { 0, K_1,  J_1,  L_1  }  //LA4
};

led_config_t g_led_config = {
    {
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12 },
        { 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 },
        { 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
        { 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 }
    }, {
        { 0,  0 }, { 19,  0 }, { 38,  0 }, { 57,  0 }, { 76,  0 }, { 95,  0 }, { 114,  0 }, { 133,  0 }, { 152,  0 }, { 171,  0 }, { 190,  0 }, { 209,  0 }, { 224,  0 },
        { 0, 21 }, { 19, 21 }, { 38, 21 }, { 57, 21 }, { 76, 21 }, { 95, 21 }, { 114, 21 }, { 133, 21 }, { 152, 21 }, { 171, 21 }, { 190, 21 }, { 209, 21 }, { 224, 21 },
        { 0, 42 }, { 19, 42 }, { 38, 42 }, { 57, 42 }, { 76, 42 }, { 95, 42 }, { 114, 42 }, { 133, 42 }, { 152, 42 }, { 171, 42 }, { 190, 42 }, { 209, 42 }, { 224, 42 },
        { 0, 64 }, { 19, 64 }, { 38, 64 }, { 57, 64 }, { 76, 64 }, { 95, 64 }, { 114, 64 }, { 133, 64 }, { 152, 64 }, { 171, 64 }, { 190, 64 }, { 209, 64 }, { 224, 64 }
    }, {
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
        1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1,
        1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1,
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    }
};

void suspend_power_down_kb(void) {
    rgb_matrix_set_suspend_state(true);
    suspend_power_down_user();
}

void suspend_wakeup_init_kb(void) {
    rgb_matrix_set_suspend_state(false);
    suspend_wakeup_init_user();
}
