#pragma once

#include "quantum.h"

#define XXX KC_NO

/* LAYOUT_all
 * ,-----------------------------------------------------------.
 * |00 |01 |02 |03 |04 |05 |06 |07 |08 |09 |0A |0B |0C |0D |49 |
 * |-----------------------------------------------------------|      ,-----.
 * |10   |11 |12 |13 |14 |15 |16 |17 |18 |19 |1A |1B |1C |1D   |      |     |
 * |-----------------------------------------------------------|   ,---.    |
 * |20    |21 |22 |23 |24 |25 |26 |17 |28 |29 |2A |2B |2D      |   |2C |2D  |
 * |-----------------------------------------------------------|   `--------'
 * |30  |31 |32 |33 |34 |35 |36 |37 |38 |39 |3A |3B |3D    |3C |
 * |-----------------------------------------------------------|
 * |40  |41  |42  |           45           |4A  |4B  |4C  |4D  |
 * `-----------------------------------------------------------'
 * 2u Backspace = k0D
 * 2.25u left Shift = k30
 * 2.75u right Shift = k3D
 */
#define LAYOUT_all( \
    k00, k01, k02, k03, k04, k05, k06, k07, k08, k09, k0A, k0B, k0C, k0D, k49, \
    k10, k11, k12, k13, k14, k15, k16, k17, k18, k19, k1A, k1B, k1C, k1D, \
    k20, k21, k22, k23, k24, k25, k26, k27, k28, k29, k2A, k2B, k2C, k2D, \
    k30, k31, k32, k33, k34, k35, k36, k37, k38, k39, k3A, k3B, k3D, k3C, \
    k40, k41, k42,                k45,                k4A, k4B, k4C, k4D \
) { \
    { k00, k01, k02, k03, k04, k05, k06, k07, k08, k09, k0A, k0B, k0C, k0D }, \
    { k10, k11, k12, k13, k14, k15, k16, k17, k18, k19, k1A, k1B, k1C, k1D }, \
    { k20, k21, k22, k23, k24, k25, k26, k27, k28, k29, k2A, k2B, k2C, k2D }, \
    { k30, k31, k32, k33, k34, k35, k36, k37, k38, k39, k3A, k3B, k3C, k3D }, \
    { k40, k41, k42, XXX, XXX, k45, XXX, XXX, XXX, k49, k4A, k4B, k4C, k4D } \
}

/* LAYOUT
 * Present for backwards compatibility with older keymaps. The commit that added
 * split Backspace support put the right 1u key of the split on the bottom row,
 * next to right Alt. The arguments for 1.75/1u right Shift are also in reverse
 * order.
 * ,-----------------------------------------------------------.
 * |00 |01 |02 |03 |04 |05 |06 |07 |08 |09 |0A |0B |0C |0D |49 |
 * |-----------------------------------------------------------|      ,-----.
 * |10   |11 |12 |13 |14 |15 |16 |17 |18 |19 |1A |1B |1C |1D   |      |     |
 * |-----------------------------------------------------------|   ,---.    |
 * |20    |21 |22 |23 |24 |25 |26 |17 |28 |29 |2A |2B |2D      |   |2C |2D  |
 * |-----------------------------------------------------------|   `--------'
 * |30  |31 |32 |33 |34 |35 |36 |37 |38 |39 |3A |3B |3D    |3C |
 * |-----------------------------------------------------------|
 * |40  |41  |42  |           45           |4A  |4B  |4C  |4D  |
 * `-----------------------------------------------------------'
 */
#define LAYOUT( \
    k00, k01, k02, k03, k04, k05, k06, k07, k08, k09, k0A, k0B, k0C, k0D, \
    k10, k11, k12, k13, k14, k15, k16, k17, k18, k19, k1A, k1B, k1C, k1D, \
    k20, k21, k22, k23, k24, k25, k26, k27, k28, k29, k2A, k2B, k2C, k2D, \
    k30, k31, k32, k33, k34, k35, k36, k37, k38, k39, k3A, k3B, k3C, k3D, \
    k40, k41, k42,           k45,                k49, k4A, k4B, k4C, k4D \
) { \
    { k00, k01, k02, k03, k04, k05, k06, k07, k08, k09, k0A, k0B, k0C, k0D }, \
    { k10, k11, k12, k13, k14, k15, k16, k17, k18, k19, k1A, k1B, k1C, k1D }, \
    { k20, k21, k22, k23, k24, k25, k26, k27, k28, k29, k2A, k2B, k2C, k2D }, \
    { k30, k31, k32, k33, k34, k35, k36, k37, k38, k39, k3A, k3B, k3C, k3D }, \
    { k40, k41, k42, XXX, XXX, k45, XXX, XXX, XXX, k49, k4A, k4B, k4C, k4D } \
}

/* LAYOUT_60_ansi
 * ,-----------------------------------------------------------.
 * |00 |01 |02 |03 |04 |05 |06 |07 |08 |09 |0A |0B |0C |0D     |
 * |-----------------------------------------------------------|
 * |10   |11 |12 |13 |14 |15 |16 |17 |18 |19 |1A |1B |1C |1D   |
 * |-----------------------------------------------------------|
 * |20    |21 |22 |23 |24 |25 |26 |17 |28 |29 |2A |2B |2D      |
 * |-----------------------------------------------------------|
 * |30      |32 |33 |34 |35 |36 |37 |38 |39 |3A |3B |3D        |
 * |-----------------------------------------------------------|
 * |40  |41  |42  |           45           |4A  |4B  |4C  |4D  |
 * `-----------------------------------------------------------'
 */
#define LAYOUT_60_ansi( \
    k00, k01, k02, k03, k04, k05, k06, k07, k08, k09, k0A, k0B, k0C, k0D, \
    k10, k11, k12, k13, k14, k15, k16, k17, k18, k19, k1A, k1B, k1C, k1D, \
    k20, k21, k22, k23, k24, k25, k26, k27, k28, k29, k2A, k2B,      k2D, \
    k30,      k32, k33, k34, k35, k36, k37, k38, k39, k3A, k3B,      k3D, \
    k40, k41, k42,                k45,                k4A, k4B, k4C, k4D \
) { \
    { k00, k01, k02, k03, k04, k05, k06, k07, k08, k09, k0A, k0B, k0C, k0D }, \
    { k10, k11, k12, k13, k14, k15, k16, k17, k18, k19, k1A, k1B, k1C, k1D }, \
    { k20, k21, k22, k23, k24, k25, k26, k27, k28, k29, k2A, k2B, XXX, k2D }, \
    { k30, XXX, k32, k33, k34, k35, k36, k37, k38, k39, k3A, k3B, XXX, k3D }, \
    { k40, k41, k42, XXX, XXX, k45, XXX, XXX, XXX, XXX, k4A, k4B, k4C, k4D } \
}
