/* Copyright 2021 Chrisopher S Martin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include QMK_KEYBOARD_H

enum bfo900_layers {
    _QWERTY,
    _FUNC,
};

enum bfo9000_keycodes {
    QWERTY = SAFE_RANGE,
    GAMING
};

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
/*
QWERTY
(Keys separated by /: tap for first, hold for second; uses Space Cadet Shifts)
 ,--------------------------------------------------------------------------------.   ,--------------------------------------------------------------------------------.
 |   ESC  |  QK_BOOT |   F1   |   F2   |   F3   |   F4   |   F5   |        |        |   |        |        |   F6   |   F7   |   F8   |   F9   |   F10  |   F11  |   F12  |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |    1   |    2   |    3   |    4   |   5    |        |        |   |        |        |   6    |    7   |    8   |    9   |    0   |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |    `   |    Q   |    W   |    E   |    R   |   T    |        |   [    |   |    ]   |        |   Y    |    U   |    I   |    O   |    P   |    +   |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |    A   |    S   |    D   |    F   |   G    |  Tab   |  Fn    |   |   Fn   |  Enter |   H    |    J   |    K   |    L   |    ;   |    '   |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |    Z   |    X   |    C   |    V   |    B   |  ESC   |        |   |        |        |   N    |    M   |    ,   |    .   |    /   |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |        |        |PrntScrn| Ctrl   | Bkspc  |Meta/OS | Shift  |   |  Shift |  Alt   | Space  | Ctrl   |        |        |   -    |        |        |
 `--------------------------------------------------------------------------------'   `--------------------------------------------------------------------------------'
*/
[_QWERTY] = LAYOUT(
  KC_ESC,  QK_BOOT,  KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   _______, _______,   _______, _______, KC_F6,   KC_F7,   KC_F8,   KC_F9,   KC_F10,  KC_F11,  KC_F12,
  _______, _______,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,    _______, _______,   _______, _______, KC_6,    KC_7,    KC_8,    KC_9,    KC_0,    KC_BSLS, _______,
  _______,  KC_GRV,  KC_Q,    KC_W,    KC_E,    KC_R,    KC_T,    _______, KC_LBRC,   KC_RBRC, _______, KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,    KC_EQL,  _______,
  _______, _______,  KC_A,    KC_S,    KC_D,    KC_F,    KC_G,    KC_TAB,  MO(_FUNC), MO(_FUNC), KC_ENT, KC_H,   KC_J,    KC_K,    KC_L,    KC_SCLN, KC_QUOT, _______, // TODO: use OSL instead of MO
  _______, _______,  KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,    KC_ESC,  _______,   _______, _______, KC_N,    KC_M,    KC_COMM, KC_DOT,  KC_SLSH, _______, _______,
  _______, _______,  _______, _______, KC_PSCR, KC_LCTL, KC_BSPC, KC_LGUI, KC_LSFT,   KC_RSFT, KC_RALT, KC_SPC,  KC_RCTL, _______, _______, KC_MINS, _______, _______ //KC_CTL shoudl be double tap for capslock
),

/*
Function layer
 ,--------------------------------------------------------------------------------.   ,--------------------------------------------------------------------------------.
 |        |        |        |        |        |        |        |        |        |   |        |        |        |        |        |        |        |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |        |        |        |        |        |        |        |   |        |        |        |        |        |        |        |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |        |        |        |        |        |        |        |   |        |        |   \    |   {    |    }   |   [    |   ]    |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |        |        |        |        |        |        |        |   |        |        |  LEFT  |  DOWN  |  UP    |  RIGHT |        |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |        |        |        |        |        |        |        |   |        |        |        |        |        |        |   \    |        |        |
 |--------+--------+--------+--------+--------+--------+--------+--------+--------|   |--------+--------+--------+--------+--------+--------+--------+--------+--------|
 |        |        |        |        |        |        |        |        |        |   |        |        |        |        |        |        |   |    |        |        |
 `--------------------------------------------------------------------------------'   `--------------------------------------------------------------------------------'
*/
[_FUNC] = LAYOUT(
  _______, _______, _______, _______, _______, _______, _______, _______, _______,     _______, _______, _______, _______, _______, _______, _______, _______, _______,
  _______, _______, _______, _______, _______, _______, _______, _______, _______,     _______, _______, _______, _______, _______, _______, _______, _______, _______,
  _______, _______, _______, _______, _______, _______, _______, _______, _______,     _______, _______, KC_BSLS, KC_LCBR, KC_RCBR, KC_LBRC, KC_RBRC, _______, _______,
  _______, _______, _______, _______, _______, _______, _______, _______, _______,     _______, _______, KC_LEFT, KC_DOWN, KC_UP,   KC_RIGHT, _______, _______, _______,
  _______, _______, _______, _______, _______, _______, _______, _______, _______,     _______, _______, _______, _______, _______, _______, KC_BSLS, _______, _______,
  _______, _______, _______, _______, _______, _______, _______, _______, _______,     _______, _______, _______, _______, _______, _______, KC_PIPE, _______, _______
),

};
