#include QMK_KEYBOARD_H

enum layer_names {
    _QWERTY,
    _LAYER1,
    _LAYER2,
    _LAYER3
};

#define WM_0     LGUI(KC_ENT)
#define WM_1     LGUI(KC_BSPC)
#define WM_2     LGUI(KC_DEL)
#define WM_3     SGUI(KC_ENT)
#define WM_4     SGUI(KC_BSPC)
#define WM_5     SGUI(KC_DEL)
#define WM_6     SGUI(KC_TAB)

#define LAYER1   TT(_LAYER1)
#define LAYER2   TT(_LAYER2)

#define CS_U     C(S(KC_UP))
#define CS_D     C(S(KC_DOWN))
#define CS_SPC   C(S(KC_SPC))

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  [_QWERTY] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┐                          ┌────────┬────────┬────────┬────────┬────────┬────────┐
      QK_GESC,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,                               KC_6,    KC_7,    KC_8,    KC_9,    KC_0,   KC_EQL,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
      KC_TAB,   KC_Q,     KC_W,   KC_E,    KC_R,    KC_T,                               KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,   KC_BSPC,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
      LAYER1,   KC_A,    KC_S,    KC_D,    KC_F,    KC_G,                               KC_H,    KC_J,    KC_K,    KC_L,  KC_SCLN,  KC_QUOT,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐        ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
      KC_LSFT,  KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,   KC_LGUI,         KC_RGUI,   KC_N,    KC_M,  KC_COMM,  KC_DOT, KC_SLSH,  LAYER2,
  //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘        └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                     KC_LCTL, KC_LALT, KC_SPC,                    KC_ENT, KC_RGUI,  WM_0
  //                               └────────┴────────┴────────┘                 └────────┴────────┴────────┘
  ),


  [_LAYER1] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┐                          ┌────────┬────────┬────────┬────────┬────────┬────────┐
     KC_CAPS,  KC_F1,    KC_F2,  KC_F3,   KC_F4,   KC_F5,                              KC_F6,   KC_F7,   KC_F8,   KC_F9,   KC_F10,  KC_MINS,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
     KC_SCRL,  KC_PSCR, KC_NO,   KC_NO,   KC_NO,    KC_NO,                             KC_PGUP, KC_PGDN, KC_HOME, KC_END,  KC_NO,   KC_DEL,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
     KC_NO,    KC_NO, C(KC_LEFT), KC_NO, C(KC_RGHT), KC_NO,                            KC_LEFT, KC_DOWN, KC_UP,   KC_RGHT, KC_NO,   KC_INS,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐        ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     KC_RSFT,  KC_NO,    WM_5,    WM_4,    WM_3,    WM_2,   MU_TOGG,           AU_TOGG, KC_NO,  KC_NO,   KC_LBRC, KC_RBRC, KC_BSLS, KC_NO,
  //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘        └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                      WM_1,  KC_LGUI,  KC_PIPE,                   KC_UNDS, KC_RCTL, KC_RALT
  //                               └────────┴────────┴────────┘                 └────────┴────────┴────────┘
  ),


  [_LAYER2] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┐                          ┌────────┬────────┬────────┬────────┬────────┬────────┐
      KC_ESC,  KC_F11,  KC_F12,  KC_F13,  KC_F14,  KC_F15,                             KC_F16,  KC_F17,  KC_F18,  KC_F19,  KC_F20,  KC_NO,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
      KC_NO,   KC_NO,   KC_NO,   CS_SPC,   CS_U,  S(KC_PGUP),                         RGB_VAI, RGB_HUI, RGB_SAI, RGB_M_SW,RGB_M_R,  KC_NO,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
      KC_NO,   KC_NO,   KC_NO,   KC_NO,    CS_D,  S(KC_PGDN),                         RGB_VAD, RGB_HUD, RGB_SAD,  KC_NO,   KC_NO,   KC_NO,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐        ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     KC_LSFT, KC_VOLD, KC_VOLU, KC_MUTE, KC_BRID, KC_BRIU,  MU_NEXT,          AU_OFF,  KC_RCTL, KC_LCTL, KC_RALT, KC_LALT, KC_DEL,  KC_NO,
  //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘        └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                      WM_6,  VK_TOGG, RGB_MOD,                   RGB_TOG, BL_TOGG,  BL_STEP
  //                               └────────┴────────┴────────┘                 └────────┴────────┴────────┘
  ),


  [_LAYER3] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┐                          ┌────────┬────────┬────────┬────────┬────────┬────────┐
      KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,                              KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
      KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,                              KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                          ├────────┼────────┼────────┼────────┼────────┼────────┤
      KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,                              KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐        ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
      KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,            KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,   KC_NO,
  //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘        └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                     KC_NO,   KC_NO,   KC_NO,                     KC_NO,   KC_NO,   KC_NO
  //                               └────────┴────────┴────────┘                 └────────┴────────┴────────┘
  )

};
