#include QMK_KEYBOARD_H

enum keyboard_layers {
    _BL = 0,
    _FN,
    _SL,
    _BF,
    _UP
};

#include "colors.h"
#include "extrakeys.h"

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

    [_BL] = LAYOUT(
    //┌────────┬────────┬────────┬────────┬────────┬────────┐                    ┌────────┬────────┬────────┬────────┬────────┬────────┐
        KC_GRV ,  KC_1  ,  KC_2  ,  KC_3  ,  KC_4  ,  KC_5  ,                       KC_6  ,  KC_7  ,  KC_8  ,  KC_9  ,  KC_0  ,KC_BSPC ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        KC_TAB ,  KC_Q  ,  KC_W  ,  KC_E  ,  KC_R  ,  KC_T  ,                       KC_Y  ,  KC_U  ,  KC_I  ,  KC_O  ,  KC_P  ,KC_BSLS ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        KC_ESC ,  KC_A  ,  KC_S  ,  KC_D  ,  KC_F  ,  KC_G  ,                       KC_H  ,  KC_J  ,  KC_K  ,  KC_L  ,KC_SCLN ,KC_QUOT ,
    //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐  ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
       KC_LSFT ,  KC_Z  ,  KC_X  ,  KC_C  ,  KC_V  ,  KC_B  ,KC_MINS ,   KC_PLUS ,  KC_N  ,  KC_M  ,KC_COMM , KC_DOT ,KC_SLSH ,MO(_FN) ,
    //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘  └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                      KC_LGUI ,KC_LCTL , KC_ENT ,             KC_SPC ,MO(_UP) ,KC_RALT
                                  // └────────┴────────┴────────┘           └────────┴────────┴────────┘
    ),

    [_UP] = LAYOUT(
    //┌────────┬────────┬────────┬────────┬────────┬────────┐                    ┌────────┬────────┬────────┬────────┬────────┬────────┐
       KC_TILD ,KC_EXLM , KC_AT  ,KC_HASH , KC_DLR ,KC_PERC ,                      ______ , ______ , ______ ,KC_MINS , KC_EQL , KC_NO  ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        ______ , ______ , ______ , ______ , ______ , ______ ,                      ______ , ______ , ______ ,KC_LBRC ,KC_RBRC , ______ ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        ______ , ______ , ______ , ______ , ______ , ______ ,                     KC_LEFT ,KC_DOWN , KC_UP  ,KC_RGHT , ______ , ______ ,
    //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐  ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
       KC_LSFT , ______ , ______ , ______ , ______ , ______ , ______ ,    ______ , ______ , ______ , ______ , ______ , ______ , ______ ,
    //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘  └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                      KC_LGUI ,KC_LCTL , ______ ,             ______ , KC_NO  , ______
                                  // └────────┴────────┴────────┘           └────────┴────────┴────────┘
    ),

    [_FN] = LAYOUT(
    //┌────────┬────────┬────────┬────────┬────────┬────────┐                    ┌────────┬────────┬────────┬────────┬────────┬────────┐
        ______ , KC_F1  , KC_F2  , KC_F3  , KC_F4  , KC_F5  ,                      KC_F6  , KC_F7  , KC_F8  , KC_F9  , KC_F10 , KC_F11 ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
       KC_STAB , ______ , ______ , ______ , ______ , HYPRT  ,                      ______ , ______ , ______ , ______ , ______ , KC_F12 ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        ______ , ______ , HYPRS  , ______ , ______ , ______ ,                      ______ , ______ ,KC_BRID ,KC_BRIU , ______ , ______ ,
    //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐  ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
       MO(_SL) , ______ , ______ , ______ , ______ , ______ , ______ ,    ______ , ______ , HYPRM  ,KC_VOLD ,KC_VOLU , ______ , KC_NO  ,
    //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘  └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                       ______ , ______ , ______ ,            KC_MPLY ,KC_MPRV ,KC_MNXT
                                  // └────────┴────────┴────────┘           └────────┴────────┴────────┘
    ),

    [_SL] = LAYOUT(
    //┌────────┬────────┬────────┬────────┬────────┬────────┐                    ┌────────┬────────┬────────┬────────┬────────┬────────┐
        ______ , HYPR1  , HYPR2  , HYPR3  , HYPR4  , HYPR5  ,                      HYPR6  , HYPR7  , HYPR8  , HYPR9  , HYPR0  , ______ ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        ______ , HYPRQ  , ______ , ______ , ______ , ______ ,                      ______ , ______ , ______ , ______ , HYPRP  , ______ ,
    //├────────┼────────┼────────┼────────┼────────┼────────┤                    ├────────┼────────┼────────┼────────┼────────┼────────┤
        ______ , ______ , ______ , ______ , ______ , ______ ,                      ______ , ______ , ______ ,HYPRL   , ______ , ______ ,
    //├────────┼────────┼────────┼────────┼────────┼────────┼────────┐  ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┤
        KC_NO  , ______ , ______ , ______ , ______ , ______ , ______ ,    ______ , ______ , ______ , ______ , ______ , ______ , KC_NO  ,
    //└────────┴────────┴────────┴───┬────┴───┬────┴───┬────┴───┬────┘  └───┬────┴───┬────┴───┬────┴───┬────┴────────┴────────┴────────┘
                                       ______ , ______ , ______ ,             QK_BOOT, ______ , ______
                                  // └────────┴────────┴────────┘           └────────┴────────┴────────┘
    )
};
