# jyh's levinson layout

[Levinson](https://keeb.io/products/levinson-lets-split-w-led-backlight)
built on rev2 PCBs. A split 4x12 keyboard with LED backlights.

The layout is oriented towards needs for programming, Emacs, XMonad,
and experience with 60% keyboards with no base layer arrow keys
(Poker). It makes heavy use of modifiers and layers. It is influenced
by good ideas from the Atreus keyboard layout.

## Layout features

  * Extensive use of _Mod Tap_, e.g.
     * Tap sends Esc, Hold sends Left Control
     * Tap sends Tab, Hold activates Numpad layer
     * Tap sends  - , Hold sends Shift
     * ... and many more
  * Places Tab and Enter on bottom corners, for hitting with palm
  * Meta is available on top corners, for controlling XMonad
  * Control on center key, for Emacs (among other things)
  * Backspace (Control Hold) and Space on center keys
  * All 60% keys available on base layer, except for numbers
  * Hyper and Meh keys
  * Right modifier keys in place of arrow keys
    * Arrows are instead available in two alternate locations:
    * WASD arrows on _Adjust_
    * Arrow cluster on _Raise_ (inspired by hexwire)
  * Numpad and Numrow on _Raise_ layer. Each is faster in some contexts
  * Function keys on _Lower_
  * Dynamic macros from QMK firmware on _Adjust_
  * Redunant keys where it is convenient to have characters together
    on one layer
