# pipicanim's Nyquist layout

```
make keebio/nyquist/rev3:pipicanim
```

## Layers
+ Lower -> Layer 2
+ Raise -> Layer 1
+ Code  -> Layer 3

### Base
```
┌──────┬──────┬──────┬──────┬──────┬──────┐ ┌──────┬──────┬──────┬──────┬──────┬──────┐
│TAB   │Q     │W     │E     │R     │T     │ │Y     │U     │I     │O     │P     │BCKPC │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│ESC   │A     │S     │D     │F     │G     │ │H     │J     │K     │L     │;     │'     │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│SHIFT │Z     │X     │C     │V     │B     │ │N     │M     │,     │.     │/     │ENTER │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│CTRL  |SUPER │MO(3) │ALT   │MO(2) │SPACE │ │SPACE │MO(1) │ALT   │MO(3) │SUPER │CTRL  │
└──────┴──────┴──────┴──────┴──────┴──────┘ └──────┴──────┴──────┴──────┴──────┴──────┘
```

### Lower, Numbers/Special Characters and Navigation
```
┌──────┬──────┬──────┬──────┬──────┬──────┐ ┌──────┬──────┬──────┬──────┬──────┬──────┐
│`     │1     │2     │3     │4     │      │ │      │PGUP  │UP    │PGDOWN│(     │)     │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │5     │6     │7     │8     │      │ │HOME  │LEFT  │DOWN  │RIGHT │[     │]     │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │9     │0     │-     │=     │      │ │END   │      │      │      │\     │|     │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │      │      │      │      │      │ │      │      │      │      │      │      │
└──────┴──────┴──────┴──────┴──────┴──────┘ └──────┴──────┴──────┴──────┴──────┴──────┘
```

### Raise, F buttons
```
┌──────┬──────┬──────┬──────┬──────┬──────┐ ┌──────┬──────┬──────┬──────┬──────┬──────┐
│CAPS  │      │PRSRC │SCLOCK│PAUSE │      │ │      │F1    │F2    │F3    │F4    │DEL   │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │      │INSERT│HOME  │PGUP  │      │ │      │F5    │F6    │F7    │F8    │      │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │      │DEL   │END   │PGDOWN│      │ │      │F9    │F10   │F11   │F12   │      │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │      │      │      │      │      │ │      │      │      │      │      │      │
└──────┴──────┴──────┴──────┴──────┴──────┘ └──────┴──────┴──────┴──────┴──────┴──────┘
```

### Code, RGB and media controls.

```
┌──────┬──────┬──────┬──────┬──────┬──────┐ ┌──────┬──────┬──────┬──────┬──────┬──────┐
│RGBTOG│RGBM+ │RGBM- │      │      │      │ |      │      │      │      │      │RESET │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│HUE+  │SAT+  │BRGHT+│EFCT+ │      │      │ │      │PREV  │PLAY  │NEXT  │      │      │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│HUE-  │SAT-  │BRGHT-│EFCT  │      │      │ |      │MUTE  │VOL-  │VOL+  │      │      │
├──────┼──────┼──────┼──────┼──────┼──────┤ ├──────┼──────┼──────┼──────┼──────┼──────┤
│      │      │      │      │      │      │ │      │      │      │      │      │      │
└──────┴──────┴──────┴──────┴──────┴──────┘ └──────┴──────┴──────┴──────┴──────┴──────┘
```
