
# Oled keymap for Rev3 and higher

- 3 layers Numpad/Navigation/Media
- Switch layer with the combo <kbd>0</kbd>+<kbd>.</kbd> (bottom row, first plus second key)

<img src="https://keycapsss.com/media/image/a4/e8/70/plaid-pad-rev3-keymap-oled-1.png" width="400" alt="Plaid-Pad Oled Keymap">

Below you can see the possible positions for the 4 rotary encoder (Rev1 only 2).  
*If you place a encoder in the top left corner (E1), you can't use another encoder in the lower right corner.*
```
Rev1.1 and higher           Rev1
,-----------------------,   ,-----------------------,
|  E1 |  E2 |  E3 |  E4 |   |  E1 |     |     |  E2 |
|-----+-----+-----+-----|   |-----+-----+-----+-----|
|     |     |     |  E3 |   |     |     |     |     |
|-----+-----+-----+-----|   |-----+-----+-----+-----|
|     |     |     |  E2 |   |     |     |     |     |
|-----+-----+-----+-----|   |-----+-----+-----+-----|
|     |     |     |  E1 |   |     |     |     |     |
`-----------------------'   `-----------------------'
```  

- Encoder E1 performs a tap on `KC_F17` and `KC_F18`.
- Encoder E2 performs a tap on `KC_F19` and `KC_F20`.
- Encoder E3 performs a tap on `KC_F21` and `KC_F22`.
- Encoder E4 performs a tap on `KC_F23` and `KC_F24`.

*The F17-F24 keys are intended to be customized via [Karabiner-Elements (OSX)](https://github.com/pqrs-org/Karabiner-Elements), or [AutoHotkey](https://github.com/Lexikos/AutoHotkey_L) (WIN)*
