# Simchee's BM40HSRGB

Simple Design for US ANSI international, German and Turkish letters are written using dead keys on Linux. Keyboard hasn't been tested on Windows. 

# Flashing

```bash
qmk flash -kb kprepublic/bm40hsrgb -km simchee -bl dfu
```

# Layout
## QWERTZ

Changes from standard ANSI keyboard for better ergonomic: switch ctrl and GUI (Windows) keys, escape at left bottom, tab on left top. 

```
  .-----------------------------------------------------------------------------------------------.
  |  Tab  |   Q   |   W   |   E   |   R   |   T   |   Z   |   U   |   I   |   O   |   P   | Bkspc |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |  Fn1  |   A   |   S   |   D   |   F   |   G   |   H   |   J   |   K   |   L   |   ;   |   /   |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  | LShift|   Y   |   X   |   C   |   V   |   B   |   N   |   M   |   ,   |   .   |  AUp  | Enter |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |  Esc  |  GUI  | LCtrl | LAlt  | Lower |     Space     | Raise | AltGr | ALeft | ADown | ARight|
  °-----------------------------------------------------------------------------------------------°
```

## Lower

Lower layout is mainly for numpad on the right side with navigation keys for lazy left handed navigation. Left side of Lower also provides media and RGB control.

```
  .-----------------------------------------------------------------------------------------------.
  |  TAB  |  PUp  |  Up   | PDow  | Home  |  F5   |   ^   |  7(/) |  8(() |  9()) |  0(=) | Bkspc |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |  Fn1  |  Left |  Down | Right |  End  |       |   #   |  4($) |  5(%) |  6(&) |   *   |   /   |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  | Shift |  Mute |  VUp  |  VDo  |  PP   |  Prev | Next  |  1(!) |  2(") |  3(§) |   +   | Enter |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |  ESC  |  RGB  | LCtrl | LAlt  | Lower |     Space     |   ,   |  0(=) |   .   |  -(_) |       |
  °-----------------------------------------------------------------------------------------------°
```

## Raise

Raise is used for non-alphanumerical chars.

```
  .-----------------------------------------------------------------------------------------------.
  |   ^   |   !   |   @   |       |   $   |   %   |   &   |   *   |   (   |    )  |   ?   |   ~   |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |  Fn1  |       |       |       |       |       |       |   ´   |  [({) |  ](}) |   '   |  /(|) |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |       |   -   |       |       |       |       |       |       |   <   |   >   |  =(+) |   #   |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |       |       |       |       | Lower |     Space     | Raise | AltGr |       |       |       |
  °-----------------------------------------------------------------------------------------------°
```

## Fn1

Fn1 provides function keys, as well as Vim-style navigation on the right side for when using the keyboard with both hands. 

```
  .-----------------------------------------------------------------------------------------------.
  |  F12  |  F1   |  F2   |  F3   |  F4   |  F5   |  F6   |  F7   |  F8   |  F9   |  F10  |  Del  |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |  Fn1  |  F11  |       |       |       |       | Home  | PDown |  PUp  |  End  |       |       |
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  | LShift|  Caps |       |       |       |       | ALeft | ADown |  AUp  | ARight|       | MRight|
  |-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+
  |QC_MAKE|       |       |       | Lower |     Space     | Bkspc |       |       | PrScr |  Ins  |
  °-----------------------------------------------------------------------------------------------°
```

