# Personal Layout of [bitstarr](https://github.com/bitstarr)

I use an US ANSI Layout and set the OS to the US Keyboard. Since I'm german, I need to use some special characters once in a while - that's what the UNI and UNI2 Layers are for. Under Windows we have to rely on [WinCompose](https://github.com/samhocevar/wincompose) to work as intended.

    qmk compile -kb kprepublic/bm43hsrgb -km bitstarr

## 0 Qwerty
```
,----------------------------------------------------------------------------.
|  ESC  |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  |  Bscp  |
|----------------------------------------------------------------------------+
|  Tab    |  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  |  Enter     |
|----------------------------------------------------------------------------+
|  Shift         |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  ,  |  .  |  /  |
|----------------------------------------------------------------------------+
| Ctrl | Win | Alt |  Space         |  Space/EXT     | UNI | ADV | FN | Ctrl |
`----------------------------------------------------------------------------'
```

## 1 EXT Layer
```
EXT Layer
,----------------------------------------------------------------------------.
|   1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  O  |   -   |   +   |
|----------------------------------------------------------------------------+
|  F1 |  F2 |  F3 |  F4 |  F5 |  F6 |  F7 |  F8 |  F9 |  F10 |  Enter        |
|----------------------------------------------------------------------------+
|  Shift         |  F11 |  F12 |    |    |  `  |  ;  |  '  |  [  |  ]  |  \  |
|----------------------------------------------------------------------------+
| Ctrl | Win | Alt |  Space         |                |     |     |    | Ctrl |
`----------------------------------------------------------------------------'
```

* Numbers
* F-Keys
* Brackets, Punctuation, Special Characters

## 2 ADV Layer
```
ADV Layer
,----------------------------------------------------------------------------.
|  `  |  W→  |  ↑  |  W←  |     |     |     |     |  ⇞  |     |  PS  |  Del  |
|----------------------------------------------------------------------------+
|  Tab    |  ←  |  ↓  |   →  |     |     |     |  ↖  |  ⇟  |  ↘︎  |           |
|----------------------------------------------------------------------------+
|  Shift    |  ⏮  |  ⏯  |  ⏭  |  🔉  |  🔇  |  🔊  |   |   |   |  Ins  |
|----------------------------------------------------------------------------+
| Ctrl | Win | Alt |  Space         |                |     |     |    | Ctrl |
`----------------------------------------------------------------------------'
```

* Arrows, Word skips
* Print Screen, Page Up, Page Down
* Home, End, Ins, Del
* Media

## 3 FN Layer
```
FN Layer
,----------------------------------------------------------------------------.
|      |     |     |     |  RESET  |     |     |     |     |     |     |     |
|----------------------------------------------------------------------------+
|        |     |     |     |     |     |     |     |     |     |             |
|----------------------------------------------------------------------------+
|          | RGB_T | RGB_M |  H+  |  H-  |  S+  |  S-  |  B+  |  B-  |   |   |
|----------------------------------------------------------------------------+
|      |     |     |                |                |     |     |     |     |
`----------------------------------------------------------------------------'
```

* RGB, Toggle, Mode, Hue, Saturation, Brightness
* Reset

## 4 UNI Layer
```
UNI Layer
,----------------------------------------------------------------------------.
|       |     |     |  €  |  §  |  °  |     |  ü  |     |  ö  |   –   |      |
|----------------------------------------------------------------------------+
|         |  ä  |  ß  |     |     |     |     |     |     |     |            |
|----------------------------------------------------------------------------+
|  UNI2       |  „  |  “  |  ”  |     |     |     |     |     |   …   |      |
|----------------------------------------------------------------------------+
|      |     |     |  Space        |  Space        |     |     |     | Mode  |
`----------------------------------------------------------------------------'
```

* Umlauts
* Punctuation
* Special Characters
* Switching [Input Modes](https://beta.docs.qmk.fm/using-qmk/software-features/feature_unicode#2-input-modes-id-input-modes) (UNICODE_MODE_WINCOMPOSE, UNICODE_MODE_WINDOWS, UNICODE_MODE_LINUX, UNICODE_MODE_MACOS)

## 5 UNI2 Layer
```
UNI2 Layer
,----------------------------------------------------------------------------.
|       |     |     |  é  |     |     |     |  Ü  |     |  Ü  |   —   |      |
|----------------------------------------------------------------------------+
|         |  Ä  |     |     |     |     |     |     |     |     |            |
|----------------------------------------------------------------------------+
|  UNI2       |     |     |     |     |     |     |     |     |       |      |
|----------------------------------------------------------------------------+
|      |     |     |  Space        |  Space        |     |     |     |       |
`----------------------------------------------------------------------------'
```

* Capital Umlauts