#include QMK_KEYBOARD_H

#define _QWERTY 0
#define _LOWER  1
#define _RAISE  2

enum custom_keycodes {
  QWERTY = SAFE_RANGE,
  LOWER,
  RAISE,
};

void matrix_scan_user(void) {
  // runs at every matrix scan.
}

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  /* Qwerty
   * ,-----------------------------------------------------------------------------------.
   * | Tab  |   Q  |   W  |   E  |   R  |   T  |   Y  |   U  |   I  |   O  |   P  | Bksp |
   * |------+------+------+------+------+-------------+------+------+------+------+------|
   * | Esc  |   A  |   S  |   D  |   F  |   G  |   H  |   J  |   K  |   L  |   ;  |  "   |
   * |------+------+------+------+------+------|------+------+------+------+------+------|
   * | Shift|   Z  |   X  |   C  |   V  |   B  |   N  |   M  |   ,  |   .  |   /  |Enter |
   * |------+------+------+------+------+------+------+------+------+------+------+------|
   * |      | Ctrl | GUI  | Alt  |Lower |    Space    |Raise | Left | Down |  Up  |Right |
   * `-----------------------------------------------------------------------------------'
   */

  [_QWERTY] = LAYOUT_planck_mit( \
    KC_TAB,     KC_Q,    KC_W,    KC_E,    KC_R,    KC_T,    KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,    KC_BSPC, \
    KC_ESC,     KC_A,    KC_S,    KC_D,    KC_F,    KC_G,    KC_H,    KC_J,    KC_K,    KC_L,    KC_SCLN, KC_QUOT, \
    KC_LSFT,    KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,    KC_N,    KC_M,    KC_COMM, KC_DOT,  KC_SLSH, KC_ENT , \
    TO(_NUMPAD),KC_LCTL, KC_LGUI, KC_LALT, MO(_LOWER),  KC_SPC,  MO(_RAISE),   KC_LEFT, KC_DOWN, KC_UP,   KC_RGHT \
  ),

  /* Lower
   * ,-----------------------------------------------------------------------------------.
   * |   ~  |   !  |   @  |   #  |   $  |   %  |   ^  |   &  |   *  |   (  |   )  | Bksp |
   * |------+------+------+------+------+-------------+------+------+------+------+------|
   * | Del  |  F1  |  F2  |  F3  |  F4  |  F5  |  F6  |   _  |   +  |     |    \  |  |   |
   * |------+------+------+------+------+------|------+------+------+------+------+------|
   * |      |  F7  |  F8  |  F9  |  F10 |  F11 |  F12 | RGB  | RGB  | RGB  | RGB  |Enter |
   * |------+------+------+------+------+------+------+------+------+------+------+------|
   * |      | RGB  | RGB  | RGB  |      |             | Next | Vol- | Vol+ | Play |      |
   * `-----------------------------------------------------------------------------------'
   */
  [_LOWER] = LAYOUT_planck_mit( \
    KC_TILD, KC_EXLM, KC_AT,   KC_HASH, KC_DLR,  KC_PERC, KC_CIRC, KC_AMPR, KC_ASTR, KC_LPRN, KC_RPRN, KC_BSPC, \
    KC_DEL,  KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_UNDS, KC_PLUS, KC_LCBR, KC_RCBR, KC_PIPE, \
    _______, KC_F7,   KC_F8,   KC_F9,   KC_F10,  KC_F11,  KC_F12,  RGB_TOG, RGB_MOD, RGB_VAD, RGB_VAI, _______, \
    _______, RGB_SAD, RGB_SAI, RGB_HUI, _______, _______, _______, KC_MNXT, KC_VOLD, KC_VOLU, KC_MPLY \
  ),

  /* Raise
   * ,-----------------------------------------------------------------------------------.
   * |   `  |   1  |   2  |   3  |   4  |   5  |   6  |   7  |   8  |   9  |   0  | Bksp |
   * |------+------+------+------+------+-------------+------+------+------+------+------|
   * | Del  |  F1  |  F2  |  F3  |  F4  |  F5  |  F6  |   -  |   =  |   [  |   ]  |  \   |
   * |------+------+------+------+------+------|------+------+------+------+------+------|
   * |      |  F7  |  F8  |  F9  |  F10 |  F11 |  F12 | Home | End  | PgUp | PgDn |Enter |
   * |------+------+------+------+------+------+------+------+------+------+------+------|
   * |      | Prev | Play | Next |      |             |      | Next | Vol- | Vol+ | Play |
   * `-----------------------------------------------------------------------------------'
   */
  [_RAISE] = LAYOUT_planck_mit( \
    KC_GRV,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,    KC_6,    KC_7,    KC_8,    KC_9,    KC_0,    KC_BSPC, \
    KC_DEL,  KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_MINS, KC_EQL,  KC_LBRC, KC_RBRC, KC_BSLS, \
    _______, KC_F7,   KC_F8,   KC_F9,   KC_F10,  KC_F11,  KC_F12,  KC_HOME, KC_END,  KC_PGUP, KC_PGDN, _______, \
    _______, KC_MRWD, KC_MPLY, KC_MNXT, _______, _______, _______, KC_MNXT, KC_VOLD, KC_VOLU, KC_MPLY \
  ),

  /* Numpad
   * ,-----------------------------------------------------------------------------------.
   * | Esc  |  7   |  8   |  9   |  *   |  /   |      |      |      |      |      |      |
   * |------+------+------+------+------+-------------+------+------+------+------+------|
   * | <--  |  4   |  5   |  6   |  +   |  -   |      |      |      |      |      |      |
   * |------+------+------+------+------+------|------+------+------+------+------+------|
   * |      |  1   |  2   |  3   |Enter |Enter |      |      |      |      |      |      |
   * |------+------+------+------+------+------+------+------+------+------+------+------|
   * |Qwerty|  0   |  .   |  .   |Enter |             |      |      |      |      |      |
   * `-----------------------------------------------------------------------------------'
   */
  [_NUMPAD] = LAYOUT_planck_mit( \
    KC_ESC,     KC_P7,   KC_P8,   KC_P9,   KC_PAST, KC_PSLS, _______, _______, _______, _______, _______, _______, \
    KC_BSPC,    KC_P4,   KC_P5,   KC_P6,   KC_PPLS, KC_PMNS, _______, _______, _______, _______, _______, _______, \
    _______,    KC_P1,   KC_P2,   KC_P3,   KC_PENT, KC_PENT, _______, _______, _______, _______, _______, _______, \
    TO(_QWERTY),KC_P0,   KC_PDOT, KC_PDOT, KC_PENT, _______, _______, _______, _______, _______, _______ \
  )
};
