// Copyright 2021 Kumao Kobo (@kumaokobo)
// SPDX-License-Identifier: GPL-2.0+

#include QMK_KEYBOARD_H
#include"keymap_japanese.h"


enum layer_number {
  _BASE,
  _FN1,
  _FN2,
  _FN3,
};

// Shortcut to make keymap more readable
#define LT_AESC LALT_T(KC_ESC)
#define LT_ALN1 LALT_T(JP_HENK)
#define LT_ALN2 LALT_T(JP_MHEN)
#define LT_GENT LGUI_T(KC_ENT)
#define LT_GSPC LGUI_T(KC_SPC)
#define LT_F1F  LT(_FN1, KC_F)
#define LT_F2J  LT(_FN1, KC_J)
#define LT_F2DL LT(_FN2, KC_DEL)


const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  [_BASE] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┬────────┐                ┌────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┐
     JP_ZKHK ,KC_1    ,KC_2    ,KC_3    ,KC_4    ,KC_5    ,KC_6    ,                 KC_6    ,KC_7    ,KC_8    ,KC_9    ,KC_0    ,JP_MINS ,JP_CIRC ,JP_YEN  ,KC_BSPC ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┤                └────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     KC_TAB  ,KC_Q    ,KC_W    ,KC_E    ,KC_R    ,KC_T    ,KC_ESC  ,                          KC_Y    ,KC_U    ,KC_I    ,KC_O    ,KC_P    ,JP_AT   ,JP_LBRC ,KC_DEL  ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┘                         ├────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     KC_LCTL ,KC_A    ,KC_S    ,KC_D    ,LT_F1F  ,KC_G,                                       KC_H    ,LT_F2J  ,KC_K    ,KC_L    ,JP_SCLN ,JP_COLN ,JP_RBRC ,KC_ENT  ,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                         ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┘
     KC_LSFT ,KC_Z    ,KC_X    ,KC_C    ,KC_V    ,KC_B    ,                          KC_UP   ,KC_N    ,KC_M    ,JP_COMM ,JP_DOT  ,JP_SLSH ,JP_BSLS ,KC_RSFT ,KC_UP   ,
  //├────────┼────────┼────────┼────────┼────────┼────────┐                         ├────────┼────────┼────────┴────────┼────────┼────────┼────────┼────────┼────────┤
     LT_AESC ,MO(_FN3),LT_F2DL ,LT_ALN2 ,LT_GENT ,KC_SPC  ,                          KC_DOWN ,LT_GSPC ,LT_ALN1 ,                           KC_LEFT ,KC_DOWN ,KC_RIGHT
  //└────────┴────────┴────────┴────────┴────────┴────────┘                         └────────┴────────┴────────┘                          └────────┴────────┴────────┘
  ),

  [_FN1] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┬────────┐                ┌────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┐
     _______ ,JP_EXLM ,JP_DQUO ,JP_HASH ,JP_DLR  ,JP_PERC ,JP_AMPR ,                 JP_AMPR ,JP_QUOT ,JP_LPRN ,JP_RPRN ,_______ ,JP_EQL  ,JP_TILD ,JP_PIPE ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┤                └────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,JP_DQUO ,JP_QUOT ,JP_HASH ,JP_ASTR ,JP_PLUS ,JP_CIRC ,                          JP_LPRN ,JP_RPRN ,JP_PIPE ,JP_ASTR ,JP_TILD ,JP_GRV  ,JP_LCBR ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┘                         ├────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,JP_AT   ,JP_COLN ,JP_GRV  ,_______ ,JP_MINS ,                                   JP_LBRC ,JP_RBRC ,JP_DOT  ,JP_SLSH ,JP_PLUS ,JP_ASTR ,JP_RCBR ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                         ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┘
     _______ ,_______ ,_______ ,JP_COMM ,JP_DOT  ,JP_SLSH ,                          JP_UNDS ,JP_LCBR ,JP_RCBR ,JP_LABK ,JP_RABK ,JP_QUES ,JP_UNDS ,_______ ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┐                         ├────────┼────────┼────────┴────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,                          _______ ,_______ ,_______ ,                           _______ ,_______ ,_______
  //└────────┴────────┴────────┴────────┴────────┴────────┘                         └────────┴────────┴────────┘                          └────────┴────────┴────────┘
  ),

  [_FN2] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┬────────┐                ┌────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┐
     _______ ,KC_F1   ,KC_F2   ,KC_F3   ,KC_F4   ,KC_F5   ,KC_F6   ,                 KC_F6   ,KC_F7   ,KC_F8   ,KC_F9   ,KC_F10  ,KC_F11  ,KC_F12  ,KC_DEL  ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┤                └────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,JP_DQUO ,JP_QUOT ,JP_HASH ,JP_ASTR ,JP_PLUS ,JP_CIRC ,                          JP_LPRN ,JP_RPRN ,JP_PIPE ,JP_ASTR ,JP_TILD ,JP_GRV  ,JP_LCBR ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┘                         ├────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,JP_AT   ,JP_COLN ,JP_GRV  ,_______ ,JP_MINS ,                                   JP_LBRC ,_______ ,JP_DOT  ,JP_SLSH ,JP_PLUS ,JP_ASTR ,JP_RCBR ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                         ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┘
     _______ ,_______ ,_______ ,JP_COMM ,JP_DOT  ,JP_SLSH ,                          _______ ,JP_LCBR ,JP_RCBR ,JP_SLSH ,JP_MINS ,JP_UNDS ,_______ ,_______ ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┐                         ├────────┼────────┼────────┴────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,                          _______ ,_______ ,_______ ,                           _______ ,_______ ,_______
  //└────────┴────────┴────────┴────────┴────────┴────────┘                         └────────┴────────┴────────┘                          └────────┴────────┴────────┘
  ),

  [_FN3] = LAYOUT(
  //┌────────┬────────┬────────┬────────┬────────┬────────┬────────┐                ┌────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┬────────┐
     _______ ,RGB_HUI ,RGB_HUD ,RGB_SAI ,RGB_SAD ,RGB_VAI ,RGB_VAD ,                 RGB_HUI ,RGB_HUD ,RGB_SAI ,RGB_SAD ,RGB_VAI ,RGB_VAD ,_______ ,_______ ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┤                └────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,                          _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┼────────┘                         ├────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,                                   _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┤                         ┌────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┼────────┘
     _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,                          _______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,_______ ,
  //├────────┼────────┼────────┼────────┼────────┼────────┐                         ├────────┼────────┼────────┴────────┼────────┼────────┼────────┼────────┼────────┤
     _______ ,_______ ,_______ ,MO(_BASE),RGB_MOD ,RGB_TOG ,                         RGB_TOG ,RGB_MOD ,MO(_BASE),                          _______ ,_______ ,_______
  //└────────┴────────┴────────┴────────┴────────┴────────┘                         └────────┴────────┴────────┘                          └────────┴────────┴────────┘
  )

};
