# Gaston's Lily58 Keymap

A simple three layers keymap to improve typing performance by reducing
cognitive load.

The main characteristics of this keymap are:

* The QWERTY layer tries to be as normal as possible, without having to use
  modifiers.
  * The main thumb buttons are spaces when tapped and enable the LOWER layer
    when held.
  * Vim style arrow keys.
  * Left and right ALT in case you need different behaviors. (For example, the
    default Option and readline's Alt behavior in macOS.)
* The LOWER layer has mostly meta keys.
* The MOUSE layer controls the mouse.

## QWERTY Layer

```plain
,-----------------------------------------.                    ,-----------------------------------------.
|   `  |   1  |   2  |   3  |   4  |   5  |                    |   6  |   7  |   8  |   9  |   0  | BSPC |
|------+------+------+------+------+------|                    |------+------+------+------+------+------|
| TAB  |   Q  |   W  |   E  |   R  |   T  |                    |   Y  |   U  |   I  |   O  |   P  |  -   |
|------+------+------+------+------+------|                    |------+------+------+------+------+------|
|LCTRL |   A  |   S  |   D  |   F  |   G  |-------.    ,-------|   H  |   J  |   K  |   L  |   ;  |  '   |
|------+------+------+------+------+------| MOUSE |    |    =  |------+------+------+------+------+------|
| LSFT |   Z  |   X  |   C  |   V  |   B  |-------|    |-------|   N  |   M  |   ,  |   .  |   /  | ENT  |
`-----------------------------------------/  LT   /     \  LT   \----------------------------------------'
                  | RALT | LALT | LGUI | / LOWER /       \ LOWER \  |   [  |   ]  |   \  |
                  |      |      |      |/  SPC  /         \  SPC  \ |      |      |      |
                  `----------------------------'           '-----------------------------'
```

## LOWER Layer

```plain
,-----------------------------------------.                    ,-----------------------------------------.
| ESC  |  F1  |  F2  |  F3  |  F4  |  F5  |                    |  F6  |  F7  |  F8  |  F9  | F10  | F11  |
|------+------+------+------+------+------|                    |------+------+------+------+------+------|
| TRNS |      | MUTE | VOLD | VOLU |      |                    | HOME | PGDN | PGUP | END  |      | F12  |
|------+------+------+------+------+------|                    |------+------+------+------+------+------|
| TRNS |      | MPRV | MPLY | MNXT |      |-------.    ,-------| LEFT | DOWN | UP   | RGHT |      |      |
|------+------+------+------+------+------|       |    |       |------+------+------+------+------+------|
| TRNS |      |      | BRID | BRIU |      |-------|    |-------|      | INS  | DEL  |      |      |      |
`-----------------------------------------/       /     \       \----------------------------------------'
                  | TRNS | TRNS | TRNS | / TRNS  /       \ TRNS  \  |      |      |      |
                  |      |      |      |/       /         \       \ |      |      |      |
                  `----------------------------'           '-----------------------------'
```

## MOUSE Layer

```plain
,-----------------------------------------.                    ,-----------------------------------------.
|      |      |      |      |      |      |                    |      |      |      |      |      |      |
|------+------+------+------+------+------|                    |------+------+------+------+------+------|
|      |      |      |      |      |      |                    | BTN1 | BTN2 |      |      | ACL0 |      |
|------+------+------+------+------+------|                    |------+------+------+------+------+------|
|      |      |      |      |      |      |-------.    ,-------| MS_L | MS_D | MS_U | MS_R | ACL1 |      |
|------+------+------+------+------+------| TRNS  |    |       |------+------+------+------+------+------|
|      |      |      |      |      |      |-------|    |-------| WH_L | WH_D | WH_U | WH_R | ACL2 |      |
`-----------------------------------------/       /     \       \----------------------------------------'
                  |      |      |      | /       /       \       \  |      |      |      |
                  |      |      |      |/       /         \       \ |      |      |      |
                  `----------------------------'           '-----------------------------'
```
