// Copyright 2022 catmunch (@catmunch)
// SPDX-License-Identifier: GPL-2.0-or-later

#include "quantum.h"

static bool encoder_pressed = 0;
static bool encoder_switched_layer = 0;
static uint32_t encoder_last_release_time = 0;
static uint32_t encoder_press_combo = 0;
static uint8_t current_layer = 0;

#ifdef OLED_ENABLE
static const char PROGMEM bongo_release[] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,128,192,192, 96, 96, 48, 48, 24, 12,  6, 14, 60,112, 96,224,192,192,192,192,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,192,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192,240,124, 12, 12, 12, 12, 24,120,108, 14,  7,  3,  1,  0,128,192,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  3,  3,  7,  6, 14, 12, 28, 24, 48, 48, 24, 24, 12,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  7,  6,  6,  6,  6, 12, 12, 15, 15, 24, 24, 24, 24, 48, 48, 48, 48,112, 96, 96, 96,224,193,193,193,192,131,134,134,134, 12, 12,  0,  0,  0,  0,  0, 48, 56, 16,240,252, 12,  6,134,  6, 12, 60, 48, 32,  0,  0, 48,126,239,131,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  3,  6,  6,  6,  6, 12, 12, 15, 15, 24, 24, 24, 24, 56, 48, 48, 48,112, 96, 96, 96,225,207,254,248,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,
};
static const char PROGMEM bongo_press_r[] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,128,192,192, 96, 96, 48, 48, 24, 12,  6, 14, 60,112, 96,224,192,192,192,192,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,192,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192,240,124, 12, 12, 12, 12, 24,120,108, 14,  7,  3,  1,  0,128,192,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  3,  3,  7,  6, 14, 12, 28, 24, 48, 48, 24, 24, 12,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  7,  6,  6,  6,  6, 12, 12, 15, 15, 24, 24, 24, 24, 48, 48, 48, 48,112, 96, 96, 96,224,193,193,193,192,131,134,134,134, 12, 12,  0,  0,  0,  0,  0, 48, 56, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 48,126,239,131,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  3,  6,  6, 22,126,111,227,192,224, 96, 96, 96, 96,112, 48, 48, 48,112, 96, 96, 96,225,207,254,248,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,
};
static const char PROGMEM bongo_press_l[] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,128,192,192, 96, 96, 48, 48, 24, 12,  6, 14, 60,112, 96,224,192,192,192,192,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,192,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,192, 96, 48, 24, 12, 14,  7,  3,  1,  0,128,192,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  3,  3,  7,  6, 14, 12, 28, 24, 48, 48, 24, 24, 12,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  7,  6,  6,  6,  6, 12, 12,124,252,206,131,129,192,192,192,192,224, 96, 96, 96, 96,224,193,193,193,192,131,134,134,134, 12, 12,  0,  0,  0,  0,  0, 48, 56, 16,240,252, 12,  6,134,  6, 12, 60, 48, 32,  0,  0, 48,126,239,131,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  3,  6,  6,  6,  6, 12, 12, 15, 15, 24, 24, 24, 24, 56, 48, 48, 48,112, 96, 96, 96,225,207,254,248,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,
};
static const char PROGMEM bongo_press_lr[] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,128,192,192, 96, 96, 48, 48, 24, 12,  6, 14, 60,112, 96,224,192,192,192,192,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,192,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,192, 96, 48, 24, 12, 14,  7,  3,  1,  0,128,192,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  3,  3,  7,  6, 14, 12, 28, 24, 48, 48, 24, 24, 12,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  7,  6,  6,  6,  6, 12, 12,124,252,206,131,129,192,192,192,192,224, 96, 96, 96, 96,224,193,193,193,192,131,134,134,134, 12, 12,  0,  0,  0,  0,  0, 48, 56, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 48,126,239,131,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  3,  3,  3,  3,  3,  6,  6, 22,126,111,227,192,224, 96, 96, 96, 96,112, 48, 48, 48,112, 96, 96, 96,225,207,254,248,192,128,128,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    0,
};
static const char PROGMEM layer[][116] = {
    [0] = {
        248,  0,  0,  0,  0,  0,  0,160,160,192,  0,  0, 96,128,128,128,224,  0,192,160,160,160,192,  0,224, 64, 32, 32, 64,
          3,  2,  2,  2,  2,  0,  1,  2,  2,  3,  2,128,130,132,132,132,131,  0,  1,  2,  2,  2,  0,  0,  3,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,254,254,129,129, 97, 97, 25, 25,254,254,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  7, 25, 25, 24, 24, 24, 24,  7,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    },
    [1] = {
        248,  0,  0,  0,  0,  0,  0,160,160,192,  0,  0, 96,128,128,128,224,  0,192,160,160,160,192,  0,224, 64, 32, 32, 64,
          3,  2,  2,  2,  2,  0,  1,  2,  2,  3,  2,  0,  2,132,132,  4,  3,  0,  1,  2,  2,  2,  0,  0,  3,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  6,255,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 24, 31, 31, 24, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    },
    [2] = {
        248,  0,  0,  0,  0,  0,  0,160,160,192,  0,  0, 96,128,128,128,224,  0,192,160,160,160,192,  0,224, 64, 32, 32, 64,
          3,  2,  2,  2,  2,  0,  1,  2,  2,  3,  2,128,130,132,132,132,131,  0,  1,  2,  2,  2,  0,  0,  3,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,134,134, 97, 97, 97, 97, 97, 97, 30, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0, 31, 31, 24, 24, 24, 24, 24, 24, 24, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    },
    [3] = {
        248,  0,  0,  0,  0,  0,  0,160,160,192,  0,  0, 96,128,128,128,224,  0,192,160,160,160,192,  0,224, 64, 32, 32, 64,
          3,  2,  2,  2,  2,  0,  1,  2,  2,131,130,128,130,132,132,132,131,128,129,  2,  2,  2,  0,  0,  3,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1, 97, 97,121,121,135,135,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  6, 24, 24, 24, 24, 24, 24,  7,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    }
};
static uint8_t key_pressed_l = 0;
static uint8_t key_pressed_r = 0;
oled_rotation_t oled_init_kb(oled_rotation_t rotation) {
    return OLED_ROTATION_180;
}
bool oled_task_kb(void) {
    if (!oled_task_user()) {
        return false;
    }

    char buffer[512];
    if (key_pressed_l && key_pressed_r) 
        memcpy_P(buffer, bongo_press_lr, 512);
    else if (key_pressed_l)
        memcpy_P(buffer, bongo_press_l, 512);
    else if (key_pressed_r)
        memcpy_P(buffer, bongo_press_r, 512);
    else
        memcpy_P(buffer, bongo_release, 512);
    int highest_layer = 0;
    for(int i=3;i>=0;--i){
        if (IS_LAYER_ON(i)) {
            highest_layer = i;
            break;
        }
    }
    // Apply the layer info (4*29)
    for(int i=0;i<4;i++){
        for(int j=0;j<29;j++){
            buffer[i*128+85+j] = pgm_read_byte_near(layer[highest_layer]+i*29+j);
        }
    }
    oled_write_raw(buffer, 512);
    return false;
}
bool process_record_kb(uint16_t keycode, keyrecord_t *record) {
    if (!process_record_user(keycode, record)) {
        return false;
    }
    if (record->event.pressed) {
        if (record->event.key.col <= 1)
            key_pressed_l++;
        else
            key_pressed_r++;
    } else {
        if (record->event.key.col <= 1)
            key_pressed_l--;
        else
            key_pressed_r--;
    }
    return true;
}
#endif
void encoder_single_click(void) {
    tap_code(KC_MPLY);
}
void encoder_double_click(void) {
    tap_code(KC_MNXT);
}
void encoder_triple_click(void) {
    tap_code(KC_MPRV);
}
void matrix_init_kb() {
    matrix_init_user();

    setPinInputHigh(ENCODER_SWITCH);
}
void matrix_scan_kb() {
    matrix_scan_user();
    if (readPin(ENCODER_SWITCH)) {
        if (encoder_pressed) { // release switch
            encoder_pressed = 0;
            encoder_press_combo += 1;
            encoder_last_release_time = timer_read32();
        }
        if (encoder_press_combo && timer_elapsed(encoder_last_release_time) > 300) {
            // combo timeout
            if (encoder_switched_layer) { // switch layer
                encoder_switched_layer = 0;
            } else { // click
                switch (encoder_press_combo) {
                    case 1:
                        encoder_single_click();
                        break;
                    case 2:
                        encoder_double_click();
                        break;
                    default:
                        encoder_triple_click();
                }
            }
            encoder_press_combo = 0;
            encoder_last_release_time = 0;
        }
    } else {
        if (!encoder_pressed) { // press switch
            encoder_pressed = 1;
        }
    }
}
bool encoder_update_kb(uint8_t index, bool clockwise) {
    if (!encoder_update_user(index, clockwise)) {
        return false; 
    }
    if (clockwise) {
        if (encoder_pressed) {
            if (current_layer < 3) {
                current_layer += 1;
                layer_move(current_layer);
            }
            encoder_switched_layer = 1;
        } else {
            tap_code(KC_VOLU);
        }
    } else {
        if (encoder_pressed) {
            if (current_layer > 0) {
                current_layer -= 1;
                layer_move(current_layer);
            }
            encoder_switched_layer = 1;
        } else {
            tap_code(KC_VOLD);
        }
    }
    return false;
}
