# MiniDox Bepo

As the minidox has a restricted number of keys as compared to regular keyboards, some adjustments were made.  
These adjustments allow for improved ergonomics when typing English and programming languages (in particular javascript).  

>Keys have been grouped and rearranged to meet the needs of principals programming usages. Most used groups are placed at the opposite of thumb layout-activation key, not to seek the same hand too much: 
  1. **Arrows/Navigation:** most used with `2.` after standard characters. To navigate comfortably during a long time, the group is placed at the opposite of the thumb-activated layout key.
  2. **Programming blocks characters:** most used with `1.` after standard characters. *Group placed at the opposite of the thumb-activated layout key*.
  3. **Operators:** less used than navigation. *Same side of the thumb-activated layout key*.
  4. **French special characters:** to keep basic characters on main layout and because they are less used in programming and english, french special characters have been moved to a specific layout, counter to Bepo's original main layout. *Same side of the thumb-activated layout key.*

*Here is a list of other ergonomic choices :*

- `Alt` both sides (instead of `AltGr`), as special characters are now handled by layouts, and to comfortably get all shortcuts with both hands (e.g. `alt/tab`...).
- Numbers on home row, and Function keys on corresponding upper row.
- Greater/less-than-sign in place of `«` `»`, for easier programming, and because the majority of OS and softwares replace `"` with `«` `»`. 
- Mirror `&` and `|` on little finger, lower row, raise layout (`raiser + &` on little finger is more handy than `raiser + &` on index finger).
- `’/?` in place of `È` to keep `M` on the right hand side.
- Better reachability for `W` `Z` `~` `backtick`...

## Firmware : 
[Recent bepo firmware](https://bepo.fr/wiki/Accueil) `1.1rc2` switched generic apostrophe and typographic one.
As the majority of OS and softwares replace **`'`** with **`’`**, I personnaly do prefer 2008 bepo firmware which keeps generic apostrophe on main layout. In fact, the apostrophe get replaced in text editors, but not in the IDEs while programming.
Or you also can [switch them by following those instructions.](https://bepo.fr/wiki/Apostrophe)

## Layout :
![Minidox - Bepo custom layout by dolie](https://user-images.githubusercontent.com/18349922/77227968-f42d9980-6b7b-11ea-9a11-58b1f47842e9.png)

#### N.B.
I have been using and fine tuned this layout for about a year, and I really enjoy it. 🙂    

