# Minidox Norman Layout by LeHoff
Based on the QWERTY layout created by Khitsule.
![lehoff](https://i.imgur.com/rKTdymp.png)

[KLE link](http://www.keyboard-layout-editor.com/#/gists/86ec49f9f820a8b9b36f6e0d2ef8fff7)

## Layers
| Layer | Legend |
| ----- | ------ |
| Base  |  Top left (black) |
| Lower | Bottom right (red) |
| Raise | Top right (orange) |
| Adjust | Front print |

## Features
* Raise/lower layers focus first on one-handed use
* Numpad on right hand with raise layer
* Navigation on left hand with lower layer (ESDF)
    * D refers to desktop left/right on Win 10 (win+ctrl+left/right)
* Heavy use of hold/tap dual function keys - from left to right:
    * Cmd/Enter
    * Raise/Esc
    * Shift/Backspace
    * Ctrl/Space
    * Lower/Tab
    * Alt/Enter


## Modifier Placement Rationale

There are several major driving forces at play:

* I use MacOS.
* I'm Danish so the Alt and Shift-Alt layers in MacOS simply have to work.
* I use Vim for coding.
* I use org-mode in Emacs to keep track of my time.

* Space is on the right hand side because I almost exclusively use my right hand thumb for
  space.
* Cmd is on the left since I often use Cmd+click to open a link in a new tab in Safari.
* Due to my usage of Vim Esc got a spot on the modifier row.
* Tab is on the right to enable easy navigation between winows with Cmd+Tab.
* Shift is on the left since org-mode uses Ctrl+arrows to manipulate task state quickly,
 and since the arrow keys are activated using Lower (which has been moved to the right) and S, E, T,
 and D, it works well that way. 
* Ctrl is on the right since Ctrl+<0-9> is used in MacOS to switch between spaces.
* Enter is on both sides since Enter is often used together with all of the modifiers. E.g.,
  Cmd+Enter to send mails in most situations, but Ctrl+Enter is used in Emacs to create a
  new task in org-mode.
 
This means that arrows and digits are being modified from the other hand, which could be
bad for gaming, so if you're into that you might want to re-think a few things, but in
that case you are probably using a Windows machine and then there are other constraints
you have to deal with.


