# ninjonas Keymap for [Pinky3](https://github.com/tamanishi/Pinky3)

## Keymap
This keymap is designed based off my typing habits and is subject to change. Information about custom user macros and tap dances can be found [here](../../../../../users/ninjonas).

More information about the Pinky3 keyboard can be found [here](https://github.com/tamanishi/Pinky3)

### QWERTY
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|      Tab|        Q|        W|        E|        R|        T|     Play|  |     Mute|        Y|        U|        I|        O|        P|        \|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
| Esc/Caps|        A|        S|        D|        F|        G|        [|  |        ]|        H|        J|        K|        L|        ;|        '|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|    Shift|        Z|        X|        C|        V|        B|  Spc/RAI|  |  Ent/LOW|        N|        M|        ,|        .|        /|        =|
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |      ALT|        Cmd|     CTRL|  KC_LAPP|  |  KC_RAPP| BckSpace|      Del|    LOWER|
                              `---------------------------------------'  `---------------------------------------'
*/
```

### DVORAK
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|      Tab|        '|        ,|        .|        P|        Y|     Play|  |     Mute|        F|        G|        C|        R|        L|        \|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
| Esc/Caps|        A|        O|        E|        U|        I|        [|  |        ]|        D|        H|        T|        N|        S|        /|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|    Shift|        ;|        Q|        J|        K|        X|  Spc/RAI|  |  Ent/LOW|        B|        M|        W|        V|        Z|        =|
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |      ALT|        Cmd|     CTRL|  KC_LAPP|  |  KC_RAPP| BckSpace|      Del|    LOWER|
                              `---------------------------------------'  `---------------------------------------'
*/
```

### COLEMAK
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|      Tab|        Q|        W|        F|        P|        G|     Play|  |     Mute|        J|        L|        U|        Y|        ;|        \|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
| Esc/Caps|        A|        R|        S|        T|        D|        [|  |        ]|        H|        N|        E|        I|        O|        '|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|    Shift|        Z|        X|        C|        V|        B|  Spc/RAI|  |  Ent/LOW|        K|        M|        ,|        .|        /|        =|
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |      ALT|        Cmd|     CTRL|  KC_LAPP|  |  KC_RAPP| BckSpace|      Del|    LOWER|
                              `---------------------------------------'  `---------------------------------------'
*/
```

### LOWER
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|         |         |         |    BriUp|     Play|     Mute|   K_CSCN|  |         |     PgUp|     Home|       Up|      End|         |   K_MDSH|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|         |         |         |    BriDn|     Next|    VolUp|         |  |         |     PgDn|     Left|     Down|    Right|   K_LOCK|         |
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|   M_SHFT|         |         |         |     Prev|    VolDn|         |  |         |         |         |         |         |         |   M_PYNV|
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |         |         |         |         |  |         |         |   M_CODE|         |
                              `---------------------------------------'  `---------------------------------------'
*/
```

### RAISE
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|        `|        1|        2|        3|        4|        5|         |  |         |        6|        7|        8|        9|        0|        -|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|        ~|        !|        @|        #|        $|        %|         |  |         |        ^|        &|        *|        (|        )|        _|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|      F11|       F2|       F3|       F4|       F4|       F5|         |  |         |       F6|       F7|       F8|       F9|      F10|      F12|
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |         |         |         |         |  |         |         |         |         |
                              `---------------------------------------'  `---------------------------------------'
*/
```

### ADJUST
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|   M_MAKE|  EE_CLR |         |         |         |         |         |  |         |         |         |         |  COLEMAK|   DVORAK|   QWERTY|
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|   M_VRSN|         |         |         |         |         |         |  |         |         |         |         |         |         |         |
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|   M_FLSH|         |         |         |         |         |         |  |         |         |         |         |         |         |         |
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |         |         |         |         |  |         |         |         |         |
                              `---------------------------------------'  `---------------------------------------'
*/
```

<!--
### TEMPLATE
```c
/*
,---------------------------------------------------------------------.  ,---------------------------------------------------------------------.
|         |         |         |         |         |         |         |  |         |         |         |         |         |         |         |
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|         |         |         |         |         |         |         |  |         |         |         |         |         |         |         |
|---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------|
|         |         |         |         |         |         |         |  |         |         |         |         |         |         |         |
`---------+---------+---------+---------+---------+---------+---------|  |---------+---------+---------+---------+---------+---------+---------'
                              |         |         |         |         |  |         |         |         |         |
                              `---------------------------------------'  `---------------------------------------'
*/
```
-->