Bone2Planck
=====================================

This layout tries to emulate the Bone2 variant of Neo2, and is intended to be used with a German QWERTZ softwarelayout.
It has "üäöß" as it is optimized for a mix of German & English.
The special character layer and the navigation & number block layer are inspired by the Neo2 layers,
designed to keep the fingers near the home row.

Bone2 wiki page: http://wiki.neo-layout.org/wiki/Bone

To build, run "make" from within the \bone2planck folder.

## Bone2 (adapted) Base Layer
```
 ,-----------------------------------------------------------------------------------.
 |  ß   |   J  |   D  |   U  |   A  |   X  |   P  |   H  |   L  |   M  |   W  |  Q   |
 |------+------+------+------+------+-------------+------+------+------+------+------|
 |  M1  |   C  |   T  |   I  |   E  |   O  |   B  |   N  |   R  |   S  |   G  |M1/Ent| hold: M1, tap: Enter
 |------+------+------+------+------+------|------+------+------+------+------+------|
 | Shift|   F  |   V  |   Ü  |   Ä  |   Ö  |   Y  |   Z  |   ,  |   .  |   K  |Shift |
 |------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |  M4  |  M2  |    Space    |  M2  |  M4  | Alt  | Esc  | Ctrl |
 `-----------------------------------------------------------------------------------'
```

## M1 Special Characters
  very ergonomic placement for coding
```
 ,-----------------------------------------------------------------------------------.
 |  °   |   @  |   _  |   [  |   ]  |   ^  |   !  |   <  |   >  |   =  |   &  |  ´   |
 |------+------+------+------+------+-------------+------+------+------+------+------|
 |  M1  |   \  |   /  |   {  |   }  |   *  |   ?  |   (  |   )  |   -  |   :  |M1/Ent| hold: M1, tap: Enter
 |------+------+------+------+------+------|------+------+------+------+------+------|
 | Shift|   #  |   ~  |   |  |   $  |   €  |   +  |   %  |   "  |   '  |   ;  |Shift |
 |------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |  M4  |  M2  |    Space    |  M2  |  M4  | Alt  | Esc  | Ctrl |
 `-----------------------------------------------------------------------------------'
```

## M2 Navigation & Number Blocks
  very easy to get used to & intuituve placement
```
 ,-----------------------------------------------------------------------------------.
 |      | PgUp | Bksp |  Up  |  DEL | PgDn |      |   7  |   8  |   9  |      | Ins  |
 |------+------+------+------+------+-------------+------+------+------+------+------|
 |  Tab | Home |  Lft | Down | Right| End  |      |   4  |   5  |   6  |   .  | Enter|
 |------+------+------+------+------+------|------+------+------+------+------+------|
 | Shift|      |  Tab |      | Enter|      |   0  |   1  |   2  |   3  |   ,  |Shift |
 |------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |  M3  |  M2  |    Space    |  M2  |  M3  | Alt  | Esc  | Ctrl |
 `-----------------------------------------------------------------------------------'
```

## M4 Function & Media Keys
```
 ,-----------------------------------------------------------------------------------.
 |      |      | Print|Scroll|Pause |      |      |  F7  |  F8  |  F9  |  F12 |      |
 |------+------+------+------+------+-------------+------+------+------+------+------|
 |  Tab |      | Mute | Vol- | Vol+ |      |   ³  |  F4  |  F5  |  F6  |  F11 | Enter|
 |------+------+------+------+------+------|------+------+------+------+------+------|
 | Shift|      | Prev | Play | Next |      |   ²  |  F1  |  F2  |  F3  |  F10 |Shift |
 |------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |  M4  |  M5  |    Space    |  M5  |  M4  | Alt  | Esc  | Ctrl |
 `-----------------------------------------------------------------------------------'
```


##Switched layers for one handed access:

### M3 Switched Navigation & Number Blocks
  accessed by sliding from M2 to M3 with thumb
```
 ,-----------------------------------------------------------------------------------.
 | Ins  |      |  7   |  8   |  9   |      | PgUp | Bksp |  Up  |  DEL | PgDn |      |
 |------+------+------+------+------+-------------+------+------+------+------+------|
 |  Tab |      |  4   |  5   |  6   |   .  | Home | Left | Down | Right| End  | Enter|
 |------+------+------+------+------+------|------+------+------+------+------+------|
 | Shift|  0   |  1   |  2   |  3   |   ,  |      | Tab  |      | Enter|      |Shift |
 |------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |  M3  |      |    Space    |      |  M3  | Alt  | Esc  | Ctrl |
 `-----------------------------------------------------------------------------------'
```

### M5 Switched Function & Media Keys
  accessed by sliding from M4 to M5 with thumb
```
 ,-----------------------------------------------------------------------------------.
 |      |      |  F7  |  F8  |  F9  |  F12 |      | Print|Scroll| Pause|      |      |
 |------+------+------+------+------+-------------+------+------+------+------+------|
 |  Tab |  ³   |  F4  |  F5  |  F6  |  F11 |      | Mute | Vol- | Vol+ |      | Enter|
 |------+------+------+------+------+------|------+------+------+------+------+------|
 | Shift|  ²   |  F1  |  F2  |  F3  |  F10 |      | Prev | Play | Next |      |Shift |
 |------+------+------+------+------+------+------+------+------+------+------+------|
 | Ctrl | GUI  | Alt  |      |  M5  |    Space    |  M5  |      | Alt  | Esc  | Ctrl |
 `-----------------------------------------------------------------------------------'
```