#pragma once

#ifdef AUDIO_ENABLE
#define STARTUP_SONG SONG(PLANCK_SOUND)
#endif

/*
 * MIDI options
 */

/* enable basic MIDI features:
   - MIDI notes can be sent when in Music mode is on
*/

#define MIDI_BASIC
#define AUDIO_CLICKY
#define AUDIO_CLICKY_FREQ_DEFAULT 2360.0f
#define AUDIO_CLICKY_FREQ_MAX 9500.0f
#define AUDIO_CLICKY_FREQ_RANDOMNESS 0.05f
#define DAC_SAMPLE_MAX 9754U

/* enable advanced MIDI features:
   - MIDI notes can be added to the keymap
   - Octave shift and transpose
   - Virtual sustain, portamento, and modulation wheel
   - etc.
*/
//#define MIDI_ADVANCED

/* override number of MIDI tone keycodes (each octave adds 12 keycodes and allocates 12 bytes) */
//#define MIDI_TONE_KEYCODE_OCTAVES 2

// Most tactile encoders have detents every 4 stages
#define ENCODER_RESOLUTION 4
#define ORYX_CONFIGURATOR