# Corvec's Planck Layout

This layout is a development-focused layout with an emphasis on ergonomics. It is intended to be used in Colemak mode,
but has a full-QWERTY mode for gaming compatibility.

It utilizes redundancy for common keys so that they are more easily accessible in every task. For example, the common
layers, Raise and Lower, both can be activated with two different keys, each pressed with either hand. Certain symbols
( \~|+_ ) are on both layers, since the keys they take up are a bit out of the way. The minus symbol is available on the
quote key in a variety of ways - both layers, as well as via tap dance.

The right-hand Lower activation key activates a slightly different layer. The keys accessed by the opposite hand are the
same as the Lower layer, but the keys on the right hand differ. For this reason, we refer to this instead as the
Leandown layer.

Auto-shift is enabled, but there are also three shift keys, since typing with auto-shift is by necessity slow.

Movement is done Vim-style, on the hjkl / hnei keys, on the Lower layer so that it is easiest to activate it.
The arrow keys are mimicked by Home/PgDn/PgUp/End on the next row.

The arrow keys and broad navigation keys are replaced by a symbol-pad on the Leandown layer. However, in order to allow
single-hand navigation, the bottom right corner cluster becomes arrow keys.

Media keys are in the same location as the arrow keys, but are on the Wobble layer instead.

Toggle layers are minimized so that the state of the keyboard is more predictable. Shift Toggle is in the works, but
will not be included until it can be set to deactivate automatically.

Delete is accessible from the third Shift key.
