#include QMK_KEYBOARD_H

// Each layer gets a name for readability, which is then used in the keymap matrix below.
// The underscores don't mean anything - you can have a layer called STUFF or any other name.
// Layer names don't all need to be of the same length, obviously, and you can also skip them
// entirely and just use numbers.

#define QWERTY 0
#define LOWER 1
#define RAISE 2
#define FUNCTION 3

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

/* Qwerty
 * ,-----------------------------------------------------------------------------------.
 * | Tab  |   Q  |   W  |   E  |   R  |   T  |   Y  |   U  |   I  |   O  |   P  | Bksp |
 * |------+------+------+------+------+-------------+------+------+------+------+------|
 * | Esc  |   A  |   S  |   D  |   F  |   G  |   H  |   J  |   K  |   L  |   ;  |  '   |
 * |------+------+------+------+------+------|------+------+------+------+------+------|
 * | Ctrl |   Z  |   X  |   C  |   V  |   B  |   N  |   M  |   ,  |   .  |   /  |Enter |
 * |------+------+------+------+------+------+------+------+------+------+------+------|
 * |      | alt  |play/p| super|shift | Space|Raise | lower|  alt | altgr|      |fn    |
 * `-----------------------------------------------------------------------------------'
 */
[QWERTY] = LAYOUT_planck_grid(
  KC_TAB,  KC_Q,    KC_W,    KC_E,    KC_R,    KC_T,    KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,    KC_BSPC,
  KC_ESC,  KC_A,    KC_S,    KC_D,    KC_F,    KC_G,    KC_H,    KC_J,    KC_K,    KC_L,    KC_SCLN, KC_QUOT,
  KC_LCTL, KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,    KC_N,    KC_M,    KC_COMM, KC_DOT,  KC_SLSH, KC_ENT ,
  _______, KC_LALT, LT(FUNCTION, KC_MPLY), KC_LGUI, KC_LSFT,      KC_SPC,  MO(RAISE),   MO(LOWER),   KC_LALT, KC_RALT, XXXXXXX,   MO(FUNCTION)
),

/* Lower
 * ,-----------------------------------------------------------------------------------.
 * |   ~  |   !  |   @  |   #  |   $  |   %  |   ^  |   &  |   *  |   (  |   )  |      |
 * |------+------+------+------+------+-------------+------+------+------+------+------|
 * |      |      |  {   |  }   |  +   |      |      | Å    |  Ä   |  Ö   |   _  |      |
 * |------+------+------+------+------+------|------+------+------+------+------+------|
 * |      |      |      |      |      |      |      |      |      |      |   \  |      |
 * |------+------+------+------+------+------+------+------+------+------+------+------|
 * |      |      |      |      |      |             |      |      |      |      |      |
 * `-----------------------------------------------------------------------------------'
 */
[LOWER] = LAYOUT_planck_grid(
  KC_TILD, KC_EXLM, KC_AT,   KC_HASH, KC_DLR,  KC_PERC, KC_CIRC, KC_AMPR, KC_ASTR, KC_LPRN, KC_RPRN, KC_BSPC,
  _______, _______,   KC_LCBR,   KC_RCBR,   KC_PLUS,   _______,   _______,   RALT(KC_W), RALT(KC_Q), RALT(KC_P), KC_UNDS, _______,
  _______, _______,   _______,   _______,   _______,  _______,  _______,_______, _______,_______, KC_BSLS, _______,
  _______,   _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______
),

/* Raise
 * ,-----------------------------------------------------------------------------------.
 * |   `  |   1  |   2  |   3  |   4  |   5  |   6  |   7  |   8  |   9  |   0  |  del |
 * |------+------+------+------+------+-------------+------+------+------+------+------|
 * |      |      |  [   |  ]   |  =   |      |  left|  down|  up  | right|   -  |      |
 * |------+------+------+------+------+------|------+------+------+------+------+------|
 * |      |      |      |      |      |      |      |      |      |      |   |  |      |
 * |------+------+------+------+------+------+------+------+------+------+------+------|
 * |      |      |      |      |      |             |      |      |      |      |      |
 * `-----------------------------------------------------------------------------------'
 */
[RAISE] = LAYOUT_planck_grid(
  KC_GRV,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,    KC_6,    KC_7,    KC_8,    KC_9,    KC_0,    KC_DEL,
  _______,  _______,   KC_LBRC,   KC_RBRC,   KC_EQL,   _______,   KC_LEFT,   KC_DOWN, KC_UP,  KC_RIGHT, KC_MINS, _______,
  _______, _______,   _______,   _______,   _______,  _______,  _______,  _______, _______, _______, KC_PIPE, _______,
  _______,   _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______
),

/* Fn
 * ,-----------------------------------------------------------------------------------.
 * |  F1  |  F2  |  F3  |  F4  |  F5  |  F6  |  F7  |  F8  |  F9  | F10  |  F11 |  F12 '
 * |------+------+------+------+------+-------------+------+------+------+------+------|
 * |      |      |      |      |      |      | prev | vol.d| vo.up| next |      |      |
 * |------+------+------+------+------+------|------+------+------+------+------+------|
 * |      |      |      |      |      |      | mute |      |      |      |      |      |
 * |------+------+------+------+------+------+------+------+------+------+------+------|
 * |      |      |      |      | CAPS |      |      |      |      |      |      |      |
 * `-----------------------------------------------------------------------------------'
 */
[FUNCTION] = LAYOUT_planck_grid(
  KC_F1,  KC_F2,    KC_F3,    KC_F4,    KC_F5,    KC_F6,    KC_F7,    KC_F8,    KC_F9,    KC_F10,    KC_F11,    KC_F12,
  _______, _______,   _______,   _______,   _______,  _______,  KC_MEDIA_PREV_TRACK,  KC_AUDIO_VOL_DOWN, KC_AUDIO_VOL_UP, KC_MEDIA_NEXT_TRACK, _______, _______,
  _______,   _______, _______, _______, _______, _______, _______, KC_AUDIO_MUTE, _______, _______, _______, _______,
  _______,  _______,   _______,   _______,   KC_CAPS,   _______,   _______,   _______, _______,  _______, _______, _______
),

};
