kanbara's layout
=======================
This layout contains a Colemak and Qwerty mode (for easier pair programming with colleagues)
as well as a mode specifically to play League of Legends, as the normal mode does not provide
for accessible enough numbers and function keys


## Base Layers (Qwerty/Colemak/League)
After lots of tweaking, I've found that putting brackets in the middle is easier for
programming, and having a separate numpad input is quite handy.

- Contains split `space` and `enter`
- Designed for macOS
- Keeps the `Tab`/`Esc` swap which I quite like
- Note the removal of evil caps lock

### Qwerty
```
,-----------------------------------------------------------------------------------.
| Tab  |   Q  |   W  |   E  |   R  |   T  |   Y  |   U  |   I  |   O  |   P  | Bksp |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Esc  |   A  |   S  |   D  |   F  |   G  |   H  |   J  |   K  |   L  |   ;  |  "   |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Shift|   Z  |   X  |   C  |   V  |   B  |   N  |   M  |   ,  |   .  |   /  |Enter |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Adjst| Ctrl | Alt  | GUI  | SPC  | Lower| Raise| Enter| Left | Down |  Up  |Right |
`-----------------------------------------------------------------------------------'
```

### Colemak
```
,-----------------------------------------------------------------------------------.
| Tab  |   Q  |   W  |   F  |   P  |   G  |   J  |   L  |   U  |   Y  |   ;  | Bksp |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Esc  |   A  |   R  |   S  |   T  |   D  |   H  |   N  |   E  |   I  |   O  |  "   |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Shift|   Z  |   X  |   C  |   V  |   B  |   K  |   M  |   ,  |   .  |   /  |Enter |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Adjst| Ctrl | Alt  | GUI  | SPC  | Lower| Raise| Enter| Left | Down |  Up  |Right |
`-----------------------------------------------------------------------------------'
```

### League

- Has it's own raise just for F-keys and Ctrl+{Q,W,E,R} as a hold toggle
- Just the base keys needed for the game + the adjust and backspace

```
,-----------------------------------------------------------------------------------.
| Tab  |  1   |  2   |  3   |  4   |  5   |  6   |  7   |      |      |      | Bksp |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Esc  |  Q   |  W   |  E   |  R   |  G   |      |      |      |      |      |      |
|------+------+------+------+------+------+------+------+------+------+------+------|
|   P  |  B   |  S   |  D   |  F   |      |      |      |      |      |      |      |
|------+------+------+------+------+------+------+------+------+------+------+------|
|Adjust|      |      |      |      | Spc  | Raise|      | Ent  |      |      |      |
`-----------------------------------------------------------------------------------'
```

#### Raise
```
,-----------------------------------------------------------------------------------.
|      |  F2  |  F3  |  F4  |  F5  |      |      |      |      |      |      |      |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |Ctrl-Q|Ctrl-W|Ctrl-E|Ctrl-R|      |      |      |      |      |      |      |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |      |      |      |      |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |      |      |      |      |
`-----------------------------------------------------------------------------------'
```

## Lower Layer (Programming symbols + numpad)
I've put a numpad on the right side, and brackets in the middle. I found that putting
the shifted equivalents of `-`, `+`, `\` and `~` are quite convenient to type with one hand

```
,-----------------------------------------------------------------------------------.
|   `  |      |   _  |   +  |   \  |   {  |   }  |      |   7  |   8  |   9  |  /   |
|------+------+------+------+------+------+------+------+------+------+------+------|
|   ~  |      |   _  |   =  |   |  |   [  |   ]  |      |   4  |   5  |   6  |  *   |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |   (  |   )  |      |   1  |   2  |   3  |  -   |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |  0   |   ,  |  .   |  +   |
`-----------------------------------------------------------------------------------'
```

## Raise Layer (Function keys + shifted numbers)
Here are the Function keys, as well as shifted 1-9 in order, and some nav and OS keys

```
,-----------------------------------------------------------------------------------.
|   ~  |   F1 |   F2 |   F3 |   F4 |   F5 |  F6  |  F7  |  F8  |  F9  |  F10 | Home |
|------+------+------+------+------+------+------+------+------+------+------+------|
| Del  |   !  |   @  |  #   |   $  |  %   |  ^   |  &   |  *   |      |      | PgUp |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      | Vol- |  BR- |  BR+ | Vol+ |      |      |      | PgDn |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |      |      |      | End  |
`-----------------------------------------------------------------------------------'
```

## Adjust Layer
Contains reset, debug and the layer on the right which are set in EEPROM across power
transitions

```
,-----------------------------------------------------------------------------------.
|Reset |Debug |      |      |      |      |      |      |      |      |      |Qwerty|
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |      |      |      |Colmk |
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |      |      |      |League|
|------+------+------+------+------+------+------+------+------+------+------+------|
|      |      |      |      |      |      |      |      |      |      |      |      |
`-----------------------------------------------------------------------------------'
```
