# Lae3
_Keymap based around mode-switching for extended functionality_

## Base Layout

    ┌-----------------------------------------------------------------------------------┐
    | Esc  |   Q  |   W  |   E  |   R  |   T  |   Y  |   U  |   I  |   O  |   P  | Bksp |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    | Tab  |   A  |   S  |   D  |   F  |   G  |   H  |   J  |   K  |   L  |   ;  |Enter |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |Shift |   Z  |   X  |   C  |   V  |   B  |   N  |   M  |   ,  |   .  |   /  |Shift |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    | Ctrl | GUI  | Alt  | Move |Lower |    Space    |Raise | Move | Alt  | GUI  | Ctrl |
    └-----------------------------------------------------------------------------------┘

This is more similar to a standard keyboard layout than the standard planck
layout, but I have found that this is better for programming, especially for
editor shortcuts.

## Lower Layer

    ┌-----------------------------------------------------------------------------------┐
    |   `  |   1  |   2  |   3  |   4  |   5  |   -  |   =  |  Del | End  | PgDn |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    | Caps |   6  |   7  |   8  |   9  |   0  |   [  |   ]  |   \  |   '  |      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |  F1  |  F2  |  F3  |  F4  |      |      |  F5  |  F6  |  F7  |  F8  |      |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    |      |      |      |      |      |             |      |      |      |      |      |
    └-----------------------------------------------------------------------------------┘

All the numbers are on one hand so that they can all be easily accessed when
playing games. The punctuation was placed in a way that is as similar as
possible the qwerty punctuation layout on a standard keyboard.

## Raise Layer

    ┌-----------------------------------------------------------------------------------┐
    |   ~  |   !  |   @  |   #  |   $  |   %  |   _  |   +  |  Ins | Home | PgUp |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    | Caps |   ^  |   &  |   *  |   (  |   )  |   {  |   }  |   |  |   "  |      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |  F9  |  F10 |  F11 |  F12 |      |      |      |      |      |      |      |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    |      |      |      |      |      |             |      |      |      |      |      |
    └-----------------------------------------------------------------------------------┘

This layer with the exception of the function and control keys is effectively
the lower layer in combination with the shift key, like on the standard planck
layout.

## Movement Layer

    ┌-----------------------------------------------------------------------------------┐
    |      |MsBut2|Ms Up |MsBut1|MsWhUp|      | Home | PgDn | PgUp |  End |      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |Ms Lft|Ms Dn |Ms Rgt|MsWhDn|      | Left | Down |  Up  | Right|      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |      |      |      |      |      |      |      |      |      |      |      |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    |      |      |      |      |      |             |      |      |      |      |      |
    └-----------------------------------------------------------------------------------┘

Layer for simplifying movement.

## Meta Layer

    ┌-----------------------------------------------------------------------------------┐
    |Reset |      |      |      |      |      |      |      |      |      |      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |Bcklgt| Mute |Vol Dn|Vol Up|      |      |Qwerty|Arrow |Numpad|      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |      |      |      |      |      |      |      |      |      |      |      |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    |      |      |      |      |      |             |      |      |      |      |      |
    └-----------------------------------------------------------------------------------┘

This Layer is activated when pressing both the Lower and Raise keys. The Arrow
and Numpad keys each activate a layer between the base layer and the Movement
layer. The Qwerty key disables both of the layers leaving just the base layer
active.

## Arrow Layer

    ┌-----------------------------------------------------------------------------------┐
    |      |      |      |      |      |      |      |      |      |      |      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |      |      |      |      |      |      |      |      |      |      |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |      |      |      |      |      |      |      |      |      |  Up  |      |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    |      |      |      |      |      |             |      |      | Left | Down | Right|
    └-----------------------------------------------------------------------------------┘

Replaces the bottom right of the keyboard with arrow keys for games like The
Binding of Isaac.

## Numpad Layer

    ┌-----------------------------------------------------------------------------------┐
    |      |      |      |      |      |      |NumLck|   7  |   8  |   9  |   /  |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |      |      |      |      |      |Enter |   4  |   5  |   6  |   *  |      |
    |------+------+------+------+------+------+------+------+------+------+------+------|
    |      |      |      |      |      |      |      |   3  |   2  |   1  |   -  |      |
    |------+------+------+------+------+-------------+------+------+------+------+------|
    |      |      |      |      |      |             |      |   0  |   .  |   +  |      |
    └-----------------------------------------------------------------------------------┘

Replaces the majority of the right side of the keyboard with a numpad because
why not?
