# ZWFP Layout Notes
## About

ZWFP is a layout largely based on Colemak Mod-DH.
The layout rotates the QZXVB keys for the following reasons:
* XCV are brought together.
  * One design goal of colemak was to keep ZXCV close together as they are commonly uses control shortcuts.
  * Mod-dh moved D to where the V key was as that position was too ergonomic for an infrequent letter like V.
  * XCV benefit more from being together are Cut-Copy-Paste are more related than Undo (which Z commonly represents).
* B is returned to its QWERTY position.
  * This was an unintentional benefit.
  * The original rotation of QZXV moved Q to a better position than B despite being was less frequent.
    * This is based off the grid on [the colemak mod-dh page](https://colemakmods.github.io/mod-dh/model.html).
    * This needs more testing, and may be reverted as despite the above mentioned grid, the current Q position feels easier than the current B position.
* Based off [the layout analyser](https://colemakmods.github.io/mod-dh/analyze.html) its slightly better.
* I like being different.

## Todo
* Work out punctuation locations.
* Figure out what the thumb cluster is doing.
  * I've somewhat settled on left home-row (centre) thumb key is space and right is shift OSL.
* Maybe a deadkey instead of using shift-/alt- key overrides?
* [Repeat key](https://www.jonashietala.se/blog/2021/09/05/t-34-0/)
* Move Home, End, PgDn and PgUp to a kc/ko/dk with the arrow keys.

### Keys still to add
* A reset key, cba with finding small pokey things to use at the back.
* Shifted numbers \(not including $^\*\)
* Dedicated Pipe |
* Dedicated Underscore \(\_\)
* Backslash \(\\\) and shifted \(Don't forget to use NOUS\)
* Square brackets \(\[ \]\) and shifted
* Dedicated question mark
* Backtick (`) and shifted
* Function keys 1-12

#### Obscure keys to add just for completeness
* Normal Minus and Equals \(Don't know if they are needed or not \)
* Function keys 13-24
* Capslock \(Not sure if multi-tapping OSL actually counts as a caps lock for shift\)
* Numlock, Scrolllock and the Locking lock keys
* Keypad characters
* Command Keys in general
* International Keys
* Right Modifiers
* Windows keys for either side
