![Personal Planck Rev6](https://github.com/scottzach1/Planck/blob/master/img/img_05.jpg)

# Scottzach1 Planck Layout

Upstream: [scottzach1/planck](https://github.com/scottzach1/Planck)

This keyboard layout implements a personal variation of Colemak Mod-DH with M-K switched.
One notable change with this layout is space + backspace in line with the homing keys.
As such, Lower and Raise have been moved to occupy the middle two keys.

I have been using this layout happily daily now since June 2019. 

``` 
 Colemak Mod-DH
,-----------------------------------------------------------------------------------------------.
| Tab   |   Q   |   W   |   F   |   P   |   B   |   J   |   L   |   U   |   Y   |   ;   |  '    |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
| Func  |   A   |   R   |   S   |   T   |   G   |   M   |   N   |   E   |   I   |   O   | Enter |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
| Shift |   Z   |   X   |   C   |   D   |   V   |   K   |   H   |   ,   |   .   |   /   |  \    |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
| Ctrl  |  GUI  |  Alt  | Shift | Space | Lower | Raise | Bkspc | Shift |   -   |   =   | Ctrl  |
`-----------------------------------------------------------------------------------------------'
```

```
 Lower
,-----------------------------------------------------------------------------------------------.
| Tab   |       |   {   |   }   |       |       |   `   |   7  |   8   |   9   |   0    |       |
|-------+-------+-------+-------+-------+-------+-------+------+-------+-------+--------+-------|
| Func  |       |   (   |   )   |       |       |   *   |   4  |   5   |   6   |   -    | Enter |
|-------+-------+-------+-------+-------+-------+-------+------+-------+-------+--------+-------|
| Shift |       |   [   |   ]   |       |       |   /   |   1  |   2   |   3   |   +    |   =   |
|-------+-------+-------+-------+-------+-------+-------+------+-------+-------+--------+-------|
| Ctrl  |  GUI  | Alt   | Shift | Space | Lower | Func  | Bksp |   0   |   .   |   =    | Ctrl  |
`-----------------------------------------------------------------------------------------------'
```

```
 Raise
,-----------------------------------------------------------------------------------------------.
| Tab   |       |   {   |   }   |       |       |       | Pg_Up |  Up   | Pg_Dn |       |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
| Func  |       |   (   |   )   |       |       | Home  | Left  | Down  | Right |  Del  | Enter |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
| Shift |       |   [   |   ]   |       |       |       |  End  |  Ins  | Caps  |       |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
| Ctrl  |  GUI  | Alt   | Shift | Space | Func  | Raise | Bkspc |       |       |       | Ctrl  |
`-----------------------------------------------------------------------------------------------'
```

```
 Function
,-----------------------------------------------------------------------------------------------.
|  Esc  |       | Prev  | Play  | Next  |       |       |  F7   |  F8   |  F9   | F10   |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
|       |       | Vol-  | Vol+  | Mute  |       |       |  F4   |  F5   |  F6   | F11   |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
|       |       |       |       |       |       |       |  F1   |  F2   |  F3   | F12   |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
|       |       |       |       |       | Funct | Funct |       |       |       |       |       |
`-----------------------------------------------------------------------------------------------'
```

```
 Debug
,-----------------------------------------------------------------------------------------------.
| Reset | Debug |       |       |       |       |       |       |       |       |       |  EEP  |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
|       |       |       |       |       |       |       |       |       |       |       |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
|       |       |       |       |       |       |       |       |       |       |       |       |
|-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------+-------|
|       |       |       |       |       |       |       |       |       |       |       |       |
`-----------------------------------------------------------------------------------------------'
```
