# stuartfong1's Planck Layout

I made this layout to improve ergonomics during daily usage, and to make access to symbols easier when writing code. The main idea is to make all keys easily accessible while reducing the risk of finger strain. 

## Specifications
This was made to work on a Planck rev. 6.1, and is used on macOS.

## Base Layer

![Image of Base Layer](https://i.imgur.com/XO7sgv4.png)

This uses the Colemak DH layout with the wide mod.

- Colemak is an alternative to the QWERTY layout designed for efficient and ergonomic typing in the English language (https://colemak.com). The Colemak DH is a modification of Colemak that makes the D and H keys easier to reach. The wide mod shifts the halves of the keyboard apart, making it easier on the shoulders (https://colemakmods.github.io/mod-dh/).
- Space and backspace are located under the thumbs. Rotate the keys on the bottom row 180° for ease of use.
- I use Auto Shift. This allows me to hold a key to shift it, which prevents me from having to reach for the shift key. The time to activate auto shift can be changed in the config.h file.
- The 4 keys in the center are used for dynamic macros. On each side, hold the top key to start recording, and tap it to stop recording. Tap the middle key to play the macro. 2 macros can be stored at a time; the keys on the left are used for macro #1, and the keys on the right are used for macro #2.
- Modifiers are located at the bottom left and bottom right of the keyboard. They can be accessed by moving the thumbs or with the sides of your hands.

## Numpad Layer

![Image of Numpad Layer](https://i.imgur.com/dPzvYM6.png)

This contains a numpad and some non-alphanumeric characters such as math symbols and quotes.

- The numpad is found under the right hand. It contains numbers and basic math symbols.
- Brackets are typed using the left index finger. These keys. as well as the quotation marks, are macros that type both the beginning and end bracket, and move the cursor inside them.
- The rest of the keys are those that are commonly used while writing code.

## Navigation Layer

![Image of Navigation Layer](https://i.imgur.com/Mr4EQbW.png)

This contains mouse keys, arrow keys, and other keys used for navigation.

- The left side has all the basic functionality of a mouse. The keys on the home row are used to move the mouse, the top ones are used for clicking on something, and the keys on the bottom are used to move the scroll wheel. The speed of the mouse can be adjusted using the right index finger.
- The arrow keys are located on the right hand on the home row. Above these keys are some keys that are located on the navigation cluster.
- Media keys are located on the bottom right, and the volume can be adjusted by using the left index finger.

## Symbol Layer

![Image of Symbol Layer](https://i.imgur.com/1ny1x9H.png)

This contains all the symbols that are not found on the other layers.

- The left side has most of the shifted number keys in increasing order. Some other keys here are for bitwise operators.
- The right side has symbols that are repeated in the numpad layer. Individual brackets are located here in case I accidentally press backspace on one.

## Function Layer

![Image of Function Layer](https://i.imgur.com/Sc3qUs3.png)

This has all the function keys from F1 to F24.

- The function keys are sorted in increasing order.
- F14 and F15 are used to lower and increase the brightness respectively.
- Commands to screenshot / screen record are accessed with the left index finger.

## Additional Layers

- Adjust: Some settings for RGB control, music mode, and to reset the keyboard.

![Image of Adjust Layer](https://i.imgur.com/gjxXXqj.png)

- Plover: Used for stenography (http://www.openstenoproject.org). As I am still learning, I have included some extra keys.

![Image of Plover Layer](https://i.imgur.com/uoSHgIC.png)

