/*
Copyright 2020 Jack Humbert

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#define AUDIO_DAC_WAVETABLE_CUSTOM_LENGTH 64

static const dacsample_t dac_wavetable_custom[64][256] = {
  {
    3038, 4095, 3745, 3945, 3779, 3889, 3782, 3850,
    3775, 3817, 3766, 3788, 3755, 3762, 3743, 3738, 
    3729, 3716, 3715, 3695, 3700, 3676, 3683, 3658,
    3667, 3642, 3649, 3626, 3632, 3611, 3614, 3596,
    3596, 3581, 3579, 3567, 3561, 3552, 3544, 3537,
    3528, 3522, 3511, 3507, 3495, 3491, 3479, 3476,
    3464, 3460, 3449, 3444, 3433, 3428, 3419, 3412,
    3404, 3397, 3389, 3382, 3374, 3366, 3359, 3351,
    3345, 3336, 3330, 3322, 3314, 3307, 3299, 3293,
    3285, 3279, 3270, 3265, 3255, 3251, 3241, 3237,
    3227, 3223, 3213, 3208, 3200, 3194, 3187, 3179,
    3173, 3165, 3161, 3150, 3149, 3136, 3137, 3121,
    3125, 3107, 3112, 3093, 3099, 3080, 3086, 3068,
    3072, 3056, 3058, 3045, 3043, 3036, 3027, 3027,
    3010, 3019, 2992, 3013, 2974, 3007, 2955, 3002,
    2935, 2999, 2913, 2998, 2886, 3006, 2842, 3067,
    2464, 221, 205, 228, 215, 260, 231, 285,
    249, 307, 270, 326, 291, 344, 313, 359,
    335, 374, 357, 388, 378, 403, 399, 416,
    419, 431, 438, 445, 457, 460, 475, 476,
    492, 492, 509, 508, 525, 524, 540, 541,
    555, 558, 571, 574, 586, 591, 601, 607,
    616, 624, 631, 639, 647, 656, 662, 671,
    677, 687, 692, 702, 708, 718, 723, 733,
    738, 748, 753, 763, 768, 777, 783, 792,
    798, 806, 812, 820, 827, 834, 842, 848,
    857, 862, 872, 875, 887, 888, 901, 902,
    915, 915, 929, 929, 943, 942, 956, 956,
    969, 971, 981, 986, 992, 1001, 1003, 1017,
    1013, 1032, 1023, 1048, 1033, 1064, 1043, 1079,
    1054, 1093, 1065, 1106, 1078, 1118, 1092, 1127,
    1109, 1132, 1130, 1132, 1160, 1118, 1217, 1036
  },
  {
    2048, 2049, 2056, 2071, 2096, 2130, 2174, 2225,
    2280, 2337, 2392, 2444, 2490, 2529, 2559, 2581,
    2593, 2597, 2594, 2589, 2585, 2588, 2603, 2635,
    2685, 2755, 2842, 2943, 3050, 3157, 3258, 3347,
    3423, 3485, 3535, 3577, 3612, 3641, 3665, 3682,
    3692, 3694, 3692, 3689, 3690, 3700, 3724, 3761,
    3811, 3867, 3924, 3972, 4005, 4019, 4013, 3993,
    3964, 3936, 3915, 3906, 3912, 3931, 3959, 3990,
    4020, 4043, 4059, 4067, 4068, 4063, 4051, 4030,
    3997, 3946, 3875, 3782, 3671, 3546, 3419, 3299,
    3197, 3120, 3072, 3053, 3062, 3091, 3133, 3180,
    3224, 3257, 3276, 3277, 3259, 3221, 3163, 3084,
    2986, 2870, 2741, 2607, 2474, 2351, 2245, 2161,
    2102, 2069, 2058, 2067, 2091, 2124, 2160, 2195,
    2222, 2239, 2245, 2238, 2219, 2191, 2155, 2116,
    2077, 2042, 2014, 1995, 1987, 1991, 2003, 2023,
    2048, 2074, 2101, 2124, 2144, 2158, 2166, 2170,
    2172, 2175, 2181, 2195, 2221, 2260, 2315, 2384,
    2465, 2555, 2648, 2740, 2826, 2903, 2971, 3029,
    3076, 3114, 3142, 3159, 3167, 3167, 3160, 3153,
    3150, 3157, 3180, 3222, 3283, 3362, 3452, 3546,
    3636, 3715, 3777, 3823, 3854, 3874, 3889, 3905,
    3923, 3944, 3968, 3989, 4007, 4019, 4026, 4030,
    4033, 4040, 4051, 4066, 4081, 4090, 4086, 4063,
    4019, 3956, 3878, 3794, 3716, 3651, 3606, 3586,
    3589, 3612, 3647, 3688, 3728, 3760, 3781, 3787,
    3780, 3757, 3718, 3661, 3584, 3485, 3366, 3230,
    3085, 2938, 2801, 2683, 2589, 2525, 2492, 2486,
    2503, 2537, 2580, 2624, 2663, 2691, 2703, 2698,
    2674, 2633, 2574, 2500, 2415, 2322, 2228, 2139,
    2059, 1994, 1945, 1914, 1900, 1901, 1913, 1933,
    1957, 1983, 2006, 2025, 2038, 2046, 2049, 2048
  },
  {
    2048, 2053, 2074, 2119, 2191, 2291, 2416, 2559,
    2710, 2860, 3000, 3124, 3225, 3301, 3350, 3371,
    3364, 3334, 3288, 3234, 3182, 3144, 3127, 3137,
    3173, 3231, 3304, 3378, 3441, 3483, 3495, 3475,
    3423, 3344, 3243, 3128, 3002, 2867, 2726, 2581,
    2433, 2286, 2142, 2001, 1865, 1731, 1597, 1460,
    1317, 1171, 1023, 881, 750, 637, 546, 476,
    423, 380, 341, 300, 254, 205, 154, 109,
    75, 56, 55, 72, 105, 153, 217, 296,
    395, 513, 651, 806, 972, 1139, 1299, 1444,
    1572, 1680, 1772, 1855, 1935, 2018, 2110, 2212,
    2323, 2442, 2563, 2680, 2786, 2877, 2944, 2982,
    2986, 2951, 2877, 2771, 2640, 2498, 2360, 2238,
    2145, 2087, 2069, 2088, 2140, 2215, 2303, 2392,
    2469, 2524, 2550, 2543, 2505, 2437, 2346, 2241,
    2132, 2031, 1949, 1893, 1870, 1878, 1915, 1974,
    2048, 2128, 2206, 2276, 2332, 2371, 2394, 2402,
    2403, 2404, 2417, 2449, 2510, 2603, 2728, 2882,
    3056, 3236, 3410, 3564, 3690, 3783, 3842, 3868,
    3864, 3833, 3777, 3700, 3604, 3495, 3378, 3261,
    3150, 3048, 2958, 2877, 2801, 2723, 2637, 2536,
    2420, 2289, 2146, 1997, 1847, 1698, 1552, 1410,
    1271, 1133, 999, 870, 748, 637, 536, 446,
    364, 288, 216, 150, 92, 49, 29, 37,
    76, 144, 235, 339, 444, 541, 623, 689,
    741, 784, 826, 874, 933, 1009, 1101, 1209,
    1330, 1461, 1598, 1739, 1877, 2007, 2123, 2219,
    2291, 2338, 2364, 2374, 2378, 2385, 2404, 2443,
    2503, 2585, 2684, 2794, 2904, 3004, 3084, 3136,
    3154, 3133, 3070, 2965, 2823, 2650, 2458, 2261,
    2075, 1914, 1787, 1701, 1656, 1649, 1675, 1726,
    1791, 1861, 1927, 1981, 2020, 2043, 2051, 2050
  },
  {
    2048, 2051, 2065, 2095, 2144, 2212, 2298, 2397,
    2504, 2612, 2716, 2811, 2894, 2961, 3011, 3042,
    3055, 3052, 3036, 3014, 2996, 2988, 3001, 3040,
    3108, 3204, 3324, 3459, 3598, 3728, 3841, 3930,
    3992, 4029, 4045, 4045, 4032, 4009, 3975, 3930,
    3874, 3809, 3738, 3665, 3596, 3534, 3481, 3436,
    3397, 3357, 3312, 3255, 3184, 3099, 3003, 2900,
    2795, 2693, 2595, 2503, 2413, 2325, 2235, 2143,
    2048, 1950, 1850, 1750, 1651, 1554, 1460, 1370,
    1287, 1215, 1159, 1122, 1105, 1107, 1124, 1147,
    1168, 1179, 1172, 1143, 1091, 1019, 931, 836,
    741, 655, 584, 535, 510, 514, 549, 618,
    721, 856, 1019, 1201, 1388, 1569, 1730, 1862,
    1956, 2012, 2029, 2013, 1971, 1911, 1844, 1779,
    1725, 1690, 1676, 1686, 1719, 1771, 1838, 1913,
    1989, 2059, 2115, 2152, 2167, 2161, 2136, 2097,
    2048, 1994, 1942, 1894, 1856, 1829, 1813, 1805,
    1803, 1800, 1788, 1762, 1715, 1643, 1544, 1420,
    1276, 1120, 962, 811, 675, 558, 463, 390,
    337, 304, 290, 294, 316, 353, 399, 447,
    489, 517, 526, 513, 479, 430, 375, 322,
    283, 264, 269, 297, 345, 405, 473, 542,
    612, 682, 754, 829, 910, 996, 1086, 1179,
    1273, 1366, 1459, 1553, 1649, 1747, 1848, 1949,
    2048, 2141, 2227, 2305, 2375, 2440, 2505, 2574,
    2649, 2733, 2825, 2923, 3023, 3122, 3215, 3300,
    3373, 3433, 3476, 3499, 3496, 3465, 3403, 3313,
    3200, 3073, 2945, 2829, 2735, 2672, 2644, 2652,
    2691, 2756, 2836, 2921, 3000, 3062, 3101, 3111,
    3090, 3036, 2950, 2835, 2695, 2539, 2375, 2214,
    2069, 1947, 1855, 1795, 1766, 1765, 1786, 1824,
    1871, 1920, 1965, 2003, 2029, 2044, 2050, 2049
  },
  {
    2048, 2061, 2117, 2228, 2396, 2610, 2844, 3065,
    3240, 3343, 3358, 3283, 3125, 2900, 2629, 2337,
    2048, 1783, 1558, 1379, 1241, 1136, 1049, 971,
    900, 843, 815, 838, 930, 1103, 1358, 1680,
    2048, 2435, 2816, 3170, 3479, 3729, 3908, 4008,
    4025, 3959, 3819, 3616, 3364, 3076, 2757, 2413,
    2048, 1667, 1285, 922, 601, 347, 175, 92,
    93, 168, 304, 490, 722, 998, 1315, 1668,
    2048, 2437, 2818, 3173, 3483, 3736, 3919, 4021,
    4035, 3956, 3788, 3544, 3247, 2924, 2605, 2309,
    2048, 1819, 1614, 1422, 1234, 1050, 878, 733,
    633, 597, 635, 751, 939, 1186, 1471, 1768,
    2048, 2280, 2443, 2523, 2523, 2457, 2354, 2241,
    2146, 2087, 2067, 2081, 2113, 2142, 2149, 2118,
    2048, 1944, 1824, 1711, 1629, 1601, 1637, 1740,
    1896, 2080, 2261, 2404, 2481, 2478, 2394, 2243,
    2048, 1835, 1634, 1468, 1354, 1299, 1300, 1342,
    1408, 1479, 1540, 1586, 1625, 1670, 1744, 1865,
    2048, 2292, 2585, 2903, 3215, 3491, 3707, 3846,
    3899, 3864, 3745, 3550, 3296, 2999, 2682, 2360,
    2048, 1749, 1462, 1186, 917, 661, 432, 250,
    137, 112, 184, 351, 600, 912, 1268, 1651,
    2048, 2444, 2828, 3184, 3496, 3749, 3932, 4040,
    4072, 4031, 3919, 3739, 3493, 3185, 2828, 2441,
    2048, 1675, 1346, 1074, 862, 705, 592, 516,
    476, 475, 524, 632, 806, 1046, 1343, 1684,
    2048, 2412, 2755, 3051, 3279, 3421, 3468, 3421,
    3295, 3116, 2914, 2717, 2543, 2398, 2277, 2166,
    2048, 1909, 1744, 1557, 1361, 1178, 1031, 940,
    919, 975, 1102, 1284, 1497, 1708, 1886, 2004,
    2048, 2018, 1931, 1812, 1689, 1590, 1536, 1534,
    1585, 1676, 1786, 1894, 1981, 2035, 2056, 2053
  },
  {
    2048, 2072, 2162, 2326, 2531, 2717, 2808, 2744,
    2504, 2112, 1636, 1162, 781, 560, 536, 708,
    1040, 1468, 1922, 2340, 2681, 2929, 3082, 3144,
    3108, 2958, 2676, 2261, 1739, 1174, 654, 273,
    103, 179, 496, 1009, 1653, 2344, 2997, 3529,
    3874, 3994, 3882, 3563, 3082, 2497, 1866, 1246,
    698, 284, 64, 82, 347, 829, 1459, 2145,
    2795, 3334, 3712, 3900, 3885, 3668, 3262, 2702,
    2048, 1375, 770, 310, 56, 39, 261, 696,
    1287, 1952, 2594, 3120, 3458, 3578, 3497, 3260,
    2927, 2549, 2159, 1774, 1409, 1084, 836, 709,
    741, 951, 1327, 1819, 2353, 2844, 3211, 3395,
    3374, 3170, 2846, 2488, 2179, 1975, 1891, 1901,
    1956, 2008, 2027, 2015, 1996, 2006, 2073, 2203,
    2370, 2529, 2630, 2636, 2539, 2368, 2176, 2032,
    1989, 2070, 2251, 2471, 2649, 2712, 2622, 2385,
    2048, 1681, 1362, 1153, 1086, 1157, 1334, 1565,
    1803, 2019, 2207, 2378, 2545, 2706, 2837, 2892,
    2819, 2583, 2185, 1674, 1130, 653, 328, 216,
    337, 675, 1182, 1782, 2392, 2928, 3328, 3557,
    3606, 3490, 3229, 2845, 2359, 1803, 1223, 690,
    283, 77, 118, 409, 910, 1551, 2247, 2916,
    3483, 3886, 4077, 4031, 3750, 3266, 2640, 1948,
    1273, 689, 261, 35, 43, 291, 753, 1368,
    2048, 2691, 3210, 3550, 3691, 3645, 3437, 3096,
    2649, 2126, 1569, 1033, 587, 298, 216, 362,
    722, 1248, 1866, 2486, 3015, 3375, 3519, 3446,
    3200, 2855, 2490, 2166, 1911, 1723, 1584, 1478,
    1404, 1379, 1435, 1593, 1858, 2201, 2566, 2885,
    3090, 3140, 3027, 2785, 2480, 2196, 2006, 1951,
    2026, 2183, 2350, 2459, 2469, 2375, 2208, 2022,
    1871, 1793, 1798, 1865, 1955, 2028, 2061, 2057
  },
  {
    2048, 1736, 1511, 1423, 1476, 1630, 1822, 1987,
    2083, 2101, 2063, 2006, 1968, 1967, 2000, 2045,
    2073, 2061, 2011, 1944, 1899, 1908, 1981, 2099,
    2218, 2291, 2292, 2226, 2129, 2054, 2044, 2111,
    2237, 2375, 2471, 2480, 2385, 2198, 1962, 1735,
    1574, 1515, 1563, 1694, 1861, 2022, 2148, 2232,
    2282, 2305, 2299, 2254, 2154, 1996, 1798, 1599,
    1449, 1393, 1464, 1664, 1967, 2319, 2651, 2890,
    2979, 2896, 2660, 2325, 1964, 1648, 1430, 1334,
    1360, 1494, 1707, 1967, 2238, 2480, 2658, 2740,
    2709, 2561, 2310, 1987, 1639, 1327, 1114, 1056,
    1181, 1476, 1889, 2335, 2720, 2967, 3034, 2923,
    2673, 2345, 2010, 1727, 1537, 1455, 1475, 1580,
    1747, 1955, 2184, 2411, 2607, 2733, 2751, 2632,
    2378, 2025, 1643, 1320, 1132, 1123, 1287, 1573,
    1902, 2192, 2386, 2461, 2433, 2339, 2225, 2123,
    2048, 1993, 1946, 1898, 1854, 1834, 1865, 1966,
    2133, 2334, 2512, 2611, 2593, 2463, 2263, 2058,
    1913, 1862, 1902, 1996, 2088, 2130, 2099, 2001,
    1871, 1755, 1694, 1710, 1795, 1918, 2036, 2111,
    2130, 2104, 2062, 2034, 2032, 2044, 2044, 2008,
    1930, 1832, 1756, 1745, 1830, 2008, 2250, 2502,
    2700, 2790, 2741, 2556, 2273, 1955, 1672, 1483,
    1414, 1463, 1600, 1789, 1998, 2202, 2383, 2519,
    2590, 2574, 2460, 2253, 1979, 1682, 1414, 1233,
    1183, 1291, 1551, 1925, 2344, 2723, 2981, 3065,
    2964, 2707, 2356, 1983, 1656, 1424, 1315, 1335,
    1468, 1686, 1950, 2223, 2467, 2652, 2748, 2736,
    2601, 2347, 2004, 1624, 1283, 1058, 1009, 1154,
    1466, 1873, 2285, 2614, 2801, 2826, 2710, 2501,
    2259, 2036, 1862, 1751, 1697, 1692, 1733, 1822,
    1963, 2154, 2374, 2582, 2721, 2742, 2619, 2369
  },
  {
    2048, 2099, 2228, 2259, 1999, 1514, 1195, 1450,
    2280, 3163, 3424, 2780, 1605, 678, 618, 1447,
    2593, 3312, 3203, 2425, 1510, 990, 1120, 1807,
    2685, 3258, 3119, 2226, 1045, 353, 712, 2001,
    3423, 4031, 3396, 1899, 483, 41, 848, 2389,
    3692, 3949, 3033, 1544, 405, 291, 1255, 2722,
    3811, 3831, 2719, 1136, 90, 268, 1555, 3114,
    3964, 3614, 2324, 895, 183, 617, 1954, 3388,
    4020, 3424, 1949, 514, 27, 798, 2345, 3693,
    3997, 3089, 1590, 481, 425, 1338, 2538, 3274,
    3197, 2470, 1563, 978, 1033, 1728, 2698, 3356,
    3224, 2300, 1137, 500, 836, 1934, 3058, 3478,
    2986, 2018, 1282, 1194, 1621, 2108, 2314, 2242,
    2102, 2039, 2030, 2009, 2004, 2101, 2286, 2386,
    2222, 1832, 1496, 1506, 1876, 2312, 2478, 2313,
    2077, 2067, 2276, 2385, 2108, 1542, 1143, 1321,
    2048, 2836, 3127, 2729, 1951, 1338, 1247, 1633,
    2172, 2537, 2581, 2321, 1874, 1441, 1300, 1669,
    2465, 3215, 3317, 2530, 1269, 374, 507, 1646,
    3076, 3872, 3523, 2269, 928, 339, 820, 2008,
    3150, 3579, 3074, 1933, 812, 393, 1006, 2361,
    3636, 3973, 3084, 1503, 242, 106, 1176, 2779,
    3923, 3906, 2735, 1128, 88, 267, 1552, 3134,
    4033, 3701, 2345, 796, 14, 497, 1947, 3438,
    4019, 3364, 1958, 721, 380, 1054, 2279, 3324,
    3589, 2905, 1647, 566, 367, 1237, 2668, 3752,
    3780, 2721, 1257, 332, 511, 1607, 2838, 3413,
    3085, 2234, 1489, 1248, 1506, 2001, 2450, 2652,
    2503, 2030, 1460, 1167, 1432, 2176, 2932, 3161,
    2674, 1808, 1170, 1163, 1680, 2239, 2430, 2258,
    2059, 2108, 2334, 2426, 2195, 1777, 1510, 1606,
    1957, 2266, 2327, 2193, 2057, 2033, 2068, 2069
  },
  {
    2048, 2119, 2229, 2372, 2541, 2724, 2909, 3085,
    3240, 3368, 3466, 3533, 3571, 3581, 3566, 3529,
    3473, 3403, 3326, 3251, 3188, 3144, 3128, 3145,
    3195, 3276, 3382, 3503, 3628, 3747, 3850, 3932,
    3992, 4032, 4055, 4067, 4071, 4069, 4061, 4047,
    4025, 3996, 3965, 3934, 3910, 3898, 3902, 3922,
    3956, 3998, 4040, 4074, 4093, 4093, 4074, 4041,
    4002, 3964, 3935, 3920, 3921, 3936, 3961, 3991,
    4020, 4044, 4062, 4073, 4078, 4078, 4073, 4060,
    4035, 3994, 3932, 3848, 3744, 3626, 3504, 3389,
    3291, 3220, 3180, 3174, 3198, 3247, 3313, 3388,
    3462, 3527, 3577, 3607, 3615, 3598, 3553, 3479,
    3374, 3240, 3081, 2904, 2720, 2541, 2379, 2245,
    2146, 2087, 2069, 2088, 2140, 2218, 2311, 2410,
    2503, 2580, 2633, 2654, 2639, 2585, 2492, 2361,
    2199, 2014, 1817, 1619, 1435, 1273, 1142, 1045,
    984, 959, 967, 1005, 1067, 1148, 1238, 1328,
    1408, 1468, 1498, 1493, 1450, 1369, 1254, 1113,
    956, 796, 643, 508, 397, 311, 251, 214,
    196, 195, 211, 240, 283, 334, 391, 445,
    489, 515, 519, 496, 449, 380, 299, 215,
    137, 74, 31, 7, 0, 3, 10, 16,
    18, 14, 8, 2, 0, 2, 8, 16,
    23, 25, 22, 13, 4, 0, 7, 31,
    76, 139, 215, 296, 371, 432, 472, 486,
    476, 445, 398, 345, 291, 244, 207, 183,
    172, 177, 199, 241, 305, 395, 510, 648,
    800, 958, 1109, 1242, 1347, 1416, 1448, 1443,
    1404, 1338, 1255, 1164, 1077, 1002, 947, 918,
    919, 954, 1024, 1129, 1268, 1436, 1624, 1822,
    2017, 2197, 2351, 2472, 2554, 2597, 2602, 2571,
    2510, 2427, 2331, 2232, 2141, 2070, 2027, 2018
  },
  {
    2048, 2055, 2083, 2142, 2236, 2366, 2526, 2705,
    2891, 3068, 3227, 3358, 3455, 3515, 3537, 3522,
    3473, 3396, 3302, 3199, 3101, 3015, 2946, 2896,
    2859, 2827, 2789, 2734, 2652, 2541, 2399, 2232,
    2048, 1853, 1656, 1461, 1273, 1094, 929, 779,
    649, 541, 454, 384, 327, 277, 229, 182,
    139, 106, 93, 108, 158, 244, 363, 506,
    666, 832, 999, 1165, 1330, 1499, 1674, 1857,
    2048, 2243, 2440, 2635, 2825, 3005, 3173, 3324,
    3453, 3552, 3614, 3635, 3614, 3558, 3476, 3382,
    3291, 3215, 3159, 3125, 3110, 3105, 3100, 3084,
    3048, 2986, 2897, 2783, 2647, 2497, 2341, 2188,
    2048, 1931, 1846, 1799, 1790, 1815, 1863, 1922,
    1978, 2017, 2030, 2012, 1962, 1885, 1789, 1687,
    1592, 1517, 1473, 1467, 1501, 1574, 1678, 1805,
    1940, 2069, 2176, 2249, 2282, 2272, 2224, 2146,
    2048, 1941, 1837, 1745, 1672, 1623, 1598, 1591,
    1596, 1599, 1590, 1558, 1495, 1398, 1269, 1117,
    956, 802, 670, 575, 523, 516, 554, 630,
    738, 873, 1027, 1196, 1372, 1550, 1724, 1890,
    2048, 2198, 2346, 2498, 2659, 2833, 3019, 3210,
    3398, 3573, 3724, 3847, 3939, 4004, 4046, 4069,
    4078, 4071, 4048, 4005, 3939, 3852, 3743, 3618,
    3479, 3331, 3173, 3006, 2830, 2642, 2446, 2245,
    2048, 1860, 1690, 1539, 1406, 1286, 1172, 1057,
    936, 808, 676, 546, 425, 322, 242, 192,
    172, 186, 235, 319, 438, 590, 769, 965,
    1166, 1356, 1526, 1668, 1779, 1864, 1931, 1988,
    2048, 2117, 2202, 2304, 2419, 2541, 2659, 2764,
    2845, 2893, 2899, 2857, 2767, 2633, 2463, 2272,
    2078, 1899, 1750, 1642, 1579, 1563, 1587, 1643,
    1721, 1807, 1890, 1961, 2012, 2041, 2052, 2050
  },
  {
    2048, 2060, 2109, 2207, 2360, 2560, 2787, 3015,
    3217, 3368, 3451, 3458, 3391, 3257, 3067, 2840,
    2593, 2344, 2110, 1900, 1717, 1554, 1404, 1253,
    1093, 924, 753, 596, 475, 410, 418, 507,
    673, 905, 1189, 1509, 1849, 2196, 2537, 2858,
    3146, 3391, 3587, 3732, 3830, 3884, 3899, 3876,
    3811, 3695, 3524, 3294, 3012, 2689, 2345, 1999,
    1666, 1358, 1077, 824, 599, 404, 246, 133,
    75, 80, 151, 285, 478, 721, 1006, 1323,
    1660, 2000, 2324, 2612, 2847, 3019, 3127, 3181,
    3197, 3192, 3179, 3165, 3148, 3119, 3064, 2972,
    2833, 2647, 2419, 2162, 1894, 1634, 1404, 1223,
    1109, 1072, 1113, 1222, 1379, 1556, 1726, 1867,
    1965, 2019, 2035, 2029, 2021, 2027, 2060, 2127,
    2222, 2333, 2441, 2526, 2569, 2558, 2487, 2361,
    2197, 2016, 1849, 1723, 1659, 1666, 1742, 1876,
    2048, 2234, 2412, 2562, 2670, 2729, 2742, 2718,
    2674, 2627, 2591, 2574, 2575, 2583, 2581, 2548,
    2465, 2322, 2116, 1859, 1568, 1267, 977, 719,
    508, 354, 266, 245, 291, 396, 550, 737,
    945, 1165, 1394, 1634, 1891, 2170, 2472, 2790,
    3109, 3408, 3667, 3870, 4007, 4077, 4082, 4030,
    3923, 3765, 3559, 3306, 3013, 2689, 2347, 1998,
    1653, 1320, 1006, 719, 468, 266, 126, 61,
    76, 167, 322, 524, 752, 993, 1237, 1486,
    1741, 2008, 2289, 2582, 2875, 3157, 3411, 3623,
    3780, 3872, 3893, 3841, 3715, 3523, 3282, 3013,
    2740, 2489, 2276, 2107, 1979, 1879, 1791, 1699,
    1592, 1467, 1331, 1196, 1082, 1005, 980, 1015,
    1109, 1256, 1438, 1635, 1821, 1973, 2068, 2097,
    2059, 1967, 1844, 1713, 1601, 1526, 1499, 1525,
    1594, 1694, 1805, 1908, 1988, 2036, 2055, 2053
  },
  {
    2048, 2072, 2095, 2075, 2062, 2149, 2347, 2534,
    2584, 2527, 2537, 2732, 3017, 3166, 3074, 2884,
    2844, 3021, 3223, 3212, 2982, 2782, 2838, 3104,
    3321, 3317, 3206, 3252, 3548, 3896, 4028, 3910,
    3782, 3875, 4095, 4095, 4095, 3855, 3719, 3863,
    4080, 4065, 3759, 3424, 3355, 3556, 3739, 3649,
    3342, 3105, 3136, 3332, 3412, 3231, 2919, 2715,
    2707, 2768, 2724, 2551, 2362, 2259, 2219, 2157,
    2048, 1944, 1881, 1811, 1665, 1473, 1350, 1361,
    1417, 1359, 1150, 949, 947, 1145, 1329, 1300,
    1095, 955, 1044, 1254, 1316, 1103, 782, 627,
    713, 835, 759, 498, 306, 386, 653, 834,
    792, 690, 804, 1192, 1608, 1771, 1678, 1603,
    1778, 2118, 2309, 2159, 1822, 1629, 1734, 1954,
    1990, 1762, 1493, 1456, 1681, 1943, 2022, 1925,
    1847, 1930, 2119, 2249, 2238, 2153, 2095, 2080,
    2048, 1973, 1912, 1915, 1938, 1892, 1763, 1668,
    1723, 1885, 1968, 1842, 1593, 1438, 1481, 1578,
    1487, 1150, 775, 614, 689, 765, 627, 325,
    123, 191, 407, 501, 366, 185, 212, 466,
    698, 671, 436, 273, 366, 584, 630, 389,
    77, 8, 248, 539, 586, 384, 215, 329,
    667, 935, 929, 753, 682, 863, 1169, 1364,
    1361, 1292, 1331, 1505, 1700, 1812, 1863, 1934,
    2048, 2147, 2196, 2244, 2360, 2521, 2615, 2582,
    2519, 2589, 2834, 3096, 3182, 3084, 3009, 3147,
    3446, 3657, 3604, 3387, 3271, 3380, 3552, 3521,
    3228, 2893, 2770, 2865, 2939, 2800, 2540, 2436,
    2621, 2923, 3052, 2930, 2780, 2860, 3153, 3370,
    3268, 2930, 2671, 2689, 2844, 2820, 2484, 2039,
    1804, 1875, 2038, 2026, 1804, 1593, 1602, 1812,
    2013, 2049, 1961, 1906, 1958, 2053, 2091, 2066
  },
  {
    2048, 2070, 2146, 2287, 2483, 2702, 2900, 3027,
    3040, 2918, 2664, 2307, 1895, 1485, 1132, 876,
    736, 714, 794, 950, 1160, 1403, 1672, 1964,
    2279, 2614, 2955, 3279, 3551, 3731, 3784, 3687,
    3434, 3043, 2547, 1997, 1446, 948, 545, 265,
    123, 122, 252, 500, 850, 1280, 1768, 2284,
    2795, 3265, 3654, 3930, 4065, 4046, 3875, 3567,
    3152, 2664, 2143, 1626, 1146, 731, 405, 187,
    94, 136, 319, 637, 1073, 1592, 2150, 2693,
    3169, 3530, 3746, 3807, 3720, 3514, 3223, 2886,
    2537, 2196, 1875, 1578, 1306, 1063, 862, 723,
    671, 729, 908, 1201, 1584, 2009, 2421, 2763,
    2992, 3084, 3043, 2896, 2687, 2466, 2275, 2142,
    2070, 2044, 2037, 2021, 1974, 1892, 1789, 1690,
    1628, 1627, 1697, 1828, 1989, 2140, 2238, 2252,
    2173, 2016, 1819, 1633, 1508, 1484, 1577, 1776,
    2048, 2343, 2610, 2807, 2911, 2919, 2849, 2726,
    2581, 2434, 2291, 2147, 1986, 1794, 1565, 1306,
    1043, 816, 670, 645, 766, 1034, 1430, 1909,
    2417, 2895, 3293, 3576, 3726, 3744, 3643, 3442,
    3162, 2819, 2430, 2008, 1570, 1139, 742, 413,
    189, 97, 158, 374, 732, 1201, 1741, 2303,
    2842, 3316, 3692, 3947, 4067, 4047, 3887, 3596,
    3191, 2697, 2150, 1590, 1066, 621, 297, 117,
    94, 220, 475, 826, 1240, 1683, 2127, 2551,
    2937, 3270, 3535, 3711, 3780, 3723, 3531, 3209,
    2779, 2282, 1770, 1302, 930, 693, 608, 664,
    834, 1076, 1345, 1606, 1836, 2031, 2199, 2355,
    2509, 2665, 2811, 2922, 2971, 2931, 2792, 2562,
    2271, 1966, 1698, 1514, 1444, 1491, 1632, 1826,
    2020, 2164, 2228, 2200, 2097, 1953, 1809, 1705,
    1663, 1689, 1767, 1869, 1964, 2029, 2055, 2053
  },
  {
    2048, 2561, 2882, 1925, 1133, 2097, 3797, 4088,
    2776, 1767, 2291, 3280, 3257, 2487, 2059, 2126,
    2101, 1630, 1064, 1182, 1941, 2104, 1196, 546,
    1140, 2073, 2181, 1769, 1821, 2365, 2600, 2511,
    2925, 3644, 3507, 2704, 2607, 3268, 3505, 3065,
    2629, 2418, 2195, 2003, 2003, 1859, 1066, 110,
    157, 1030, 1220, 450, 80, 694, 1448, 1721,
    1786, 2100, 2633, 2799, 2270, 1758, 2203, 3394,
    4094, 3495, 2357, 2200, 3036, 3279, 2512, 2047,
    2132, 1482, 103, 0, 966, 2027, 1434, 250,
    475, 1883, 2525, 1973, 1589, 1913, 2175, 1995,
    1842, 2221, 3014, 3437, 3043, 2581, 2900, 3549,
    3502, 2694, 2013, 1982, 2001, 1505, 1262, 2009,
    2685, 2173, 1503, 2031, 3013, 2982, 2080, 1531,
    1740, 2035, 2040, 2150, 2357, 2095, 1711, 2170,
    3093, 3197, 2417, 1724, 1547, 1653, 1797, 1905,
    2048, 2242, 2334, 2300, 2332, 2628, 3225, 3649,
    3156, 2071, 1676, 2141, 2380, 2129, 2035, 2014,
    1542, 1048, 1384, 2197, 2109, 877, 120, 825,
    1656, 1357, 856, 1254, 1923, 2056, 2093, 2657,
    3405, 3542, 2994, 2621, 2942, 3334, 3120, 2552,
    2206, 2220, 2250, 1874, 1385, 1543, 1973, 1423,
    198, 29, 1125, 1695, 806, 0, 263, 1560,
    2130, 2050, 2522, 3231, 2971, 2280, 2656, 3851,
    4095, 3374, 2153, 1810, 2357, 2798, 2562, 2088,
    1879, 1846, 1581, 940, 509, 921, 1484, 1011,
    31, 79, 1132, 1898, 1978, 1988, 2205, 2327,
    2334, 2625, 3035, 2727, 1825, 1636, 2371, 2727,
    2323, 2121, 2341, 2265, 1886, 1866, 2171, 1986,
    1120, 626, 1239, 2015, 1854, 1326, 1485, 2132,
    2467, 2287, 2008, 2142, 2522, 2233, 1167, 733,
    1793, 3076, 2860, 1469, 909, 1947, 2928, 2560
  },
  {
    2048, 2504, 2795, 1937, 1211, 2093, 3713, 4049,
    2790, 1746, 2327, 3617, 3862, 2964, 2133, 1958,
    2048, 1906, 1540, 1495, 1969, 2095, 1253, 469,
    957, 2084, 2288, 1309, 413, 609, 1420, 1878,
    2048, 2416, 2641, 2415, 2445, 3116, 3618, 3425,
    3094, 3057, 2976, 2556, 2157, 2260, 2607, 2510,
    2048, 1846, 1730, 1126, 470, 562, 1118, 1256,
    707, 0, 0, 657, 1800, 2252, 1982, 1778,
    2048, 2337, 2178, 2155, 3149, 4095, 3814, 2019,
    1613, 3417, 4095, 4095, 2914, 2060, 2283, 2403,
    2048, 2008, 2319, 1963, 931, 522, 1245, 2190,
    2418, 1813, 1007, 831, 1340, 1749, 1701, 1701,
    2048, 2283, 2008, 1749, 2382, 3485, 3459, 2102,
    1281, 1916, 2557, 2061, 1334, 1451, 2031, 2222,
    2048, 2033, 2105, 1834, 1584, 1987, 2435, 1916,
    981, 920, 1695, 2348, 2505, 2404, 2271, 2175,
    2048, 1874, 1791, 1820, 1787, 1507, 926, 477,
    918, 2022, 2475, 1928, 1548, 1878, 2145, 2009,
    2048, 2386, 2390, 1952, 2002, 3023, 3848, 3333,
    2518, 3030, 4095, 4095, 2947, 2084, 2100, 2270,
    2048, 1702, 1663, 1726, 1412, 921, 893, 1364,
    1762, 1577, 771, 85, 433, 1479, 2005, 1899,
    2048, 2447, 2401, 2251, 3043, 4095, 4095, 3226,
    1627, 2142, 3851, 4095, 3076, 2212, 2305, 2408,
    2048, 1782, 2003, 2215, 1703, 660, 90, 449,
    1182, 1559, 1324, 832, 814, 1398, 1831, 1842,
    2048, 2517, 2569, 2216, 2218, 2717, 3036, 2810,
    2563, 2830, 3111, 2643, 1890, 1817, 2179, 2205,
    2048, 2021, 1715, 1061, 879, 1567, 2270, 1959,
    932, 554, 1292, 2021, 1905, 1587, 1757, 2076,
    2048, 1774, 1737, 2244, 2760, 2283, 1035, 637,
    1788, 3057, 2821, 1509, 1006, 1957, 2836, 2504
  },
  {
    2048, 2448, 2705, 1949, 1297, 2089, 3594, 3952,
    2776, 1740, 2347, 3840, 4095, 3348, 2198, 1801,
    1994, 2206, 2113, 1926, 2015, 2073, 1535, 882,
    1140, 2082, 2300, 1162, 0, 0, 565, 1339,
    1170, 960, 1385, 1871, 1992, 2142, 2460, 2617,
    2629, 2757, 2854, 2594, 2196, 2427, 3507, 4095,
    3938, 2920, 2662, 3067, 3099, 2608, 2195, 2028,
    1786, 1282, 808, 955, 1777, 2367, 1886, 688,
    1, 586, 1725, 1880, 843, 258, 1065, 2058,
    2132, 2013, 2527, 3003, 2625, 2061, 2503, 3589,
    3621, 2244, 1338, 2198, 3558, 3686, 2746, 1947,
    1842, 2145, 2321, 2155, 1950, 1904, 1660, 1024,
    593, 1060, 2140, 2565, 1577, 323, 565, 1997,
    2685, 2145, 1719, 2040, 2341, 2179, 2045, 2244,
    2355, 2087, 1946, 2350, 2626, 2116, 1633, 2182,
    3093, 3120, 2374, 1774, 1637, 1732, 1850, 1936,
    2048, 2199, 2274, 2250, 2281, 2539, 3089, 3542,
    3156, 2073, 1590, 2184, 2670, 2289, 1876, 2152,
    2553, 2428, 2091, 2069, 2066, 1520, 887, 1098,
    1656, 1132, 0, 0, 782, 1984, 1924, 1117,
    690, 1029, 1618, 1893, 1959, 2147, 2351, 2330,
    2206, 2379, 3157, 4095, 4095, 3062, 2159, 2793,
    3897, 3778, 2732, 2273, 2711, 2971, 2487, 2018,
    2130, 2013, 1044, 328, 923, 1791, 1414, 226,
    0, 708, 1938, 2310, 1670, 958, 958, 1461,
    1879, 2035, 2162, 2506, 2870, 2767, 2466, 2936,
    4064, 4095, 3409, 2348, 2278, 2767, 2907, 2584,
    2334, 2371, 2327, 2100, 2069, 2158, 1901, 1584,
    1772, 1935, 1261, 335, 403, 1472, 2281, 1965,
    1120, 944, 1561, 2033, 1989, 1946, 2085, 2015,
    1628, 1297, 1503, 2326, 2936, 2317, 964, 610,
    1793, 3007, 2766, 1557, 1113, 1967, 2741, 2447
  },
  {
    2048, 2391, 2614, 1962, 1390, 2084, 3441, 3798,
    2733, 1749, 2349, 3933, 4095, 3601, 2245, 1678,
    1949, 2480, 2673, 2383, 2069, 2045, 1963, 1657,
    1630, 2067, 2213, 1389, 126, 0, 478, 1190,
    807, 179, 564, 1450, 1580, 1095, 969, 1325,
    1647, 1798, 1949, 2078, 2078, 2176, 2736, 3459,
    3495, 2877, 2778, 3608, 4095, 3832, 3049, 2830,
    3286, 3873, 3912, 3170, 2242, 1891, 2097, 2250,
    2048, 1830, 1948, 1965, 1182, 208, 570, 2072,
    2449, 693, 0, 0, 845, 2027, 1506, 582,
    844, 1928, 2383, 1996, 1740, 1958, 2133, 2012,
    1906, 2171, 2762, 3132, 2879, 2533, 2914, 3805,
    4095, 3243, 1950, 1562, 2441, 3329, 3017, 2076,
    1754, 2015, 2102, 2047, 2244, 2409, 2068, 1514,
    1479, 1988, 2180, 1686, 1404, 1975, 2465, 1917,
    1062, 1061, 1753, 2291, 2407, 2322, 2217, 2143,
    2048, 1917, 1853, 1872, 1843, 1611, 1109, 674,
    1004, 2023, 2508, 1904, 1355, 1759, 2273, 1890,
    1114, 1014, 1626, 2105, 2060, 1990, 2239, 2366,
    2228, 2562, 3518, 3922, 3105, 2107, 2178, 3174,
    3968, 3797, 3010, 2570, 2795, 3051, 2841, 2406,
    2157, 2164, 2183, 1932, 1602, 1703, 1995, 1593,
    632, 402, 1233, 1703, 667, 0, 0, 882,
    2436, 1965, 539, 279, 1239, 1921, 1852, 1776,
    2048, 2247, 2081, 1919, 2319, 3168, 3686, 3445,
    2847, 2530, 2827, 3508, 3758, 3148, 2545, 2893,
    3591, 3482, 2690, 2150, 2095, 2087, 1943, 1859,
    1850, 1637, 1317, 1517, 2233, 2422, 1719, 1252,
    1659, 1911, 1215, 442, 674, 1620, 2200, 2001,
    1621, 1677, 1967, 2049, 2087, 2327, 2405, 1960,
    1272, 921, 1332, 2380, 3036, 2331, 957, 652,
    1807, 2930, 2695, 1612, 1229, 1978, 2645, 2391
  },
  {
    2048, 2334, 2522, 1976, 1490, 2079, 3258, 3593,
    2665, 1773, 2333, 3889, 4095, 3697, 2269, 1604,
    1919, 2679, 3113, 2768, 2118, 2017, 2415, 2552,
    2260, 2045, 2060, 1896, 1377, 998, 1204, 1514,
    1170, 558, 718, 1443, 1509, 781, 350, 647,
    1021, 1071, 1139, 1531, 1928, 1784, 1177, 880,
    1264, 1772, 1926, 2007, 2266, 2439, 2386, 2410,
    2792, 3438, 3834, 3414, 2357, 1705, 2214, 3417,
    4094, 3520, 2379, 2228, 3421, 4095, 3464, 2029,
    1806, 2675, 3147, 2715, 2168, 2047, 1957, 1561,
    1396, 1948, 2471, 1943, 827, 498, 1262, 2186,
    2411, 1809, 922, 606, 1091, 1557, 1271, 647,
    593, 1304, 2100, 2265, 1910, 1752, 1973, 2052,
    1898, 2005, 2283, 2056, 1407, 1270, 2012, 2828,
    2791, 2119, 1898, 2432, 2701, 2118, 1653, 2168,
    2934, 2918, 2303, 1839, 1742, 1817, 1905, 1968,
    2048, 2156, 2211, 2195, 2221, 2422, 2863, 3260,
    2987, 2070, 1612, 2188, 2750, 2353, 1795, 2236,
    3268, 3558, 2766, 1923, 2007, 2675, 2881, 2459,
    2139, 2121, 1934, 1615, 1678, 2021, 1977, 1347,
    690, 653, 1185, 1519, 1188, 713, 799, 1352,
    1768, 1592, 799, 53, 282, 1342, 1981, 1671,
    1281, 1501, 1912, 2039, 2186, 2693, 3057, 2588,
    1814, 2110, 3494, 4095, 3331, 2323, 2700, 3882,
    4095, 3396, 2161, 1766, 2478, 3411, 3618, 3112,
    2529, 2271, 2311, 2368, 2218, 2019, 1965, 1767,
    1212, 861, 1236, 1839, 1861, 1367, 1080, 1309,
    1542, 1252, 897, 1342, 2261, 2426, 1753, 1413,
    1772, 1963, 1600, 1328, 1568, 1949, 2059, 2054,
    2265, 2525, 2397, 2065, 2176, 2648, 2657, 1920,
    1034, 696, 1245, 2400, 3050, 2324, 1016, 763,
    1831, 2827, 2610, 1674, 1353, 1989, 2548, 2334
  },
  {
    2048, 2277, 2428, 1990, 1595, 2073, 3049, 3342,
    2572, 1810, 2299, 3712, 4095, 3626, 2267, 1589,
    1909, 2769, 3349, 2999, 2150, 1997, 2763, 3291,
    2819, 2024, 1903, 2466, 2932, 2799, 2368, 2132,
    2048, 1862, 1745, 1856, 1832, 1442, 1103, 1156,
    1308, 1252, 1212, 1508, 1905, 1682, 615, 0,
    1, 1020, 1235, 461, 0, 472, 1211, 1424,
    1100, 697, 708, 1259, 1913, 2154, 2014, 1912,
    2048, 2193, 2114, 2104, 2644, 3339, 3110, 2029,
    1740, 3127, 4095, 4095, 3180, 2068, 2650, 3863,
    3750, 2248, 1351, 2193, 3506, 3666, 2770, 1935,
    1786, 2199, 2674, 2737, 2430, 2203, 2224, 2222,
    2048, 1929, 2068, 2203, 1867, 1232, 1199, 2013,
    2590, 2151, 1589, 2033, 2980, 3075, 2091, 1155,
    1243, 1973, 2195, 1680, 1441, 1984, 2396, 1944,
    1293, 1318, 1836, 2218, 2295, 2234, 2162, 2111,
    2048, 1960, 1917, 1928, 1907, 1741, 1373, 1032,
    1249, 2028, 2432, 1921, 1395, 1755, 2298, 1853,
    727, 320, 1170, 2212, 2107, 1013, 427, 1035,
    1715, 1412, 760, 855, 1561, 2029, 2021, 1936,
    2048, 2221, 2244, 2215, 2391, 2686, 2742, 2490,
    2249, 2419, 3196, 4095, 4095, 3026, 2157, 2808,
    4050, 4086, 2953, 2398, 3348, 4095, 4095, 2977,
    1750, 2109, 3132, 3289, 2604, 2133, 2179, 2229,
    2048, 1914, 2025, 2135, 1861, 1261, 870, 1014,
    1435, 1663, 1397, 758, 436, 929, 1494, 1001,
    0, 0, 711, 1758, 1825, 1337, 1158, 1447,
    1683, 1541, 1408, 1710, 2133, 2168, 1981, 1969,
    2048, 2061, 2217, 2563, 2680, 2320, 1914, 2105,
    2836, 3225, 2727, 2076, 2234, 2841, 2792, 1901,
    951, 652, 1252, 2385, 2978, 2298, 1136, 936,
    1864, 2700, 2513, 1742, 1484, 2000, 2449, 2277
  },
  {
    2048, 2220, 2334, 2004, 1704, 2067, 2818, 3053,
    2460, 1858, 2251, 3414, 4031, 3396, 2240, 1636,
    1919, 2736, 3335, 3028, 2158, 1991, 2907, 3645,
    3117, 2011, 1802, 2860, 4086, 4095, 3365, 2704,
    2925, 3282, 2971, 2401, 2313, 2568, 2620, 2422,
    2252, 2173, 2097, 2033, 2032, 1982, 1693, 1304,
    1264, 1583, 1622, 1093, 632, 815, 1302, 1412,
    933, 196, 0, 488, 1712, 2406, 1877, 671,
    1, 568, 1709, 1859, 557, 0, 319, 2073,
    2409, 947, 0, 0, 1270, 2035, 1732, 1227,
    1396, 1984, 2220, 2022, 1893, 2003, 2090, 2030,
    1975, 2111, 2427, 2640, 2519, 2335, 2587, 3208,
    3502, 2962, 1965, 1594, 2464, 3628, 3486, 2101,
    1295, 1914, 2598, 2064, 1043, 989, 2005, 2899,
    2791, 2114, 1918, 2362, 2555, 2100, 1766, 2130,
    2640, 2614, 2210, 1917, 1860, 1907, 1962, 2000,
    2048, 2113, 2146, 2137, 2154, 2281, 2567, 2837,
    2675, 2063, 1737, 2152, 2593, 2298, 1828, 2222,
    3268, 3696, 2916, 1879, 1984, 3221, 3994, 3348,
    2509, 3013, 4095, 4095, 3169, 2103, 2157, 2910,
    3405, 3203, 2647, 2357, 2471, 2597, 2469, 2233,
    2103, 2106, 2115, 1990, 1824, 1873, 2020, 1808,
    1281, 1126, 1573, 1837, 1154, 17, 0, 1100,
    2397, 1964, 283, 0, 655, 1759, 1382, 204,
    0, 692, 1932, 2342, 1581, 491, 132, 630,
    1328, 1655, 1467, 1039, 941, 1374, 1757, 1575,
    1212, 1292, 1716, 1996, 2024, 2028, 2100, 2143,
    2148, 2260, 2435, 2338, 1942, 1826, 2252, 2573,
    2323, 2152, 2746, 3548, 3505, 2575, 1821, 2134,
    3142, 3559, 2864, 2080, 2248, 2864, 2784, 1908,
    1034, 795, 1352, 2336, 2826, 2253, 1312, 1163,
    1903, 2555, 2406, 1814, 1620, 2012, 2350, 2220
  },
  {
    2048, 2162, 2239, 2018, 1817, 2061, 2571, 2735,
    2332, 1916, 2190, 3018, 3473, 3030, 2190, 1738,
    1949, 2585, 3073, 2846, 2140, 1999, 2806, 3502,
    3055, 2012, 1798, 2909, 4095, 4095, 3680, 2913,
    3288, 3935, 3590, 2702, 2599, 3294, 3674, 3370,
    3014, 2978, 2933, 2572, 2176, 2355, 3177, 3803,
    3495, 2741, 2573, 3035, 3287, 2966, 2522, 2392,
    2561, 2764, 2748, 2454, 2116, 1994, 2064, 2115,
    2048, 1975, 2014, 2019, 1744, 1382, 1493, 2057,
    2214, 1451, 509, 482, 1366, 2035, 1658, 822,
    844, 1898, 2597, 1926, 735, 474, 1281, 2179,
    2390, 1822, 969, 628, 1067, 1516, 1146, 273,
    0, 841, 2149, 2578, 1584, 370, 585, 1996,
    2756, 2169, 1562, 2033, 2887, 2910, 2081, 1383,
    1479, 1997, 2143, 1819, 1683, 2010, 2245, 1990,
    1639, 1660, 1937, 2135, 2174, 2142, 2105, 2080,
    2048, 2004, 1982, 1987, 1976, 1890, 1695, 1508,
    1615, 2037, 2265, 1974, 1655, 1865, 2210, 1916,
    1114, 762, 1356, 2185, 2101, 1041, 329, 863,
    1613, 1105, 0, 0, 800, 1983, 1912, 910,
    127, 281, 1047, 1476, 1166, 733, 851, 1391,
    1784, 1613, 829, 23, 149, 1226, 1961, 1482,
    632, 672, 1462, 1829, 1265, 533, 635, 1534,
    2209, 2015, 1481, 1408, 1764, 2004, 1982, 1957,
    2048, 2114, 2059, 2003, 2143, 2453, 2663, 2596,
    2379, 2260, 2417, 2799, 3016, 2744, 2406, 2754,
    3591, 3831, 3101, 2291, 2248, 2738, 2991, 2750,
    2524, 2799, 3150, 2742, 1829, 1638, 2389, 2851,
    2436, 2185, 2913, 3805, 3668, 2608, 1817, 2132,
    3078, 3425, 2768, 2075, 2215, 2713, 2634, 1939,
    1272, 1106, 1533, 2258, 2607, 2193, 1531, 1433,
    1948, 2394, 2291, 1890, 1760, 2024, 2249, 2162
  },
  {
    2048, 2105, 2143, 2033, 1932, 2054, 2312, 2396,
    2192, 1980, 2121, 2551, 2793, 2565, 2123, 1882,
    1994, 2341, 2615, 2495, 2100, 2020, 2490, 2908,
    2654, 2026, 1892, 2594, 3514, 3739, 3149, 2645,
    2925, 3416, 3196, 2548, 2482, 3061, 3413, 3196,
    2917, 2917, 2909, 2579, 2184, 2389, 3368, 4095,
    3938, 3011, 2828, 3622, 4095, 3770, 3023, 2835,
    3362, 4095, 4095, 3707, 2396, 1681, 2219, 3427,
    4094, 3530, 2389, 2240, 3598, 4095, 3939, 2019,
    1621, 3410, 4095, 4095, 3221, 2068, 2626, 3750,
    3621, 2232, 1405, 2183, 3439, 3644, 2793, 1924,
    1740, 2243, 2953, 3201, 2820, 2454, 2719, 3335,
    3502, 2881, 1979, 1697, 2347, 3111, 2958, 2079,
    1621, 1976, 2331, 2056, 1572, 1565, 2029, 2411,
    2355, 2074, 1997, 2168, 2238, 2067, 1946, 2077,
    2256, 2244, 2103, 2003, 1984, 2000, 2019, 2032,
    2048, 2069, 2080, 2078, 2084, 2127, 2226, 2321,
    2268, 2053, 1935, 2086, 2252, 2144, 1961, 2118,
    2553, 2751, 2430, 1970, 2017, 2626, 3049, 2749,
    2309, 2624, 3428, 3604, 2854, 2090, 2139, 2833,
    3405, 3329, 2793, 2485, 2742, 3116, 3052, 2617,
    2285, 2453, 3232, 4095, 4062, 2961, 2148, 2746,
    3897, 3959, 2917, 2395, 3395, 4095, 4095, 3220,
    1635, 2142, 3978, 4095, 3496, 2342, 2719, 3896,
    4095, 3406, 2164, 1747, 2533, 3703, 4095, 3653,
    2897, 2533, 2807, 3457, 3716, 3158, 2579, 3029,
    4064, 4095, 3279, 2318, 2260, 2748, 2965, 2704,
    2476, 2700, 2973, 2612, 1875, 1734, 2302, 2630,
    2323, 2143, 2632, 3208, 3096, 2403, 1904, 2099,
    2667, 2862, 2468, 2063, 2143, 2420, 2372, 1988,
    1628, 1543, 1774, 2158, 2340, 2123, 1781, 1732,
    1997, 2223, 2170, 1968, 1903, 2036, 2149, 2105
  },
  {
    2048, 2081, 2108, 2062, 2033, 2108, 2213, 2231,
    2171, 2169, 2313, 2495, 2523, 2399, 2282, 2198,
    2086, 2082, 2304, 2509, 2430, 2273, 2364, 2557,
    2495, 2238, 2211, 2647, 3262, 3494, 3182, 2884,
    3081, 3340, 3015, 2465, 2546, 3166, 3465, 3191,
    2875, 2836, 2831, 2605, 2347, 2539, 3295, 3937,
    3765, 3197, 3214, 3747, 3836, 3319, 3028, 3351,
    3799, 3942, 3782, 3381, 2828, 2390, 2345, 2780,
    3431, 3666, 3188, 2747, 3186, 3917, 3676, 2669,
    2404, 3379, 4095, 4095, 3542, 2912, 2971, 3195,
    2856, 2177, 2097, 2766, 3226, 2929, 2452, 2338,
    2369, 2329, 2435, 2739, 2953, 2972, 2976, 3055,
    3070, 2820, 2318, 1989, 2255, 2794, 2819, 2258,
    1859, 1983, 2135, 1924, 1650, 1723, 2062, 2302,
    2263, 2109, 2092, 2194, 2176, 2011, 1965, 2133,
    2271, 2208, 2073, 2013, 2010, 2007, 2008, 2025,
    2048, 2062, 2073, 2093, 2113, 2126, 2178, 2283,
    2302, 2132, 1953, 2000, 2163, 2178, 2096, 2181,
    2443, 2593, 2437, 2158, 2152, 2515, 2813, 2693,
    2533, 2857, 3355, 3288, 2694, 2318, 2490, 2851,
    3034, 3022, 2962, 2951, 2919, 2748, 2575, 2643,
    2816, 2840, 2969, 3484, 3859, 3453, 2747, 2699,
    3236, 3489, 3234, 3128, 3642, 4095, 4095, 3247,
    2351, 2675, 3676, 3893, 3199, 2870, 3422, 3924,
    3615, 2867, 2387, 2435, 2850, 3295, 3533, 3569,
    3399, 2991, 2695, 2959, 3443, 3394, 2993, 3131,
    3787, 3963, 3300, 2558, 2412, 2676, 2811, 2651,
    2532, 2756, 2984, 2622, 1895, 1703, 2209, 2582,
    2419, 2303, 2653, 3027, 2911, 2454, 2158, 2257,
    2522, 2573, 2384, 2295, 2416, 2406, 2088, 1777,
    1737, 1830, 1894, 1984, 2097, 2096, 1974, 1898,
    1956, 2060, 2088, 2032, 2001, 2056, 2110, 2082
  },
  {
    2048, 1781, 1533, 1328, 1188, 1124, 1143, 1240,
    1403, 1614, 1851, 2091, 2309, 2484, 2597, 2633,
    2583, 2447, 2234, 1964, 1663, 1365, 1105, 912,
    811, 812, 918, 1116, 1384, 1696, 2022, 2334,
    2610, 2832, 2990, 3078, 3096, 3046, 2937, 2779,
    2588, 2381, 2175, 1988, 1831, 1709, 1621, 1557,
    1503, 1443, 1361, 1248, 1094, 899, 665, 395,
    95, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 166, 384, 583, 766,
    938, 1107, 1283, 1476, 1697, 1953, 2250, 2587,
    2956, 3344, 3735, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 3719, 3312, 2947, 2640, 2399, 2226, 2113,
    2048, 2012, 1986, 1950, 1884, 1773, 1608, 1389,
    1126, 836, 546, 284, 83, 0, 0, 59,
    274, 587, 976, 1413, 1868, 2312, 2719, 3070,
    3346, 3538, 3638, 3645, 3564, 3409, 3198, 2956,
    2709, 2483, 2299, 2168, 2094, 2069, 2080, 2107,
    2131, 2132, 2096, 2015, 1884, 1704, 1477, 1212,
    917, 605, 291, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    195, 562, 935, 1298, 1639, 1951, 2228, 2469,
    2677, 2855, 3015, 3168, 3329, 3511, 3729, 3991,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 3769, 3464, 3233, 3077, 2987, 2951,
    2950, 2961, 2963, 2934, 2858, 2727, 2540, 2308
  },
  {
    2048, 1952, 1949, 1768, 1386, 1123, 1378, 2211,
    3175, 3594, 3098, 1985, 1073, 1108, 2177, 3602,
    4095, 4052, 2791, 1493, 964, 1374, 2192, 2654,
    2372, 1590, 934, 876, 1388, 2030, 2357, 2278,
    2048, 1963, 2047, 2045, 1726, 1193, 892, 1244,
    2221, 3244, 3550, 2777, 1292, 0, 0, 118,
    983, 1287, 636, 0, 0, 0, 0, 779,
    1546, 1488, 916, 452, 518, 1050, 1650, 1981,
    2048, 2115, 2382, 2741, 2875, 2608, 2181, 2155,
    2966, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 3621, 2562, 2500, 3327,
    4095, 4095, 4095, 3627, 2872, 2516, 2453, 2357,
    2048, 1668, 1511, 1672, 1890, 1743, 1060, 167,
    0, 121, 1263, 2408, 2778, 2135, 981, 181,
    286, 1100, 1823, 1683, 543, 0, 0, 0,
    0, 565, 1406, 1588, 1422, 1356, 1574, 1898,
    2048, 1971, 1925, 2214, 2846, 3444, 3531, 2971,
    2159, 1763, 2181, 3173, 3984, 3916, 2897, 1582,
    883, 1282, 2447, 3481, 3584, 2644, 1282, 365,
    373, 1108, 1940, 2337, 2229, 1947, 1840, 1956,
    2048, 1886, 1553, 1420, 1810, 2663, 3513, 3854,
    3587, 3151, 3191, 3999, 4095, 4095, 4095, 4095,
    3032, 2330, 2796, 4021, 4095, 4095, 4095, 3178,
    2396, 2381, 2873, 3295, 3253, 2807, 2325, 2091,
    2048, 1899, 1453, 865, 538, 744, 1328, 1772,
    1624, 918, 212, 166, 965, 2085, 2614, 1931,
    204, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 808, 1588, 1863, 1805, 1795,
    2048, 2419, 2597, 2452, 2221, 2322, 2954, 3842,
    4095, 4095, 3540, 2958, 3201, 4095, 4095, 4095,
    4095, 4095, 3278, 2418, 2608, 3384, 3934, 3743,
    2950, 2165, 1934, 2315, 2887, 3143, 2906, 2416
  },
  {
    2048, 2249, 2630, 3002, 3260, 3501, 3941, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4049, 4012, 4008, 3770, 3277, 2720, 2299,
    2048, 1828, 1484, 998, 506, 139, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 970, 2325, 2665, 2012, 1093,
    817, 1633, 3210, 4095, 4095, 4095, 3150, 1878,
    1285, 1384, 1706, 1717, 1236, 549, 159, 400,
    1194, 2129, 2764, 2912, 2708, 2426, 2253, 2169,
    2048, 1826, 1593, 1502, 1589, 1683, 1506, 908,
    47, 0, 0, 0, 0, 102, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 276, 753, 1285, 1720,
    2048, 2395, 2870, 3414, 3810, 3864, 3601, 3308,
    3340, 3843, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 3704, 3989, 4095,
    4095, 4095, 4095, 4051, 2637, 2334, 3235, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 3282, 2286, 2136, 2589, 3105, 3255,
    2981, 2548, 2276, 2280, 2418, 2463, 2320, 2109
  },
  {
    2048, 1981, 2022, 2010, 1837, 1586, 1497, 1768,
    2349, 2925, 3133, 2858, 2376, 2189, 2660, 3701,
    4095, 4095, 4095, 3995, 3304, 3429, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 3832, 3750, 3782, 3652, 3274, 2774, 2342,
    2048, 1790, 1424, 922, 427, 127, 60, 23,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 24, 0, 0, 0,
    0, 0, 22, 745, 854, 467, 36, 0,
    431, 1118, 1677, 1894, 1833, 1725, 1753, 1908,
    2048, 2060, 1990, 1997, 2183, 2459, 2576, 2336,
    1788, 1254, 1108, 1472, 2077, 2413, 2102, 1214,
    260, 0, 244, 1107, 1727, 1510, 430, 0,
    0, 0, 0, 788, 1040, 227, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 40, 66, 241, 660, 1203, 1688,
    2048, 2376, 2811, 3365, 3880, 4095, 4095, 4066,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 3805, 3597, 3930, 4095, 4095,
    4026, 3378, 2835, 2600, 2608, 2634, 2512, 2264
  },
  {
    2048, 1979, 2009, 1964, 1767, 1541, 1505, 1758,
    2132, 2275, 1927, 1182, 498, 415, 1153, 2399,
    3472, 3777, 3230, 2333, 1819, 2110, 2990, 3747,
    3706, 2764, 1532, 945, 1611, 3353, 4095, 4095,
    4095, 4095, 3789, 3389, 3945, 4095, 4095, 4095,
    3758, 2753, 2668, 3694, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4055, 3294,
    2817, 2815, 3125, 3395, 3363, 3026, 2587, 2249,
    2048, 1864, 1579, 1221, 950, 892, 965, 883,
    359, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 25, 0, 0, 0,
    0, 0, 272, 531, 159, 0, 0, 0,
    112, 1003, 1620, 1819, 1749, 1675, 1747, 1917,
    2048, 2087, 2137, 2350, 2744, 3124, 3204, 2846,
    2219, 1720, 1692, 2143, 2708, 2905, 2525, 1832,
    1408, 1721, 2721, 3800, 4095, 3433, 1879, 361,
    0, 227, 1372, 2263, 2247, 1378, 370, 51,
    733, 1941, 2725, 2320, 702, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    265, 688, 265, 0, 0, 0, 0, 0,
    349, 696, 720, 703, 872, 1233, 1620, 1885,
    2048, 2262, 2651, 3160, 3571, 3694, 3553, 3408,
    3559, 4089, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 3630, 3510, 3867, 4095, 4095,
    3651, 3107, 2795, 2789, 2907, 2897, 2658, 2307
  },
  {
    2048, 1872, 1766, 1689, 1616, 1562, 1560, 1621,
    1701, 1715, 1605, 1390, 1179, 1103, 1224, 1486,
    1746, 1869, 1832, 1740, 1752, 1968, 2344, 2724,
    2953, 2991, 2957, 3045, 3380, 3923, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4063,
    3723, 3511, 3391, 3280, 3110, 2869, 2590, 2314,
    2048, 1762, 1431, 1059, 683, 332, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    50, 538, 940, 1218, 1401, 1552, 1714, 1886,
    2048, 2191, 2340, 2527, 2752, 2966, 3097, 3104,
    3013, 2909, 2869, 2903, 2942, 2891, 2712, 2471,
    2305, 2325, 2529, 2785, 2913, 2805, 2509, 2198,
    2051, 2125, 2315, 2419, 2288, 1922, 1470, 1113,
    925, 814, 584, 80, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 138, 382, 682, 1035, 1400, 1738,
    2048, 2359, 2699, 3058, 3393, 3664, 3881, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4019, 3703, 3441, 3199, 2929, 2620, 2307
  },
  {
    2048, 2324, 2624, 2954, 3284, 3568, 3796, 4005,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 3881, 3732,
    3693, 3578, 3283, 2863, 2500, 2370, 2510, 2788,
    2985, 2945, 2673, 2325, 2089, 2063, 2189, 2312,
    2292, 2097, 1816, 1580, 1463, 1441, 1421, 1321,
    1138, 950, 855, 909, 1092, 1337, 1585, 1816,
    2048, 2293, 2541, 2762, 2946, 3128, 3378, 3746,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4031, 3757, 3452, 3099, 2725, 2371,
    2048, 1733, 1398, 1043, 710, 449, 268, 119,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 62, 277, 623, 1009, 1254, 1223, 941,
    599, 434, 584, 993, 1456, 1759, 1818, 1730,
    1683, 1824, 2153, 2532, 2794, 2860, 2799, 2761,
    2873, 3137, 3439, 3623, 3604, 3411, 3161, 2970,
    2880, 2853, 2815, 2720, 2581, 2438, 2318, 2203,
    2048, 1821, 1537, 1244, 981, 748, 506, 225,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 108, 359, 569, 812, 1113, 1444, 1762
  },
  {
    2048, 2136, 2184, 2258, 2362, 2450, 2495, 2543,
    2698, 3031, 3494, 3907, 4050, 3808, 3252, 2597,
    2059, 1711, 1452, 1102, 565, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 427,
    900, 1324, 1741, 2214, 2763, 3334, 3848, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 3382, 2375, 1392, 392,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 195, 503, 850, 1247, 1656,
    2048, 2448, 2907, 3435, 3967, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 3718, 2480, 1360,
    481, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 806, 1558, 2292, 3019, 3707, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4046, 3131, 2308, 1533, 749,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 74, 551, 1028, 1482, 1838
  },
  {
    2048, 1652, 1202, 705, 224, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1214, 2449, 3595, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 3911, 3359, 2788, 2223, 1730, 1342,
    1019, 683, 285, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 236, 1269, 2189, 2856, 3287,
    3595, 3868, 4095, 4095, 4063, 3715, 3216, 2650,
    2048, 1375, 591, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 386, 1403, 2358, 3256, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 3807, 3002, 2267, 1658, 1199,
    849, 542, 257, 54, 38, 267, 673, 1087,
    1334, 1350, 1222, 1104, 1090, 1126, 1049, 726,
    188, 0, 0, 0, 282, 1093, 1794, 2245,
    2504, 2743, 3095, 3544, 3939, 4095, 4046, 3813,
    3592, 3498, 3518, 3536, 3436, 3179, 2817, 2428
  },
  {
    2048, 824, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 661, 1505, 2315, 3100, 3819, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 3826, 3648,
    3469, 3194, 2815, 2426, 2146, 2043, 2107, 2294,
    2591, 3033, 3661, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 3630, 2887,
    2048, 1109, 133, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 354, 1368, 2393, 3450, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 3514,
    3057, 2966, 3065, 3137, 3087, 2988, 3006, 3240,
    3624, 3948, 4002, 3708, 3173, 2605, 2182, 1954,
    1859, 1803, 1751, 1735, 1808, 1977, 2194, 2399,
    2590, 2832, 3206, 3724, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 3196
  },
  {
    2048, 1477, 923, 367, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 940, 1648, 2184, 2491, 2611,
    2612, 2516, 2290, 1898, 1357, 736, 105, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 774, 1727, 2702, 3715,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4050, 2990,
    2048, 1224, 481, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 174, 807,
    1142, 1166, 1034, 944, 978, 1044, 964, 629,
    117, 0, 0, 0, 571, 1314, 1898, 2238,
    2420, 2586, 2817, 3071, 3233, 3221, 3048, 2808,
    2590, 2413, 2220, 1944, 1572, 1160, 775, 428,
    63, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 442, 1643, 2875, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 4095, 4095,
    4095, 4095, 4095, 4095, 4095, 4095, 3458, 2696
  },
  {
    1987, 2084, 2164, 2206, 2261, 2413, 2694, 3034,
    3296, 3367, 3248, 3051, 2909, 2853, 2781, 2527,
    2008, 1320, 710, 426, 552, 949, 1342, 1506,
    1401, 1175, 1033, 1084, 1263, 1404, 1385, 1232,
    1112, 1214, 1614, 2226, 2867, 3375, 3694, 3867,
    3964, 4006, 3959, 3788, 3507, 3183, 2884, 2610,
    2289, 1846, 1285, 729, 350, 262, 431, 704,
    918, 1027, 1128, 1368, 1808, 2329, 2693, 2698,
    2326, 1780, 1359, 1274, 1522, 1915, 2227, 2346,
    2336, 2355, 2510, 2771, 2994, 3032, 2852, 2551,
    2286, 2163, 2180, 2259, 2327, 2370, 2421, 2501,
    2577, 2576, 2454, 2250, 2071, 2006, 2043, 2054,
    1878, 1451, 867, 332, 27, 0, 107, 208,
    231, 284, 575, 1246, 2243, 3308, 4095, 4095,
    4095, 4095, 4032, 3954, 3931, 3821, 3535, 3119,
    2706, 2412, 2246, 2115, 1902, 1565, 1157, 778,
    494, 300, 155, 42, 6, 113, 382, 742,
    1067, 1277, 1411, 1619, 2051, 2729, 3500, 4095,
    4095, 4095, 4046, 3783, 3614, 3452, 3122, 2520,
    1730, 1003, 607, 659, 1051, 1532, 1869, 1985,
    1967, 1963, 2057, 2209, 2308, 2272, 2117, 1938,
    1825, 1796, 1793, 1750, 1652, 1552, 1515, 1550,
    1597, 1579, 1488, 1407, 1460, 1699, 2044, 2314,
    2354, 2157, 1892, 1802, 2033, 2537, 3104, 3508,
    3666, 3670, 3698, 3846, 4036, 4048, 3685, 2913,
    1911, 960, 286, 0, 0, 0, 0, 0,
    0, 147, 539, 957, 1333, 1674, 2033, 2442,
    2863, 3202, 3389, 3436, 3433, 3474, 3572, 3638,
    3555, 3291, 2949, 2712, 2705, 2888, 3052, 2955,
    2488, 1760, 1030, 544, 377, 414, 461, 408,
    315, 362, 697, 1307, 2009, 2557, 2796, 2743,
    2546, 2367, 2278, 2242, 2188, 2087, 1981, 1939
  },
  {
    1039, 1027, 1033, 1037, 1091, 1279, 1630, 2072,
    2464, 2687, 2739, 2725, 2771, 2905, 3017, 2936,
    2574, 2024, 1528, 1331, 1517, 1944, 2340, 2478,
    2320, 2016, 1776, 1709, 1757, 1756, 1587, 1283,
    1014, 971, 1234, 1723, 2254, 2669, 2915, 3034,
    3099, 3131, 3097, 2959, 2732, 2482, 2273, 2105,
    1904, 1591, 1168, 753, 518, 570, 873, 1271,
    1597, 1802, 1979, 2275, 2746, 3274, 3619, 3578,
    3135, 2494, 1955, 1731, 1825, 2052, 2188, 2131,
    1946, 1798, 1799, 1925, 2035, 1988, 1752, 1429,
    1176, 1099, 1197, 1389, 1600, 1810, 2049, 2332,
    2619, 2831, 2916, 2907, 2904, 2991, 3150, 3247,
    3121, 2703, 2088, 1482, 1069, 890, 832, 736,
    544, 371, 432, 878, 1662, 2532, 3179, 3416,
    3281, 2985, 2759, 2699, 2735, 2721, 2567, 2313,
    2086, 1997, 2048, 2137, 2143, 2013, 1796, 1585,
    1442, 1357, 1286, 1211, 1176, 1247, 1446, 1704,
    1900, 1956, 1920, 1945, 2188, 2677, 3264, 3709,
    3827, 3613, 3229, 2878, 2649, 2456, 2125, 1549,
    811, 162, 0, 34, 558, 1180, 1666, 1933,
    2065, 2206, 2436, 2712, 2921, 2977, 2896, 2770,
    2689, 2670, 2656, 2579, 2427, 2254, 2126, 2054,
    1981, 1834, 1605, 1382, 1292, 1391, 1602, 1747,
    1675, 1382, 1041, 895, 1094, 1592, 2178, 2628,
    2857, 2957, 3102, 3389, 3733, 3912, 3723, 3129,
    2301, 1517, 997, 790, 788, 838, 859, 880,
    983, 1211, 1522, 1827, 2061, 2234, 2405, 2611,
    2821, 2948, 2928, 2779, 2599, 2489, 2466, 2445,
    2313, 2039, 1728, 1562, 1664, 1990, 2326, 2427,
    2176, 1673, 1173, 911, 958, 1189, 1406, 1491,
    1501, 1612, 1969, 2562, 3205, 3657, 3764, 3549,
    3166, 2782, 2476, 2220, 1948, 1639, 1342, 1132
  },
  {
    1698, 1773, 1820, 1816, 1815, 1903, 2116, 2392,
    2597, 2628, 2490, 2304, 2205, 2228, 2272, 2169,
    1833, 1355, 971, 922, 1281, 1894, 2479, 2798,
    2801, 2627, 2480, 2462, 2511, 2466, 2208, 1776,
    1348, 1125, 1199, 1500, 1857, 2122, 2250, 2295,
    2330, 2380, 2410, 2380, 2296, 2217, 2198, 2224,
    2211, 2068, 1786, 1475, 1299, 1363, 1630, 1944,
    2144, 2189, 2181, 2278, 2549, 2887, 3065, 2889,
    2353, 1666, 1131, 962, 1157, 1527, 1841, 1982,
    2007, 2066, 2260, 2552, 2792, 2830, 2629, 2287,
    1964, 1769, 1707, 1708, 1706, 1696, 1719, 1805,
    1925, 2010, 2017, 1983, 2010, 2181, 2472, 2743,
    2823, 2630, 2245, 1862, 1651, 1641, 1709, 1686,
    1512, 1300, 1266, 1568, 2165, 2818, 3229, 3226,
    2861, 2359, 1962, 1777, 1742, 1715, 1608, 1457,
    1384, 1491, 1769, 2102, 2355, 2461, 2455, 2417,
    2397, 2382, 2320, 2194, 2048, 1959, 1955, 1980,
    1926, 1730, 1454, 1267, 1336, 1700, 2220, 2658,
    2831, 2730, 2511, 2367, 2375, 2435, 2358, 2023,
    1500, 1023, 850, 1085, 1613, 2178, 2549, 2649,
    2573, 2476, 2453, 2475, 2444, 2289, 2036, 1789,
    1645, 1623, 1668, 1707, 1722, 1757, 1865, 2044,
    2221, 2309, 2288, 2232, 2258, 2417, 2627, 2712,
    2523, 2064, 1519, 1141, 1095, 1348, 1705, 1955,
    2024, 2014, 2106, 2397, 2804, 3100, 3075, 2682,
    2080, 1535, 1250, 1262, 1450, 1650, 1772, 1839,
    1932, 2093, 2286, 2428, 2466, 2419, 2361, 2343,
    2345, 2295, 2138, 1899, 1684, 1592, 1641, 1740,
    1769, 1688, 1589, 1642, 1956, 2475, 2974, 3197,
    3021, 2542, 2014, 1673, 1595, 1665, 1693, 1573,
    1374, 1286, 1466, 1913, 2451, 2843, 2941, 2767,
    2472, 2218, 2076, 2006, 1933, 1822, 1711, 1662
  },
  {
    951, 1041, 1085, 1054, 1021, 1103, 1347, 1669,
    1899, 1910, 1721, 1488, 1376, 1423, 1500, 1419,
    1094, 642, 321, 349, 753, 1341, 1831, 2037,
    1960, 1750, 1562, 1452, 1366, 1237, 1069, 945,
    951, 1087, 1258, 1350, 1327, 1264, 1269, 1380,
    1513, 1528, 1361, 1099, 939, 1036, 1369, 1732,
    1872, 1675, 1249, 858, 734, 921, 1266, 1546,
    1625, 1531, 1394, 1318, 1305, 1277, 1174, 1031,
    951, 1020, 1222, 1444, 1575, 1591, 1567, 1596,
    1677, 1700, 1527, 1134, 670, 385, 457, 862,
    1374, 1722, 1768, 1592, 1406, 1385, 1534, 1707,
    1733, 1556, 1274, 1043, 960, 994, 1037, 1015,
    951, 937, 1038, 1229, 1416, 1527, 1581, 1669,
    1851, 2065, 2134, 1893, 1335, 659, 170, 85,
    396, 890, 1303, 1500, 1536, 1575, 1725, 1943,
    2073, 1978, 1660, 1262, 960, 843, 868, 927,
    951, 961, 1025, 1167, 1326, 1408, 1377, 1312,
    1354, 1580, 1907, 2126, 2039, 1619, 1047, 603,
    477, 654, 940, 1131, 1161, 1133, 1213, 1471,
    1812, 2042, 2014, 1735, 1354, 1049, 908, 902,
    951, 1013, 1113, 1284, 1493, 1630, 1585, 1354,
    1076, 946, 1074, 1384, 1664, 1714, 1501, 1184,
    992, 1051, 1290, 1503, 1517, 1324, 1085, 997,
    1139, 1416, 1637, 1659, 1485, 1235, 1041, 957,
    951, 979, 1052, 1225, 1522, 1860, 2071, 2010,
    1671, 1215, 870, 775, 884, 1023, 1040, 933,
    855, 983, 1356, 1820, 2126, 2104, 1784, 1371,
    1096, 1056, 1176, 1291, 1286, 1169, 1031, 957,
    951, 965, 974, 1026, 1205, 1538, 1928, 2188,
    2167, 1868, 1455, 1139, 1023, 1036, 1006, 822,
    548, 389, 540, 1025, 1653, 2139, 2287, 2105,
    1769, 1482, 1334, 1279, 1213, 1092, 962, 905
  },
  {
    1705, 1810, 1851, 1793, 1729, 1803, 2071, 2426,
    2667, 2650, 2412, 2142, 2026, 2092, 2194, 2142,
    1878, 1538, 1355, 1478, 1855, 2278, 2533, 2547,
    2396, 2204, 2035, 1868, 1680, 1526, 1535, 1796,
    2245, 2669, 2834, 2657, 2271, 1930, 1811, 1898,
    2008, 1966, 1754, 1523, 1462, 1641, 1955, 2217,
    2316, 2290, 2266, 2334, 2459, 2523, 2444, 2257,
    2078, 1988, 1947, 1828, 1555, 1212, 1025, 1198,
    1745, 2444, 2971, 3109, 2878, 2489, 2168, 2005,
    1934, 1849, 1722, 1631, 1671, 1844, 2041, 2131,
    2083, 1993, 1996, 2131, 2293, 2317, 2134, 1851,
    1684, 1783, 2103, 2422, 2511, 2311, 1976, 1746,
    1770, 1998, 2247, 2350, 2274, 2104, 1943, 1812,
    1670, 1504, 1397, 1492, 1864, 2416, 2903, 3085,
    2900, 2499, 2127, 1942, 1906, 1857, 1671, 1393,
    1204, 1277, 1622, 2075, 2421, 2546, 2502, 2421,
    2390, 2384, 2319, 2163, 1991, 1920, 1988, 2095,
    2069, 1827, 1472, 1246, 1355, 1799, 2359, 2743,
    2786, 2547, 2232, 2025, 1959, 1943, 1880, 1778,
    1740, 1857, 2100, 2330, 2406, 2306, 2136, 2031,
    2025, 2022, 1899, 1644, 1407, 1399, 1716, 2238,
    2693, 2843, 2653, 2299, 2026, 1965, 2060, 2150,
    2116, 1973, 1823, 1744, 1719, 1672, 1577, 1518,
    1634, 1988, 2472, 2859, 2956, 2749, 2409, 2151,
    2067, 2064, 1966, 1691, 1341, 1139, 1254, 1663,
    2166, 2528, 2639, 2553, 2401, 2267, 2141, 1983,
    1813, 1736, 1849, 2129, 2405, 2467, 2232, 1832,
    1528, 1525, 1816, 2191, 2399, 2335, 2094, 1881,
    1829, 1916, 2015, 2029, 1982, 1987, 2122, 2343,
    2512, 2511, 2349, 2146, 2017, 1964, 1877, 1655,
    1335, 1111, 1198, 1657, 2314, 2862, 3060, 2889,
    2534, 2226, 2079, 2041, 1987, 1858, 1710, 1647
  },
  {
    1144, 1198, 1236, 1220, 1256, 1498, 1990, 2580,
    3014, 3122, 2948, 2697, 2556, 2538, 2499, 2288,
    1909, 1529, 1341, 1403, 1593, 1730, 1729, 1658,
    1647, 1748, 1886, 1951, 1934, 1974, 2238, 2746,
    3301, 3592, 3419, 2835, 2106, 1518, 1195, 1071,
    1019, 992, 1053, 1274, 1625, 1966, 2173, 2255,
    2364, 2643, 3076, 3449, 3501, 3131, 2477, 1826,
    1399, 1224, 1171, 1115, 1063, 1132, 1407, 1829,
    2218, 2417, 2426, 2383, 2429, 2573, 2682, 2623,
    2404, 2187, 2145, 2298, 2464, 2405, 2021, 1449,
    964, 779, 913, 1222, 1552, 1858, 2191, 2580,
    2940, 3119, 3034, 2771, 2536, 2481, 2566, 2577,
    2302, 1726, 1061, 603, 523, 776, 1178, 1581,
    1963, 2380, 2832, 3200, 3316, 3115, 2717, 2344,
    2153, 2114, 2064, 1872, 1576, 1354, 1362, 1583,
    1829, 1895, 1741, 1524, 1469, 1683, 2078, 2463,
    2706, 2818, 2888, 2952, 2932, 2709, 2273, 1779,
    1455, 1419, 1570, 1669, 1535, 1206, 921, 932,
    1318, 1939, 2561, 3025, 3314, 3477, 3507, 3315,
    2831, 2128, 1439, 1019, 968, 1161, 1361, 1415,
    1373, 1414, 1672, 2096, 2486, 2665, 2620, 2502,
    2475, 2571, 2672, 2636, 2436, 2180, 2004, 1932,
    1854, 1648, 1325, 1058, 1048, 1351, 1804, 2147,
    2226, 2111, 2030, 2171, 2533, 2940, 3191, 3203,
    3032, 2762, 2401, 1897, 1248, 607, 235, 329,
    867, 1593, 2194, 2507, 2599, 2661, 2815, 3011,
    3087, 2937, 2613, 2279, 2058, 1930, 1775, 1516,
    1222, 1063, 1161, 1467, 1789, 1956, 1962, 1964,
    2128, 2464, 2797, 2915, 2746, 2427, 2187, 2161,
    2286, 2380, 2302, 2060, 1775, 1545, 1360, 1148,
    909, 781, 967, 1553, 2391, 3157, 3555, 3510,
    3184, 2829, 2581, 2401, 2164, 1816, 1448, 1202
  },
  {
    1925, 1987, 2037, 2030, 2087, 2379, 2938, 3577,
    4008, 4060, 3804, 3468, 3236, 3108, 2955, 2685,
    2367, 2173, 2208, 2399, 2553, 2539, 2413, 2363,
    2529, 2862, 3172, 3307, 3296, 3312, 3486, 3756,
    3894, 3697, 3168, 2517, 1999, 1727, 1646, 1657,
    1757, 2044, 2579, 3251, 3804, 4014, 3875, 3595,
    3425, 3440, 3489, 3352, 2942, 2387, 1919, 1686,
    1669, 1770, 1951, 2282, 2827, 3495, 4031, 4095,
    3856, 3301, 2843, 2698, 2822, 2999, 3038, 2922,
    2758, 2633, 2515, 2313, 2030, 1824, 1908, 2356,
    3005, 3555, 3790, 3733, 3585, 3526, 3555, 3514,
    3265, 2837, 2405, 2130, 2020, 1959, 1854, 1773,
    1899, 2352, 3045, 3709, 4087, 4095, 3946, 3756,
    3596, 3363, 2942, 2375, 1873, 1658, 1780, 2087,
    2371, 2544, 2685, 2914, 3234, 3491, 3522, 3319,
    3071, 3005, 3182, 3441, 3524, 3300, 2864, 2435,
    2170, 2058, 1994, 1936, 1977, 2245, 2744, 3288,
    3627, 3647, 3473, 3352, 3437, 3649, 3745, 3534,
    3032, 2435, 1947, 1640, 1475, 1427, 1580, 2054,
    2846, 3729, 4095, 4095, 4095, 3589, 3154, 2933,
    2832, 2696, 2486, 2300, 2249, 2320, 2381, 2328,
    2214, 2227, 2517, 3033, 3531, 3760, 3659, 3396,
    3207, 3191, 3247, 3196, 2970, 2671, 2458, 2387,
    2361, 2244, 2030, 1884, 2007, 2447, 3035, 3516,
    3751, 3802, 3831, 3907, 3919, 3679, 3119, 2392,
    1780, 1490, 1521, 1726, 1974, 2266, 2682, 3223,
    3730, 3979, 3863, 3510, 3189, 3093, 3188, 3257,
    3105, 2732, 2320, 2068, 2025, 2094, 2168, 2258,
    2472, 2868, 3331, 3627, 3592, 3289, 2979, 2914,
    3137, 3451, 3591, 3433, 3059, 2642, 2283, 1965,
    1659, 1444, 1506, 1980, 2784, 3620, 4095, 4095,
    4031, 3737, 3527, 3366, 3117, 2724, 2293, 2000
  },
  {
    1117, 1190, 1253, 1255, 1331, 1665, 2274, 2933,
    3330, 3305, 2964, 2552, 2241, 2014, 1766, 1479,
    1282, 1326, 1599, 1899, 1996, 1843, 1635, 1631,
    1925, 2370, 2721, 2850, 2827, 2790, 2766, 2626,
    2237, 1641, 1080, 811, 903, 1198, 1477, 1667,
    1883, 2264, 2785, 3234, 3381, 3179, 2793, 2430,
    2150, 1848, 1419, 930, 618, 693, 1149, 1751,
    2236, 2511, 2678, 2865, 3054, 3086, 2829, 2351,
    1891, 1661, 1666, 1723, 1652, 1461, 1331, 1421,
    1704, 1986, 2103, 2083, 2115, 2351, 2733, 3031,
    3045, 2777, 2407, 2101, 1865, 1577, 1177, 795,
    677, 970, 1568, 2188, 2594, 2767, 2863, 3009,
    3154, 3114, 2775, 2226, 1695, 1355, 1187, 1058,
    907, 856, 1104, 1712, 2486, 3090, 3293, 3127,
    2813, 2546, 2345, 2112, 1804, 1533, 1464, 1633,
    1869, 1930, 1727, 1422, 1300, 1520, 1986, 2451,
    2733, 2842, 2898, 2949, 2891, 2584, 2038, 1467,
    1139, 1151, 1352, 1496, 1473, 1406, 1518, 1908,
    2452, 2917, 3161, 3218, 3188, 3073, 2747, 2108,
    1260, 527, 249, 531, 1175, 1844, 2318, 2594,
    2782, 2923, 2935, 2732, 2377, 2080, 2022, 2176,
    2305, 2168, 1744, 1261, 1006, 1094, 1405, 1735,
    1989, 2229, 2534, 2852, 3006, 2864, 2498, 2159,
    2059, 2181, 2288, 2137, 1700, 1186, 861, 839,
    1049, 1375, 1794, 2366, 3076, 3715, 3966, 3636,
    2834, 1923, 1265, 989, 979, 1051, 1142, 1323,
    1650, 2041, 2319, 2386, 2341, 2398, 2670, 3025,
    3174, 2917, 2326, 1687, 1277, 1163, 1220, 1308,
    1418, 1633, 1980, 2323, 2461, 2326, 2084, 2016,
    2271, 2723, 3066, 3059, 2705, 2198, 1730, 1347,
    999, 697, 596, 878, 1557, 2395, 3041, 3286,
    3189, 2978, 2823, 2694, 2448, 2022, 1538, 1203
  },
  {
    1117, 1190, 1253, 1255, 1331, 1665, 2274, 2933,
    3330, 3305, 2964, 2552, 2241, 2014, 1766, 1479,
    1282, 1326, 1599, 1899, 1996, 1843, 1635, 1631,
    1925, 2370, 2721, 2850, 2827, 2790, 2766, 2626,
    2237, 1641, 1080, 811, 903, 1198, 1477, 1667,
    1883, 2264, 2785, 3234, 3381, 3179, 2793, 2430,
    2150, 1848, 1419, 930, 618, 693, 1149, 1751,
    2236, 2511, 2678, 2865, 3054, 3086, 2829, 2351,
    1891, 1661, 1666, 1723, 1652, 1461, 1331, 1421,
    1704, 1986, 2103, 2083, 2115, 2351, 2733, 3031,
    3045, 2777, 2407, 2101, 1865, 1577, 1177, 795,
    677, 970, 1568, 2188, 2594, 2767, 2863, 3009,
    3154, 3114, 2775, 2226, 1695, 1355, 1187, 1058,
    907, 856, 1104, 1712, 2486, 3090, 3293, 3127,
    2813, 2546, 2345, 2112, 1804, 1533, 1464, 1633,
    1869, 1930, 1727, 1422, 1300, 1520, 1986, 2451,
    2733, 2842, 2898, 2949, 2891, 2584, 2038, 1467,
    1139, 1151, 1352, 1496, 1473, 1406, 1518, 1908,
    2452, 2917, 3161, 3218, 3188, 3073, 2747, 2108,
    1260, 527, 249, 531, 1175, 1844, 2318, 2594,
    2782, 2923, 2935, 2732, 2377, 2080, 2022, 2176,
    2305, 2168, 1744, 1261, 1006, 1094, 1405, 1735,
    1989, 2229, 2534, 2852, 3006, 2864, 2498, 2159,
    2059, 2181, 2288, 2137, 1700, 1186, 861, 839,
    1049, 1375, 1794, 2366, 3076, 3715, 3966, 3636,
    2834, 1923, 1265, 989, 979, 1051, 1142, 1323,
    1650, 2041, 2319, 2386, 2341, 2398, 2670, 3025,
    3174, 2917, 2326, 1687, 1277, 1163, 1220, 1308,
    1418, 1633, 1980, 2323, 2461, 2326, 2084, 2016,
    2271, 2723, 3066, 3059, 2705, 2198, 1730, 1347,
    999, 697, 596, 878, 1557, 2395, 3041, 3286,
    3189, 2978, 2823, 2694, 2448, 2022, 1538, 1203
  },
  {
    1718, 1921, 1999, 1656, 1132, 1032, 1712, 2848,
    3643, 3512, 2596, 1623, 1246, 1506, 1915, 2017,
    1844, 1803, 2145, 2612, 2653, 2019, 1111, 688,
    1190, 2308, 3242, 3398, 2864, 2229, 1969, 2022,
    1965, 1564, 1094, 1081, 1711, 2557, 2915, 2470,
    1625, 1150, 1483, 2345, 3029, 3067, 2612, 2185,
    2096, 2139, 1883, 1234, 647, 732, 1629, 2782,
    3379, 3061, 2216, 1596, 1624, 2069, 2372, 2248,
    1953, 1942, 2320, 2666, 2456, 1648, 817, 673,
    1391, 2432, 3022, 2838, 2248, 1891, 2042, 2394,
    2450, 2085, 1692, 1745, 2251, 2681, 2470, 1618,
    757, 605, 1314, 2340, 2962, 2917, 2559, 2405,
    2574, 2687, 2333, 1581, 995, 1097, 1825, 2543,
    2617, 2016, 1334, 1217, 1764, 2469, 2751, 2515,
    2186, 2209, 2546, 2708, 2296, 1481, 909, 1099,
    1922, 2684, 2761, 2163, 1491, 1343, 1761, 2265,
    2393, 2177, 2070, 2401, 2954, 3126, 2538, 1473,
    689, 746, 1508, 2285, 2490, 2151, 1804, 1902,
    2355, 2664, 2482, 2010, 1796, 2145, 2747, 2934,
    2340, 1301, 593, 739, 1553, 2355, 2620, 2417,
    2233, 2394, 2701, 2669, 2100, 1381, 1161, 1710,
    2604, 3073, 2700, 1796, 1093, 1072, 1566, 2017,
    2081, 1946, 2065, 2586, 3118, 3090, 2358, 1432,
    1049, 1496, 2335, 2804, 2518, 1780, 1244, 1274,
    1656, 1913, 1860, 1810, 2187, 2986, 3642, 3514,
    2517, 1276, 618, 874, 1639, 2210, 2240, 1983,
    1918, 2192, 2465, 2316, 1768, 1353, 1601, 2477,
    3320, 3416, 2637, 1569, 968, 1111, 1625, 1943,
    1888, 1782, 2016, 2544, 2867, 2552, 1738, 1103,
    1261, 2175, 3150, 3442, 2895, 2013, 1437, 1358,
    1450, 1342, 1089, 1143, 1827, 2881, 3588, 3398,
    2455, 1508, 1250, 1731, 2377, 2578, 2246, 1815
  },
  {
    1956, 2312, 2492, 2158, 1587, 1440, 2075, 3103,
    3686, 3310, 2251, 1289, 964, 1148, 1318, 1207,
    1102, 1470, 2337, 3132, 3196, 2466, 1596, 1370,
    1972, 2846, 3266, 3016, 2500, 2211, 2166, 1932,
    1202, 279, 0, 514, 1825, 2970, 3298, 2911,
    2460, 2438, 2721, 2794, 2395, 1846, 1708, 2128,
    2613, 2496, 1639, 644, 310, 889, 1878, 2537,
    2593, 2411, 2483, 2835, 2993, 2546, 1687, 1118,
    1375, 2266, 3014, 2986, 2268, 1526, 1315, 1565,
    1757, 1572, 1273, 1419, 2191, 3093, 3371, 2751,
    1734, 1144, 1359, 2019, 2463, 2416, 2209, 2316,
    2752, 2995, 2547, 1529, 660, 598, 1311, 2116,
    2356, 2015, 1666, 1816, 2379, 2798, 2684, 2258,
    2113, 2543, 3164, 3261, 2510, 1347, 574, 613,
    1161, 1574, 1564, 1455, 1755, 2519, 3211, 3232,
    2567, 1849, 1757, 2343, 2992, 3048, 2449, 1737,
    1454, 1580, 1619, 1216, 628, 520, 1267, 2504,
    3408, 3450, 2855, 2318, 2281, 2532, 2517, 2013,
    1407, 1298, 1822, 2459, 2530, 1902, 1140, 958,
    1517, 2286, 2609, 2356, 2002, 2057, 2485, 2743,
    2396, 1643, 1184, 1516, 2413, 3111, 3038, 2338,
    1674, 1530, 1760, 1837, 1500, 1087, 1183, 1941,
    2834, 3122, 2577, 1723, 1337, 1707, 2410, 2796,
    2657, 2373, 2410, 2734, 2807, 2177, 1045, 176,
    210, 1065, 2032, 2466, 2362, 2242, 2514, 3006,
    3170, 2727, 2032, 1745, 2140, 2771, 2886, 2175,
    1096, 437, 583, 1209, 1704, 1825, 1894, 2338,
    3102, 3601, 3299, 2321, 1415, 1285, 1930, 2673,
    2829, 2339, 1732, 1513, 1639, 1648, 1264, 805,
    906, 1822, 3065, 3773, 3486, 2550, 1755, 1582,
    1830, 1959, 1751, 1543, 1806, 2530, 3118, 2944,
    2015, 1030, 751, 1302, 2097, 2453, 2239, 1915
  },
  {
    1964, 2362, 2559, 2189, 1568, 1414, 2067, 3059,
    3526, 3046, 2033, 1276, 1149, 1327, 1288, 987,
    936, 1584, 2708, 3521, 3425, 2621, 1903, 1856,
    2309, 2599, 2335, 1808, 1611, 1918, 2247, 1998,
    1166, 443, 549, 1503, 2603, 3140, 3062, 2903,
    3077, 3364, 3157, 2203, 1000, 375, 684, 1474,
    1982, 1920, 1700, 1887, 2497, 2950, 2717, 1961,
    1425, 1673, 2496, 3112, 2972, 2281, 1721, 1683,
    1882, 1764, 1217, 782, 1086, 2110, 3112, 3324,
    2695, 1899, 1625, 1901, 2178, 2031, 1671, 1687,
    2317, 3076, 3199, 2439, 1367, 825, 1111, 1751,
    2065, 1899, 1721, 2001, 2610, 2919, 2518, 1731,
    1353, 1830, 2779, 3352, 3069, 2250, 1598, 1445,
    1472, 1203, 669, 468, 1120, 2420, 3528, 3741,
    3144, 2457, 2266, 2453, 2438, 1916, 1254, 1094,
    1614, 2272, 2351, 1722, 1001, 913, 1554, 2336,
    2649, 2506, 2458, 2890, 3503, 3576, 2750, 1475,
    615, 626, 1170, 1560, 1528, 1462, 1874, 2718,
    3334, 3129, 2236, 1437, 1396, 2018, 2602, 2606,
    2183, 1928, 2145, 2474, 2310, 1544, 781, 764,
    1596, 2598, 2979, 2593, 2012, 1853, 2129, 2320,
    2047, 1576, 1549, 2236, 3140, 3434, 2781, 1683,
    980, 1029, 1443, 1618, 1441, 1379, 1878, 2749,
    3283, 2983, 2126, 1531, 1738, 2479, 2991, 2808,
    2197, 1776, 1790, 1858, 1476, 702, 214, 644,
    1885, 3131, 3627, 3348, 2903, 2803, 2914, 2686,
    1876, 935, 595, 1104, 1936, 2317, 2009, 1510,
    1471, 1978, 2486, 2467, 2030, 1820, 2285, 3129,
    3560, 3092, 2049, 1221, 1077, 1352, 1459, 1214,
    1058, 1522, 2535, 3375, 3355, 2530, 1651, 1420,
    1826, 2259, 2233, 1913, 1866, 2338, 2895, 2850,
    2036, 1061, 736, 1277, 2114, 2503, 2272, 1916
  },
  {
    1639, 1664, 1562, 1341, 1360, 1915, 2829, 3528,
    3547, 2949, 2219, 1761, 1548, 1288, 877, 621,
    938, 1861, 2903, 3446, 3282, 2734, 2268, 2022,
    1771, 1321, 868, 873, 1570, 2635, 3406, 3454,
    2920, 2299, 1919, 1689, 1347, 896, 694, 1077,
    1938, 2737, 2992, 2720, 2385, 2390, 2662, 2769,
    2419, 1793, 1356, 1365, 1621, 1732, 1581, 1463,
    1732, 2345, 2832, 2753, 2162, 1583, 1512, 1960,
    2502, 2750, 2711, 2665, 2725, 2631, 2028, 958,
    0, 0, 496, 1736, 2834, 3458, 3723, 3841,
    3752, 3184, 2069, 822, 110, 289, 1094, 1902,
    2304, 2395, 2518, 2782, 2906, 2557, 1804, 1148,
    1076, 1597, 2255, 2598, 2593, 2554, 2689, 2805,
    2511, 1715, 836, 485, 898, 1731, 2409, 2656,
    2660, 2728, 2863, 2746, 2156, 1334, 853, 1093,
    1868, 2596, 2846, 2685, 2489, 2460, 2405, 2012,
    1304, 722, 730, 1335, 2064, 2430, 2399, 2364,
    2665, 3183, 3442, 3110, 2344, 1619, 1245, 1108,
    918, 647, 646, 1270, 2402, 3433, 3752, 3276,
    2479, 1920, 1759, 1753, 1669, 1610, 1864, 2469,
    3015, 2959, 2167, 1103, 447, 518, 1081, 1689,
    2157, 2652, 3327, 3959, 4051, 3323, 2069, 966,
    513, 658, 980, 1199, 1437, 1979, 2804, 3469,
    3484, 2808, 1918, 1372, 1319, 1472, 1526, 1535,
    1822, 2522, 3289, 3542, 3008, 2017, 1205, 958,
    1133, 1343, 1427, 1594, 2085, 2776, 3197, 2987,
    2297, 1689, 1605, 1967, 2306, 2280, 2009, 1884,
    2086, 2358, 2294, 1817, 1301, 1203, 1573, 2011,
    2103, 1872, 1753, 2114, 2839, 3420, 3451, 2996,
    2439, 2029, 1639, 1019, 242, 0, 205, 1436,
    2883, 3816, 3952, 3559, 3062, 2600, 2024, 1278,
    664, 643, 1346, 2343, 2958, 2854, 2286, 1788
  },
  {
    1664, 1710, 1621, 1407, 1442, 2003, 2873, 3465,
    3372, 2745, 2084, 1708, 1489, 1146, 713, 612,
    1202, 2315, 3312, 3633, 3266, 2647, 2153, 1768,
    1286, 760, 609, 1212, 2410, 3513, 3856, 3344,
    2445, 1678, 1182, 798, 495, 559, 1284, 2512,
    3601, 3926, 3426, 2610, 2030, 1793, 1607, 1266,
    968, 1098, 1726, 2439, 2713, 2438, 2006, 1863,
    2044, 2194, 2047, 1785, 1847, 2396, 3057, 3245,
    2741, 1890, 1225, 956, 880, 784, 811, 1334,
    2449, 3684, 4095, 4001, 3035, 2052, 1429, 1079,
    781, 592, 827, 1619, 2608, 3172, 2997, 2384,
    1932, 1937, 2162, 2183, 1912, 1690, 1855, 2317,
    2620, 2441, 1951, 1617, 1681, 1910, 1901, 1595,
    1381, 1666, 2386, 3011, 3069, 2603, 2079, 1865,
    1879, 1787, 1488, 1298, 1590, 2308, 2924, 2932,
    2348, 1676, 1389, 1493, 1645, 1637, 1660, 2042,
    2762, 3350, 3316, 2665, 1904, 1532, 1564, 1603,
    1355, 1002, 995, 1531, 2303, 2818, 2898, 2809,
    2868, 3011, 2849, 2155, 1229, 689, 883, 1548,
    2098, 2207, 2062, 2049, 2261, 2408, 2227, 1862,
    1767, 2190, 2838, 3128, 2766, 2035, 1479, 1347,
    1410, 1328, 1118, 1157, 1721, 2593, 3217, 3234,
    2828, 2472, 2390, 2340, 1956, 1257, 718, 808,
    1498, 2286, 2699, 2716, 2652, 2684, 2608, 2120,
    1299, 686, 820, 1690, 2713, 3260, 3186, 2822,
    2502, 2202, 1692, 990, 515, 722, 1593, 2569,
    3045, 2906, 2541, 2359, 2356, 2214, 1783, 1351,
    1368, 1923, 2586, 2811, 2473, 1952, 1679, 1683,
    1634, 1326, 1011, 1176, 1997, 3075, 3770, 3769,
    3287, 2713, 2162, 1452, 521, 0, 0, 704,
    2221, 3469, 3925, 3689, 3199, 2718, 2167, 1448,
    794, 672, 1285, 2261, 2912, 2846, 2291, 1798
  },
  {
    1007, 1856, 3088, 3141, 1847, 693, 1019, 2402,
    3221, 2669, 1652, 1511, 2265, 2661, 1926, 902,
    1029, 2441, 3641, 3260, 1719, 730, 1238, 2375,
    2679, 1956, 1422, 1994, 3006, 3042, 1827, 706,
    1023, 2433, 3287, 2649, 1408, 1118, 2052, 2925,
    2601, 1546, 1185, 2010, 2913, 2633, 1438, 857,
    1747, 3148, 3408, 2207, 934, 975, 2063, 2745,
    2291, 1564, 1775, 2782, 3198, 2211, 766, 519,
    1815, 3231, 3271, 2120, 1291, 1679, 2511, 2481,
    1542, 991, 1744, 3042, 3318, 2172, 930, 1040,
    2298, 3130, 2564, 1398, 1127, 2028, 2866, 2544,
    1544, 1280, 2202, 3139, 2764, 1349, 530, 1323,
    2864, 3450, 2579, 1454, 1382, 2157, 2479, 1781,
    1038, 1485, 2882, 3653, 2796, 1178, 554, 1486,
    2736, 2860, 1960, 1411, 1992, 2872, 2739, 1593,
    829, 1472, 2813, 3235, 2228, 1036, 1114, 2328,
    3157, 2624, 1479, 1185, 2020, 2769, 2363, 1324,
    1121, 2227, 3406, 3187, 1710, 604, 1030, 2335,
    2953, 2368, 1638, 1880, 2743, 2873, 1777, 620,
    857, 2375, 3534, 3105, 1716, 1022, 1666, 2595,
    2523, 1612, 1201, 1986, 3034, 2956, 1739, 846,
    1407, 2768, 3270, 2302, 1044, 990, 2114, 2978,
    2598, 1645, 1484, 2330, 2945, 2295, 996, 656,
    1854, 3341, 3494, 2243, 1092, 1233, 2166, 2501,
    1839, 1266, 1837, 3059, 3406, 2261, 808, 665,
    1934, 3095, 2878, 1764, 1266, 1962, 2817, 2600,
    1538, 1039, 1834, 2968, 2975, 1770, 819, 1333,
    2738, 3371, 2522, 1266, 1073, 1987, 2681, 2254,
    1408, 1483, 2608, 3416, 2742, 1172, 431, 1320,
    2771, 3183, 2343, 1540, 1807, 2599, 2598, 1556,
    737, 1323, 2823, 3559, 2693, 1261, 902, 1879,
    2844, 2605, 1599, 1244, 2041, 2919, 2658, 1531
  },
  {
    1940, 2558, 3310, 3167, 1867, 350, 0, 1062,
    2800, 3765, 3383, 2325, 1683, 1824, 2122, 1810,
    973, 562, 1363, 3030, 4095, 3948, 2338, 733,
    312, 1081, 2042, 2327, 2055, 2043, 2730, 3541,
    3433, 2069, 354, 0, 660, 2465, 3674, 3555,
    2627, 1952, 1980, 2174, 1778, 840, 310, 1054,
    2820, 4095, 4095, 2750, 1016, 328, 870, 1758,
    2102, 1931, 2002, 2773, 3699, 3704, 2351, 483,
    0, 332, 2127, 3511, 3617, 2819, 2147, 2119,
    2272, 1849, 837, 165, 780, 2548, 4095, 4095,
    3056, 1293, 441, 815, 1624, 1964, 1795, 1856,
    2655, 3707, 3898, 2665, 738, 0, 137, 1836,
    3299, 3559, 2871, 2228, 2206, 2400, 2025, 983,
    161, 577, 2243, 3964, 4095, 3212, 1509, 607,
    911, 1683, 1987, 1722, 1634, 2344, 3478, 3919,
    2958, 1144, 0, 179, 1657, 3024, 3299, 2677,
    2126, 2247, 2633, 2411, 1352, 294, 368, 1792,
    3522, 4095, 3306, 1795, 924, 1157, 1829, 2014,
    1589, 1330, 1958, 3199, 3921, 3260, 1583, 231,
    275, 1525, 2778, 3042, 2448, 1949, 2189, 2781,
    2774, 1790, 573, 315, 1429, 3049, 3826, 3210,
    1931, 1202, 1494, 2155, 2234, 1577, 1016, 1432,
    2711, 3741, 3497, 2102, 754, 565, 1507, 2523,
    2671, 2061, 1640, 2072, 2958, 3236, 2353, 953,
    300, 1029, 2487, 3382, 3051, 2056, 1509, 1878,
    2532, 2499, 1601, 718, 888, 2167, 3485, 3671,
    2604, 1315, 927, 1562, 2316, 2308, 1645, 1274,
    1887, 3079, 3677, 2945, 1400, 361, 677, 1927,
    2902, 2843, 2138, 1788, 2244, 2901, 2778, 1670,
    489, 408, 1648, 3195, 3762, 3008, 1804, 1276,
    1670, 2211, 2062, 1311, 912, 1616, 3052, 3976,
    3474, 1900, 566, 489, 1470, 2418, 2532, 2072
  },
  {
    2305, 1950, 1626, 1814, 2468, 2972, 2698, 1651,
    599, 493, 1629, 3299, 4095, 3750, 2036, 322,
    0, 716, 2337, 3494, 3539, 2733, 1873, 1551,
    1713, 1874, 1704, 1400, 1477, 2176, 3100, 3465,
    2796, 1444, 411, 557, 1859, 3357, 3885, 3012,
    1398, 273, 466, 1773, 3173, 3670, 3055, 1956,
    1225, 1225, 1645, 1927, 1865, 1776, 2102, 2843,
    3423, 3156, 1941, 508, 0, 771, 2528, 3975,
    4081, 2811, 1147, 304, 788, 2069, 3085, 3132,
    2367, 1558, 1356, 1763, 2238, 2291, 1965, 1758,
    2067, 2709, 3020, 2475, 1275, 311, 477, 1870,
    3595, 4095, 3648, 1838, 238, 0, 953, 2472,
    3385, 3239, 2444, 1786, 1701, 1974, 2076, 1773,
    1386, 1465, 2176, 3031, 3252, 2491, 1234, 486,
    945, 2362, 3668, 3808, 2604, 928, 25, 542,
    2045, 3415, 3744, 2992, 1892, 1252, 1307, 1669,
    1826, 1700, 1681, 2158, 2993, 3517, 3093, 1773,
    411, 53, 1073, 2800, 3984, 3764, 2346, 833,
    342, 1140, 2499, 3344, 3124, 2182, 1357, 1230,
    1687, 2150, 2196, 1957, 1926, 2378, 2991, 3078,
    2252, 913, 57, 492, 2102, 3831, 4095, 3481,
    1632, 203, 113, 1246, 2634, 3287, 2946, 2155,
    1671, 1781, 2137, 2202, 1837, 1454, 1587, 2295,
    3011, 3008, 2101, 926, 482, 1281, 2841, 3994,
    3798, 2312, 588, 0, 597, 2192, 3484, 3681,
    2895, 1901, 1409, 1511, 1759, 1733, 1500, 1531,
    2148, 3075, 3557, 3017, 1650, 404, 259, 1409,
    3036, 3917, 3390, 1883, 571, 434, 1497, 2873,
    3520, 3065, 2014, 1233, 1196, 1675, 2076, 2072,
    1891, 2018, 2606, 3204, 3117, 2089, 689, 0,
    611, 2318, 3929, 4095, 3162, 1386, 241, 446,
    1669, 2875, 3209, 2628, 1811, 1479, 1772, 2227
  },
  {
    2335, 1960, 1685, 1991, 2665, 2957, 2364, 1256,
    1187, 675, 1385, 2969, 4095, 3891, 2178, 296,
    0, 858, 2528, 3499, 3277, 2384, 1687, 1864,
    1755, 1891, 1800, 1493, 1474, 2117, 3086, 3446,
    2627, 1190, 321, 799, 2247, 3423, 3310, 3107,
    1738, 395, 255, 1464, 3033, 3737, 3149, 1995,
    1297, 1347, 1704, 1834, 1723, 1823, 2108, 2639,
    3261, 3208, 2125, 617, 0, 748, 2661, 4066,
    3914, 2447, 933, 547, 1394, 1601, 2804, 3229,
    2646, 1734, 1332, 1636, 2113, 2142, 1819, 1735,
    2218, 2881, 2971, 2189, 1720, 621, 355, 1441,
    3232, 4095, 3802, 1959, 273, 50, 1212, 2640,
    3225, 2756, 1910, 2316, 1840, 1897, 2026, 1814,
    1434, 1470, 2204, 3124, 3256, 2304, 984, 435,
    1171, 2551, 3314, 3642, 2920, 1289, 77, 298,
    1775, 3318, 3760, 2948, 1844, 1312, 1466, 1796,
    1872, 1825, 1577, 1917, 2711, 3406, 3216, 1970,
    487, 10, 1148, 2954, 3986, 3485, 1998, 851,
    972, 994, 2116, 3181, 3271, 2421, 1473, 1207,
    1641, 2110, 2109, 1863, 1914, 2408, 2823, 2479,
    2808, 1550, 347, 282, 1634, 3479, 4095, 3526,
    1607, 217, 326, 1591, 2839, 3159, 2604, 1942,
    1762, 1656, 1999, 2221, 1988, 1609, 1694, 2407,
    3070, 2862, 1756, 638, 549, 1686, 3126, 3294,
    3719, 2662, 912, 0, 407, 2032, 3459, 3612,
    2747, 1800, 1467, 1676, 1899, 1861, 1595, 1503,
    1915, 2795, 3437, 3078, 1735, 392, 309, 1631,
    3271, 3888, 3033, 1515, 651, 866, 1341, 2604,
    3487, 3253, 2196, 1262, 1125, 1617, 2009, 1977,
    1857, 2125, 2738, 3044, 2446, 2512, 1180, 155,
    433, 2025, 3791, 4095, 3137, 1246, 193, 622,
    1932, 2950, 3001, 2393, 2115, 1507, 1558, 1991
  },
  {
    2299, 1606, 1862, 2187, 2600, 3114, 2824, 819,
    742, 762, 1777, 2857, 3979, 4095, 2607, 70,
    0, 1274, 2290, 3296, 3402, 2624, 1883, 2093,
    1423, 1682, 1942, 1277, 1503, 2618, 2805, 3895,
    2249, 1512, 0, 904, 1903, 3739, 3659, 3477,
    1378, 119, 643, 1169, 2648, 4095, 3128, 2162,
    1306, 1460, 1690, 1974, 1373, 1684, 1967, 3108,
    3257, 3304, 2323, 309, 7, 529, 2826, 4095,
    3817, 2606, 606, 565, 1564, 1755, 2924, 3206,
    2565, 1884, 1147, 1262, 2231, 2237, 2195, 2100,
    1944, 2626, 3225, 1916, 1444, 924, 395, 1723,
    3132, 4095, 3586, 1748, 42, 268, 1482, 2742,
    3110, 2570, 2025, 2385, 1828, 2180, 1616, 1958,
    1380, 1703, 2019, 3249, 3581, 2116, 685, 199,
    1554, 2900, 3289, 3588, 2850, 1045, 0, 597,
    1989, 3292, 3640, 3076, 1633, 1156, 1650, 2200,
    1884, 1603, 1349, 2034, 2754, 3521, 3437, 1599,
    744, 0, 1040, 3065, 4095, 3458, 1782, 963,
    997, 977, 1824, 3559, 3467, 2488, 1558, 699,
    1750, 1983, 2306, 1793, 2240, 2704, 2237, 2629,
    2939, 1330, 530, 545, 1391, 3086, 4095, 3624,
    1583, 443, 206, 1788, 2457, 3132, 2913, 1810,
    1654, 1539, 2375, 2330, 2305, 1378, 1366, 2269,
    3182, 3207, 1447, 648, 813, 1931, 3069, 3286,
    3459, 2647, 833, 0, 589, 2201, 3797, 3585,
    2499, 1455, 1353, 2169, 2045, 1862, 1599, 1248,
    1735, 3087, 3519, 3073, 1783, 586, 403, 1230,
    3053, 4030, 3230, 1553, 814, 1012, 1239, 2409,
    3612, 3022, 2454, 988, 1344, 1690, 2015, 2311,
    1661, 1882, 2970, 3096, 2259, 2286, 1362, 415,
    382, 2202, 4077, 4095, 2592, 1052, 470, 805,
    2008, 3117, 3179, 2167, 1896, 1466, 1818, 2081
  },
  {
    1966, 2056, 2324, 2444, 1716, 1440, 1465, 1652,
    1875, 2034, 2094, 2076, 2037, 2105, 2583, 1888,
    994, 1008, 1565, 2138, 2414, 2398, 2270, 2152,
    2001, 1726, 1370, 1159, 1325, 1872, 2502, 2825,
    2599, 1908, 1177, 1358, 1754, 1897, 1956, 1973,
    1965, 1970, 2000, 2020, 1980, 1914, 1867, 1698,
    1633, 1822, 2021, 2054, 1931, 1831, 1905, 2094,
    2140, 1824, 1297, 1964, 2188, 1828, 1576, 2128,
    2255, 1961, 1600, 1533, 1823, 2209, 2347, 2115,
    1705, 1447, 1526, 1839, 2117, 2168, 2035, 1919,
    1948, 2041, 1998, 1724, 1392, 1362, 1896, 2811,
    2122, 1739, 1726, 1901, 2062, 2040, 1867, 1669,
    1531, 1527, 1740, 2238, 2702, 2377, 1984, 1563,
    1305, 1376, 1742, 2165, 2333, 2139, 1788, 1624,
    1819, 2208, 2414, 2176, 1596, 1106, 1087, 1600,
    2354, 2838, 2758, 2219, 1598, 1247, 1250, 1468,
    1734, 2029, 2451, 2851, 2030, 1593, 1481, 1600,
    1808, 1954, 2009, 2012, 1969, 1886, 1800, 1768,
    1812, 1937, 2247, 2475, 1925, 1398, 1223, 1479,
    1957, 2335, 2421, 2267, 2054, 1870, 1614, 1148,
    1402, 2051, 2361, 2381, 2151, 1806, 1621, 1674,
    1793, 1900, 1995, 2059, 2054, 1959, 1750, 1419,
    1732, 2123, 2329, 2207, 1857, 1571, 1594, 1896,
    2180, 2116, 1639, 1438, 1959, 2116, 2093, 2051,
    2049, 2037, 1956, 1739, 1214, 911, 2104, 2666,
    2618, 2292, 1979, 1758, 1557, 1351, 1268, 1485,
    2014, 2601, 2861, 2571, 1885, 1233, 989, 1278,
    1853, 2301, 2449, 2380, 2080, 1765, 1562, 1513,
    1617, 1930, 2552, 2071, 1735, 1723, 1797, 1809,
    1807, 1898, 2059, 2111, 2091, 2188, 1924, 1185,
    1048, 1869, 2546, 2656, 2239, 1647, 1338, 1500,
    1926, 2232, 2194, 1935, 1853, 1585, 1647, 1843
  },
  {
    1659, 2675, 2749, 995, 2173, 1940, 1758, 1737,
    1805, 1884, 1945, 2020, 2163, 2406, 1786, 2321,
    991, 844, 1698, 2413, 2642, 2402, 2020, 1879,
    1873, 1701, 1340, 1179, 1629, 2362, 2546, 2823,
    2611, 635, 1054, 2099, 1830, 1970, 2091, 2189,
    2174, 2003, 1706, 1379, 1301, 1802, 2504, 3525,
    1931, 631, 1107, 1894, 2188, 2207, 2261, 2251,
    1696, 718, 3108, 1636, 1614, 2164, 1962, 1527,
    2214, 2001, 1463, 1379, 1962, 2680, 2826, 2236,
    1296, 814, 1099, 1902, 2559, 2590, 2142, 1841,
    1891, 2012, 1954, 1594, 1161, 1342, 2876, 1538,
    2388, 2161, 1968, 1905, 1876, 1872, 1781, 1648,
    1622, 1774, 2024, 1808, 1350, 3460, 2891, 1498,
    1072, 1273, 1372, 1966, 2476, 2263, 1679, 1448,
    1930, 2703, 2997, 2280, 930, 682, 802, 982,
    2550, 3717, 3622, 2527, 1167, 573, 651, 1194,
    2057, 3027, 3472, 328, 2460, 2176, 1868, 1735,
    1734, 1783, 1780, 1757, 1784, 1880, 2039, 2201,
    2229, 2073, 1483, 1629, 2971, 1691, 851, 1072,
    1864, 2609, 2790, 2451, 1961, 1515, 1103, 1847,
    2014, 1647, 1888, 2020, 2063, 2184, 2102, 1878,
    1874, 1891, 1808, 1635, 1480, 1540, 2049, 3897,
    1024, 1088, 2025, 2385, 2069, 1655, 1649, 2000,
    2132, 1527, 1310, 2922, 1737, 1758, 1870, 1969,
    2088, 2176, 2080, 1699, 1295, 1033, 1600, 2820,
    2718, 2287, 1985, 1875, 1713, 1312, 1028, 1302,
    2030, 2858, 3103, 2414, 1614, 1352, 673, 1103,
    3016, 3299, 1642, 303, 1899, 2475, 2407, 2217,
    2137, 2046, 0, 2298, 2414, 2355, 2160, 1584,
    1115, 1349, 2022, 3000, 3585, 1751, 1024, 1398,
    0, 1191, 3177, 3342, 3377, 2277, 1124, 914,
    1094, 1158, 1371, 2973, 3320, 3253, 614, 540
  },
  {
    2099, 2469, 2236, 702, 2306, 2265, 1928, 1672,
    1726, 1987, 2127, 1964, 1717, 1825, 1554, 2705,
    1775, 1502, 1837, 2050, 2091, 1947, 1738, 1739,
    1928, 2072, 2002, 1816, 1805, 1889, 1699, 2154,
    2518, 1076, 1654, 2496, 1911, 1823, 1821, 1849,
    1867, 1940, 2050, 1998, 1745, 1642, 1760, 2739,
    1747, 1219, 1994, 2375, 1945, 1549, 1785, 2277,
    2037, 959, 3051, 1449, 1562, 2284, 2050, 1433,
    2072, 2097, 1863, 1753, 1851, 1981, 1988, 1929,
    1821, 1824, 1884, 1978, 2013, 1910, 1751, 1793,
    1972, 2055, 2014, 1821, 1560, 1700, 2938, 1246,
    1937, 1827, 1891, 2013, 2000, 1913, 1785, 1739,
    1875, 2124, 2270, 1727, 862, 2745, 2341, 1478,
    1641, 2081, 1896, 1913, 2030, 1912, 1750, 1767,
    1969, 2110, 2036, 1726, 1441, 2175, 2393, 1596,
    1717, 1928, 1974, 1960, 1874, 1981, 1892, 1671,
    1728, 2290, 2824, 56, 2531, 2354, 1939, 1671,
    1684, 1912, 2091, 2064, 1866, 1685, 1736, 2015,
    2225, 2101, 1361, 1380, 2857, 1977, 1503, 1703,
    2007, 2108, 1943, 1793, 1857, 1922, 1671, 2226,
    2096, 1558, 1797, 1981, 2008, 2034, 1869, 1668,
    1813, 2043, 2128, 1982, 1677, 1472, 1753, 3561,
    869, 1194, 2258, 2509, 1963, 1436, 1561, 2174,
    2442, 1702, 1200, 2655, 1589, 1862, 2067, 1960,
    1757, 1756, 1974, 2111, 2016, 1591, 1633, 2335,
    2028, 1730, 1723, 1922, 2063, 1955, 1810, 1841,
    1901, 1979, 1939, 1732, 1897, 2363, 1614, 1272,
    2407, 2579, 1525, 879, 2556, 2497, 1674, 1351,
    1926, 2700, 844, 2684, 1928, 1498, 1787, 2108,
    2115, 1928, 1585, 1766, 2412, 1472, 1850, 2833,
    998, 1559, 2529, 2010, 2009, 1560, 1460, 2158,
    2552, 1961, 1049, 1816, 2175, 2885, 1132, 1374
  },
  {
    2298, 2981, 1544, 1907, 2114, 2357, 2312, 2031,
    1922, 2051, 2257, 2329, 2136, 1889, 1951, 2330,
    2524, 1904, 1503, 2689, 2381, 1845, 1847, 2222,
    2478, 2244, 1733, 1671, 2468, 3711, 0, 2679,
    2483, 2319, 2099, 1806, 1780, 2394, 3172, 907,
    2428, 2019, 1976, 3332, 949, 2022, 2567, 2323,
    1942, 1935, 2190, 2256, 2131, 2022, 2136, 2259,
    2068, 1982, 2103, 2405, 2424, 1147, 2599, 2418,
    2080, 1906, 1999, 2236, 2336, 2151, 1935, 1952,
    2363, 2253, 1921, 2191, 2200, 1994, 1982, 2335,
    2577, 1839, 774, 4095, 1331, 2647, 760, 2895,
    2687, 1875, 1701, 2040, 2404, 2410, 2086, 1796,
    1879, 2320, 2724, 2512, 11, 3311, 3102, 1436,
    1248, 3032, 2012, 2081, 2195, 1962, 2073, 2353,
    2250, 1298, 3430, 1288, 2013, 2392, 2304, 2042,
    1870, 2446, 1774, 2216, 2566, 1933, 1739, 2235,
    2345, 2240, 2076, 1867, 2092, 2289, 2236, 2183,
    2067, 1880, 1944, 2478, 2615, 1919, 1406, 1820,
    3158, 2882, 1131, 777, 3423, 2936, 1687, 1391,
    1985, 2647, 2670, 1894, 950, 3538, 1441, 2122,
    2405, 2205, 1920, 1914, 2189, 2417, 2283, 1842,
    1983, 2034, 2172, 2886, 2024, 916, 2464, 2887,
    2448, 1253, 1916, 2446, 2377, 2219, 2125, 1761,
    1342, 3767, 1742, 1619, 2008, 2362, 2340, 2127,
    1995, 1992, 2119, 2263, 2278, 2123, 1862, 1684,
    3480, 1143, 1973, 2577, 2351, 1813, 1654, 2372,
    3429, 458, 2493, 2385, 2266, 2090, 1932, 2110,
    1759, 3261, 1250, 2307, 2104, 1810, 2959, 1710,
    1826, 2277, 2319, 2116, 2022, 2111, 2165, 2106,
    2081, 2200, 2374, 2014, 1103, 3510, 1988, 1764,
    1659, 2400, 2848, 1755, 1832, 1996, 2283, 2580,
    2140, 1399, 2388, 2249, 2290, 2145, 2045, 1628
  },
  {
    1924, 2444, 2813, 2991, 2986, 2843, 2628, 2452,
    2434, 2498, 2306, 1709, 1257, 1437, 1788, 1893,
    1862, 1859, 1900, 1934, 1937, 2067, 2535, 3037,
    2605, 1507, 2993, 4095, 2387, 1241, 1643, 1400,
    1577, 1690, 1700, 1583, 1320, 1297, 897, 4095,
    1859, 4095, 3945, 1699, 4095, 2586, 839, 274,
    2773, 861, 522, 638, 3159, 670, 3569, 3585,
    2275, 2822, 3052, 2773, 1831, 1291, 2065, 1950,
    1808, 1722, 1680, 1706, 1839, 2112, 2552, 3205,
    3077, 2986, 9, 2037, 2278, 2969, 1623, 247,
    814, 3418, 3028, 3659, 3881, 1185, 3474, 610,
    706, 1054, 1511, 1892, 2219, 2487, 2671, 2743,
    2690, 2535, 2346, 2195, 2099, 2027, 1929, 1766,
    1551, 1422, 1955, 3456, 1602, 1469, 1901, 2533,
    2937, 2774, 2129, 1705, 2157, 2768, 2283, 1411,
    1188, 1551, 2052, 2447, 2685, 2751, 2625, 2315,
    1913, 1593, 1500, 1659, 1967, 2259, 2430, 2493,
    2525, 2565, 2554, 2374, 1960, 1424, 1070, 1200,
    1881, 2674, 2940, 2849, 2779, 2370, 1681, 1327,
    1582, 2205, 2654, 2062, 1522, 2701, 2513, 2191,
    1971, 1869, 1866, 1953, 2125, 2366, 2612, 2655,
    1259, 2467, 2051, 1394, 2036, 1824, 2313, 2528,
    2549, 2764, 2979, 100, 3505, 2383, 1098, 570,
    3751, 1455, 1648, 1943, 2152, 2304, 2368, 2476,
    2677, 2783, 2720, 2510, 2188, 1792, 1355, 904,
    494, 1440, 749, 4095, 3212, 2926, 4095, 1520,
    2034, 1383, 1679, 1814, 1792, 1641, 1368, 1075,
    3968, 1321, 4081, 1908, 2868, 2153, 433, 2197,
    2089, 1958, 1946, 1979, 2098, 2196, 2320, 2614,
    2993, 3269, 3108, 2003, 630, 616, 1624, 1690,
    1185, 1322, 1960, 2600, 3081, 3429, 3627, 3562,
    3123, 2349, 1527, 976, 714, 658, 869, 1345
  },
  {
    1978, 2287, 2526, 2669, 2687, 2577, 2388, 2225,
    2197, 2323, 2481, 2505, 2388, 2223, 1976, 1694,
    1507, 1450, 1453, 1439, 1427, 1561, 2010, 2746,
    3403, 3628, 4078, 3807, 2389, 899, 1003, 1447,
    1671, 1739, 1691, 1522, 1184, 554, 648, 3083,
    3818, 3891, 3918, 3834, 3555, 2432, 1470, 767,
    771, 762, 962, 883, 941, 1513, 3249, 4000,
    3729, 3335, 2717, 2321, 2333, 2123, 1688, 1383,
    1269, 1282, 1383, 1574, 1866, 2260, 2766, 3457,
    4095, 3462, 1413, 1042, 1071, 1153, 780, 812,
    1586, 3041, 4083, 3878, 3731, 3467, 2518, 32,
    304, 967, 1415, 1780, 2103, 2382, 2594, 2715,
    2729, 2642, 2496, 2374, 2319, 2292, 2230, 2098,
    1878, 1568, 1256, 1339, 1443, 1902, 2434, 2940,
    3241, 3172, 2728, 2140, 1745, 1611, 1490, 1512,
    1766, 2091, 2349, 2503, 2567, 2543, 2416, 2195,
    1936, 1741, 1692, 1804, 2010, 2210, 2339, 2400,
    2437, 2471, 2465, 2345, 2074, 1728, 1483, 1520,
    1888, 2416, 2792, 2848, 2593, 2085, 1562, 1321,
    1470, 1907, 2449, 2909, 2959, 2629, 2217, 1945,
    1799, 1740, 1744, 1802, 1916, 2092, 2334, 2643,
    2867, 2610, 1676, 1174, 1590, 2542, 2417, 2057,
    2012, 2246, 2772, 2886, 2961, 2174, 1527, 927,
    1176, 1434, 1980, 2292, 2408, 2433, 2521, 2716,
    2869, 2872, 2728, 2479, 2159, 1797, 1417, 1020,
    551, 0, 965, 3313, 4095, 4095, 4036, 1891,
    1026, 1725, 2085, 2203, 2157, 1975, 1642, 1080,
    858, 1439, 3279, 3362, 2978, 2705, 2345, 2051,
    1614, 1552, 1722, 1899, 1989, 2034, 2174, 2497,
    2904, 3160, 3029, 2405, 1550, 993, 950, 1074,
    1350, 1848, 2358, 2732, 2971, 3126, 3193, 3108,
    2807, 2308, 1746, 1299, 1076, 1091, 1304, 1631
  },
  {
    1974, 2482, 2875, 3104, 3130, 2965, 2685, 2444,
    2398, 2432, 1941, 1529, 1311, 1281, 1417, 1638,
    1741, 1802, 1867, 1875, 1834, 1943, 2424, 3078,
    2950, 3018, 3414, 3767, 1893, 292, 1172, 1495,
    1619, 1650, 1618, 1519, 1311, 830, 542, 2902,
    3970, 3585, 3716, 4095, 3246, 2351, 1679, 1158,
    715, 432, 429, 557, 1153, 2006, 2746, 3118,
    3104, 2866, 2619, 2497, 2500, 2536, 2518, 2417,
    2251, 2029, 1729, 1335, 915, 637, 609, 848,
    1492, 2361, 3139, 3618, 3787, 3748, 3570, 3205,
    2516, 1447, 246, 0, 141, 0, 1344, 3608,
    3264, 2852, 2669, 2550, 2442, 2336, 2235, 2148,
    2085, 2047, 2016, 1955, 1850, 1735, 1654, 1631,
    1679, 1810, 2036, 2349, 2723, 2936, 2377, 1778,
    1434, 1578, 2217, 2631, 2160, 1995, 2078, 2414,
    2843, 2278, 1754, 1414, 1251, 1265, 1475, 1865,
    2337, 2726, 2890, 2798, 2540, 2262, 2057, 1923,
    1798, 1655, 1563, 1640, 1947, 2381, 2691, 2628,
    2133, 1456, 1160, 1408, 1536, 2233, 2960, 3266,
    3025, 2384, 1601, 1562, 1834, 1990, 2038, 2014,
    1962, 1916, 1895, 1901, 1924, 1944, 1932, 1833,
    1534, 1899, 2945, 3446, 3179, 2286, 1999, 2217,
    2057, 1587, 814, 1088, 1536, 1786, 1929, 2092,
    2305, 2494, 2576, 2539, 2454, 2421, 2474, 2546,
    2514, 2299, 1938, 1557, 1276, 1131, 1077, 1094,
    1249, 1656, 2360, 3211, 3866, 3997, 3421, 2169,
    772, 1352, 1724, 1879, 1916, 1860, 1692, 1325,
    485, 1603, 3374, 3302, 2657, 2380, 2388, 2362,
    1822, 1674, 1777, 1871, 1880, 1838, 1921, 2255,
    2723, 3033, 2863, 2051, 920, 840, 1432, 1622,
    1483, 1466, 2179, 2729, 3087, 3321, 3428, 3313,
    2880, 2155, 1339, 723, 458, 499, 853, 1398
  },
  {
    2279, 2196, 2046, 1841, 1621, 1468, 1478, 1682,
    1981, 2172, 2058, 1578, 1603, 1950, 2077, 2075,
    2013, 1946, 1898, 1848, 1763, 1631, 1488, 1448,
    1612, 1884, 2125, 2292, 2378, 2372, 2259, 2020,
    1630, 1020, 0, 1267, 2810, 2483, 2166, 2366,
    3306, 2194, 1046, 725, 1498, 1846, 1907, 1695,
    1498, 1747, 2090, 2433, 2596, 2448, 2018, 1500,
    1142, 1098, 1352, 1750, 2108, 2310, 2340, 2238,
    2048, 1801, 1550, 1398, 1482, 1896, 2603, 1967,
    1676, 1600, 1639, 1732, 1835, 1922, 2015, 2173,
    2124, 2066, 1991, 1537, 1367, 1433, 1626, 1856,
    2058, 2186, 2208, 2120, 1947, 1754, 1650, 1828,
    2055, 1266, 1253, 1769, 2332, 2499, 2108, 1342,
    1447, 2148, 2385, 2317, 2024, 1567, 936, 850,
    1389, 2093, 2694, 2927, 2690, 2117, 1485, 1062,
    1250, 1474, 1423, 1730, 2003, 2236, 2408, 2460,
    2333, 2031, 1654, 1353, 1243, 1334, 1540, 1754,
    1927, 2090, 2286, 2487, 2568, 2383, 1892, 1253,
    771, 729, 1201, 1984, 2690, 2961, 2668, 1948,
    1188, 1675, 1847, 1892, 1871, 1789, 1633, 1343,
    592, 1891, 3408, 2563, 2227, 1999, 1802, 1619,
    1456, 1343, 1324, 1459, 1807, 2286, 2475, 2255,
    2021, 1904, 1852, 1813, 1759, 1681, 1589, 1523,
    1555, 1773, 2269, 2057, 1921, 1968, 2072, 2100,
    2003, 1824, 1657, 1561, 1535, 1547, 1591, 1712,
    1955, 2290, 2567, 2580, 2192, 1458, 763, 1698,
    1995, 1819, 1036, 1630, 2202, 2731, 2993, 1909,
    1342, 1142, 1288, 1852, 2834, 1816, 1329, 1438,
    1885, 2275, 2331, 2041, 1606, 1686, 1699, 1684,
    1779, 1942, 2064, 2106, 2069, 1940, 1660, 1087,
    1472, 2026, 2215, 2204, 2118, 1966, 1691, 1679,
    1969, 2028, 1853, 1400, 1193, 1701, 2076, 2258
  },
  {
    2084, 2007, 2033, 2179, 2411, 2617, 2660, 2466,
    2097, 1732, 1555, 1632, 1858, 2024, 1955, 1623,
    1136, 625, 1234, 1712, 2121, 2454, 2702, 2873,
    2976, 3011, 2962, 2795, 2457, 1905, 1840, 2225,
    2377, 2208, 1524, 1695, 2066, 2151, 2080, 1907,
    1634, 1214, 462, 498, 1595, 2495, 3312, 2586,
    2206, 2032, 2016, 2142, 2357, 2511, 2491, 2398,
    2385, 2535, 2903, 2783, 2397, 2106, 1917, 1809,
    1778, 1839, 1977, 2104, 2076, 1772, 1187, 711,
    1265, 1519, 1606, 1578, 1443, 1129, 1080, 2214,
    3585, 4095, 3795, 3636, 3792, 3998, 2811, 1929,
    1447, 1217, 1030, 812, 683, 851, 1401, 2164,
    2767, 2855, 2327, 1433, 643, 374, 758, 1597,
    2511, 3177, 3493, 3554, 3493, 3321, 2894, 2032,
    1194, 1977, 2284, 2397, 2397, 2311, 2145, 1894,
    1549, 1075, 625, 1121, 1481, 1663, 1693, 1674,
    1732, 1935, 2244, 2554, 2771, 2876, 2920, 2957,
    2974, 2899, 2671, 2325, 2013, 1910, 2072, 2352,
    2441, 2048, 1087, 0, 824, 1237, 1469, 1617,
    1714, 1765, 1732, 1478, 1188, 3153, 4095, 4095,
    4095, 4095, 2770, 981, 1235, 1454, 1479, 1428,
    1319, 1132, 794, 25, 829, 2188, 2980, 3127,
    2836, 2442, 2205, 2192, 2294, 2361, 2327, 2242,
    2205, 2259, 2350, 2372, 2259, 2048, 1854, 1787,
    1878, 2061, 2231, 2314, 2296, 2191, 1991, 1659,
    1187, 672, 673, 528, 1256, 2661, 4095, 3440,
    3037, 2800, 2620, 2461, 2317, 2194, 2102, 2051,
    2043, 2043, 1976, 1822, 1654, 1532, 1474, 1475,
    1527, 1611, 1700, 1786, 1889, 2036, 2231, 2419,
    2501, 2470, 2431, 2455, 2562, 2770, 3156, 4014,
    3029, 1936, 1119, 505, 696, 858, 752, 640,
    1462, 2286, 2867, 3090, 3001, 2745, 2465, 2238
  },
  {
    2258, 2290, 2417, 2658, 2973, 3251, 3352, 3201,
    2860, 2505, 2321, 2374, 2560, 2670, 2531, 2115,
    1533, 918, 1416, 1778, 2070, 2285, 2419, 2481,
    2484, 2428, 2301, 2070, 1683, 1099, 1019, 1408,
    1581, 1450, 821, 1063, 1519, 1701, 1738, 1680,
    1529, 1233, 605, 763, 1977, 2985, 3901, 3262,
    2954, 2837, 2860, 3007, 3224, 3362, 3307, 3161,
    3080, 3146, 3416, 3186, 2682, 2266, 1948, 1710,
    1551, 1488, 1510, 1531, 1408, 1023, 374, 0,
    375, 619, 716, 717, 629, 380, 412, 1642,
    3121, 4054, 3575, 3547, 3836, 4095, 3115, 2355,
    1985, 1857, 1758, 1612, 1539, 1743, 2310, 3072,
    3653, 3701, 3115, 2145, 1264, 891, 1160, 1875,
    2659, 3193, 3376, 3306, 3120, 2831, 2298, 1343,
    426, 1147, 1410, 1497, 1491, 1418, 1284, 1084,
    807, 416, 63, 669, 1147, 1455, 1615, 1727,
    1916, 2244, 2672, 3091, 3406, 3595, 3708, 3795,
    3846, 3786, 3554, 3185, 2831, 2670, 2758, 2948,
    2936, 2432, 1352, 17, 838, 1124, 1232, 1261,
    1248, 1198, 1078, 750, 403, 2327, 4029, 3456,
    3518, 3701, 2009, 284, 617, 927, 1055, 1114,
    1122, 1056, 839, 191, 1111, 2580, 3472, 3709,
    3495, 3163, 2973, 2990, 3104, 3167, 3111, 2988,
    2897, 2881, 2890, 2819, 2605, 2285, 1977, 1794,
    1770, 1840, 1904, 1887, 1779, 1596, 1331, 949,
    441, 0, 0, 0, 537, 1988, 3802, 2902,
    2585, 2443, 2365, 2314, 2281, 2269, 2286, 2340,
    2430, 2519, 2531, 2443, 2327, 2244, 2207, 2214,
    2255, 2312, 2359, 2388, 2421, 2486, 2589, 2678,
    2654, 2515, 2366, 2282, 2284, 2393, 2689, 3468,
    2415, 1266, 411, 0, 0, 127, 46, 0,
    852, 1745, 2408, 2723, 2735, 2585, 2416, 2301
  },
  {
    2185, 2170, 2249, 2442, 2711, 2942, 2998, 2803,
    2420, 2025, 1803, 1822, 1976, 2058, 1894, 1457,
    857, 229, 718, 1076, 1368, 1587, 1730, 1806,
    1827, 1793, 1693, 1493, 1141, 595, 558, 991,
    1213, 1133, 558, 855, 1367, 1607, 1703, 1705,
    1613, 1376, 806, 1021, 2290, 3352, 4095, 3728,
    3467, 3392, 3454, 3636, 3884, 4049, 4017, 3890,
    3822, 3896, 4095, 3941, 3432, 3007, 2675, 2419,
    2238, 2150, 2142, 2130, 1971, 1548, 856, 289,
    769, 966, 1015, 968, 831, 532, 515, 1697,
    3129, 4016, 3493, 3422, 3671, 3972, 2878, 2086,
    1687, 1532, 1411, 1246, 1156, 1348, 1907, 2662,
    3242, 3290, 2708, 1746, 875, 515, 800, 1533,
    2337, 2892, 3098, 3053, 2893, 2630, 2124, 1196,
    307, 1055, 1344, 1457, 1476, 1428, 1316, 1137,
    880, 506, 170, 789, 1280, 1597, 1765, 1883,
    2074, 2404, 2832, 3249, 3559, 3741, 3847, 3925,
    3966, 3894, 3649, 3267, 2899, 2723, 2796, 2972,
    2944, 2425, 1330, 0, 789, 1062, 1158, 1176,
    1153, 1095, 966, 632, 279, 2200, 3899, 3324,
    3385, 3569, 1879, 157, 493, 808, 941, 1006,
    1021, 961, 751, 110, 1038, 2513, 3413, 3656,
    3448, 3122, 2937, 2959, 3077, 3143, 3090, 2969,
    2878, 2864, 2872, 2800, 2584, 2262, 1951, 1765,
    1737, 1804, 1864, 1844, 1732, 1545, 1277, 892,
    383, 0, 0, 0, 479, 1933, 3751, 2856,
    2546, 2411, 2343, 2302, 2281, 2282, 2313, 2383,
    2489, 2596, 2626, 2558, 2462, 2398, 2382, 2409,
    2471, 2548, 2614, 2662, 2712, 2794, 2912, 3014,
    3002, 2872, 2730, 2651, 2655, 2764, 3057, 3829,
    2767, 1607, 736, 79, 241, 388, 280, 179,
    1024, 1882, 2507, 2783, 2752, 2559, 2345, 2185
  }
};
