# For programmers having trouble touch typing the top row

### My problem and using preonic to solve it

I am an okay letter typist, but often need to look and find special symbols, like $ and ^, on the top row.  Using layers, I assigned special symbols to keys corresponding to their names.

When entering numbers, I like to use the numpad.  But the numpad on a full-sized keyboard is simply too far away.  Staggered keyboard makes it awkward to move the numpad in.  Preonic is ortholinear, and of the right size.  It's quite natural to move the numpad in.  Along the side of the numpad, I also included rows of 1-5 and 6-0.  Sometimes, it's simpler to enter numbers this way.

For programmers, parentheses, brackets, and braces are important.  They are moved to under the fingers in an easy to remember layout as well.

### Layer 0

The middle section, from 1 to 0, plus three rows of letters, follows the traditional QWERTY layout.

The left border, from top to bottom: Esc when tapped and ~ with Shift and ` with Command, Tab, Esc when tapped and Control when held, and One shot layer 5.

The right border: Backspace, Tap dancing leader key, quotes, and One shot layer 6.

Bottom row, left to right: One shot modifier Left shift, Control, Option, Command, One shot layer 4, Enter, Space, Layer 3 double tap to toggle, Slash (moved here to allow for a traditional cluster of arrows), Left, Down, and Right.

### Layer 1

Middle: Colemak

Border: Same as QWERTY

### Layer 2

Middle: Dvorak

Border: Same as QWERTY

### Layer 3

Numpad and common operators around it, with the left of board filled with rows of 1-5 and 6-0

Home/End/Page Up/Down in place of arrow keys

### Layer 4

Special symbols using a character in their names:

pLus (+), pIpe (|)

anD (&), dollaR ($)

At (@), Backslash (\\), Circumflex (^), Exclamation (!), Grave (`), Hash (#), Percent (%), Star (*), Tilde (~), Underscore (_)

minus (\-) is put on J so it's under Underscore, easy to access, and matches the bump on J

equal sign (=) is put on M, under J, because putting it on Q make accidential Command-Q likely

Same Home/End/Page Up/Down cluster as that on Layer 3

### Layer 5

Brackets

### Layer 6

Reset, Caps lock. Base layer switches, RGB backlight controls, Volume controls, and other special functions

### RGB backlight

... is used to indicate the status of Cap locks and which of the higher layers is on.

### Tap dancing

With the Leader key, Tap dance the brackets: <> () [] {}, Cap lock, and some simple phrases.


