/* Copyright 2021 Ramon Imbao
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "quantum.h"

/* This is a shortcut to help you visually see your layout.
 *
 * The first section contains all of the arguments representing the physical
 * layout of the board and position of the keys.
 *
 * The second converts the arguments into a two-dimensional array which
 * represents the switch matrix.
 */

#define ___ KC_NO

#define LAYOUT_ansi( \
    k00, k01, k02, k03, k04, k10, k11, k12, k13, k20, k21, k22, k23, k24,   k3K, k3L, k3M, \
    k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I,   k4K, k4L, k4M, \
    k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H, k9J,   k5K, k5L, k5M, \
    kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG,      kAI, \
    kB5,      kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG,      kBI,        k6O, \
    kC5, kC6, kC7,                kCD,                kCF, kCG, kCI, kCJ,   k7N, k7O, k7P \
) { \
    { k00, k01, k02, k03, k04, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k10, k11, k12, k13, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k20, k21, k22, k23, k24, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k3K, k3L, k3M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k4K, k4L, k4M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k5K, k5L, k5M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k6O, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k7N, k7O, k7P }, \
    { ___, ___, ___, ___, ___, k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H, ___, k9J, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG, ___, kAI, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kB5, ___, kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG, ___, kBI, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kC5, kC6, kC7, ___, ___, ___, ___, ___, kCD, ___, kCF, kCG, ___, kCI, kCJ, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ } \
}

#define LAYOUT_iso( \
    k00, k01, k02, k03, k04, k10, k11, k12, k13, k20, k21, k22, k23, k24,   k3K, k3L, k3M, \
    k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I,   k4K, k4L, k4M, \
    k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H,        k5K, k5L, k5M, \
    kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG, kAI, k9J, \
    kB5, kB6, kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG,      kBI,        k6O, \
    kC5, kC6, kC7,                kCD,                kCF, kCG, kCI, kCJ,   k7N, k7O, k7P \
) { \
    { k00, k01, k02, k03, k04, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k10, k11, k12, k13, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k20, k21, k22, k23, k24, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k3K, k3L, k3M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k4K, k4L, k4M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k5K, k5L, k5M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k6O, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k7N, k7O, k7P }, \
    { ___, ___, ___, ___, ___, k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H, ___, k9J, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG, ___, kAI, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kB5, kB6, kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG, ___, kBI, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kC5, kC6, kC7, ___, ___, ___, ___, ___, kCD, ___, kCF, kCG, ___, kCI, kCJ, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ } \
}

#define LAYOUT_jis( \
    k00, k01, k02, k03, k04, k10, k11, k12, k13, k20, k21, k22, k23, k24,        k3K, k3L, k3M, \
    k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I, k8J,   k4K, k4L, k4M, \
    k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H,             k5K, k5L, k5M, \
    kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG, kAI, k9J, \
    kB5,      kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG, kBI, kBJ,             k6O, \
    kC5, kC6, kC7, kC8, kC9,           kCD,      kCE, kCF, kCG, kCI, kCJ,        k7N, k7O, k7P \
) { \
    { k00, k01, k02, k03, k04, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k10, k11, k12, k13, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k20, k21, k22, k23, k24, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k3K, k3L, k3M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k4K, k4L, k4M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k5K, k5L, k5M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k6O, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k7N, k7O, k7P }, \
    { ___, ___, ___, ___, ___, k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I, k8J, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H, ___, k9J, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG, ___, kAI, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kB5, ___, kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG, ___, kBI, kBJ, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kC5, kC6, kC7, kC8, kC9, ___, ___, ___, kCD, kCE, kCF, kCG, ___, kCI, kCJ, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ } \
}

#define LAYOUT_all( \
    k00, k01, k02, k03, k04, k10, k11, k12, k13, k20, k21, k22, k23, k24,        k3K, k3L, k3M, \
    k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I, k8J,   k4K, k4L, k4M, \
    k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H, k9J,        k5K, k5L, k5M, \
    kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG,      kAI, \
    kB5, kB6, kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG, kBI, kBJ,             k6O, \
    kC5, kC6, kC7,           kC8, kC9, kCD,      kCE, kCF, kCG, kCI, kCJ,        k7N, k7O, k7P, \
    kD0, kD1 \
) { \
    { k00, k01, k02, k03, k04, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k10, k11, k12, k13, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { k20, k21, k22, k23, k24, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k3K, k3L, k3M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k4K, k4L, k4M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k5K, k5L, k5M, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k6O, ___ }, \
    { ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, k7N, k7O, k7P }, \
    { ___, ___, ___, ___, ___, k85, k86, k87, k88, k89, k8A, k8B, k8C, k8D, k8E, k8F, k8G, k8H, k8I, k8J, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, k95, k96, k97, k98, k99, k9A, k9B, k9C, k9D, k9E, k9F, k9G, k9H, ___, k9J, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kA5, kA6, kA7, kA8, kA9, kAA, kAB, kAC, kAD, kAE, kAF, kAG, ___, kAI, ___, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kB5, kB6, kB7, kB8, kB9, kBA, kBB, kBC, kBD, kBE, kBF, kBG, ___, kBI, kBJ, ___, ___, ___, ___, ___, ___ }, \
    { ___, ___, ___, ___, ___, kC5, kC6, kC7, kC8, kC9, ___, ___, ___, kCD, kCE, kCF, kCG, ___, kCI, kCJ, ___, ___, ___, ___, ___, ___ }, \
    { kD0, kD1, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___, ___ } \
}
