# Xyverz's Sol Layout
## Layout

### Base modifier layout
```
   * ,------------------------------------------------.  ,------------------------------------------------.
   * | ESC  |      |      |      |      |      |   -  |  |   =  |      |      |      |      |      |   \  |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * | Tab  |      |      |      |      |      |   [  |  |   ]  |      |      |      |      |      |   /  |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * | Del  |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |Shift |      |      |      |      |      |      |  |      |      |      |      |      |      |Shift |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * | Adj  | Alt  |   `  | Left | Rght | Ctrl | Alt  |  | Alt  | Ctrl |  Up  | Down |   /  |   =  | Adj  |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------'
   *                                    | BkSp | Win  |  | Enter| Space|
   *                                    `-------------'  `-------------'
```

### Qwerty alphas
```
   * ,------------------------------------------------.  ,------------------------------------------------.
   * |      |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |   Q  |   W  |   E  |   R  |   T  |      |  |      |   Y  |   U  |   I  |   O  |   P  |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |   A  |   S  |   D  |   F  |   G  |      |  |      |   H  |   J  |   K  |   L  |   ;  |   '  |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |   Z  |   X  |   C  |   V  |   B  |      |  |      |   N  |   M  |   ,  |   .  |   /  |      |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * `------+------+------+------+------+------+------|  |------+------+------+------+------+------+------'
   *                                    |      |      |  |      |      |
   *                                    `-------------'  `-------------'
```

### Dvorak alphas
```
   * ,------------------------------------------------.  ,------------------------------------------------.
   * |      |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |   "  |   ,  |   .  |   P  |   Y  |      |  |      |   F  |   G  |   C  |   R  |   L  |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |   A  |   O  |   E  |   U  |   I  |      |  |      |   D  |   H  |   T  |   N  |   S  |   -  |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |   ;  |   Q  |   J  |   K  |   X  |      |  |      |   B  |   M  |   W  |   V  |   Z  |      |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * `------+------+------+------+------+------+------|  |------+------+------+------+------+------+------'
   *                                    |      |      |  |      |      |
   *                                    `-------------'  `--------=----'
```
### Colemak alphas
```
   * ,------------------------------------------------.  ,------------------------------------------------.
   * |      |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |   Q  |   W  |   F  |   P  |   B  |      |  |      |   J  |   L  |   U  |   Y  |   ;  |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |   A  |   R  |   S  |   T  |   G  |      |  |      |   K  |   N  |   E  |   I  |   O  |   '  |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |   Z  |   X  |   C  |   D  |   V  |      |  |      |   M  |   H  |   ,  |   .  |   /  |      |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |      |      |      |      |      |      |  |      |      |      |      |      |      |      |
   * `------+------+------+------+------+------+------|  |------+------+------+------+------+------+------'
   *                                    |      |      |  |      |      |
   *                                    `-------------'  `-------------'
```

### Adjust (ADJ)
```
   * ,------------------------------------------------.  ,------------------------------------------------.
   * |  F11 |  F1  |  F2  |  F3  |  F4  |  F5  | RESET|  |      |  F6  |  F7  |  F8  |  F9  |  F10 |  F12 |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |      |QWERTY|DVORAK|COLEMK|      |      |  |      |      | PrSc | ScLk | NmLk |      |      |
   * |------+------+------+------+------+------|------|  |------|------+------+------+------+------+------|
   * |      |      | Mute | Vol- | Vol+ |      |      |  |      |RGBTOG|RGBMOD|  HUI |  SAI | VAI  |      |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |      | Prev | Play | Next |      |      |  |      |      |RGBRMD|  HUD |  SAD | VAD  |      |
   * |------+------+------+------+------+------+------|  |------+------+------+------+------+------+------|
   * |      |      |      | Home | End  |      |      |  |      |      | PgUp | PgDn |      |      |      |
   * `------+------+------+------+------+------+------|  |------+------+------+------+------+------+------'
   *                                    | Del  |      |  |      | Ins  |
   *                                    `-------------'  `-------------'
```

## Customize

see `qmk_firmware/keyboards/sol/rev1/keymaps/default/rules.mk`

```

# Variables you can set for SOL

BOOTMAGIC_ENABLE = no       # Enable Bootmagic Lite
MOUSEKEY_ENABLE = no        # Mouse keys
EXTRAKEY_ENABLE = yes       # Audio control and System control
CONSOLE_ENABLE = no         # Console for debug
COMMAND_ENABLE = ne         # Commands for debug and configuration
NKRO_ENABLE = yes           # Nkey Rollover - if this doesn't work, see here: https://github.com/tmk/tmk_keyboard/wiki/FAQ#nkro-doesnt-work
RGBLIGHT_ENABLE = yes       # Enable global lighting effects. Do not enable with RGB Matrix
LED_ANIMATIONS = yes        # LED animations
LED_MIRRORED = no           # Mirror LEDs across halves (enable DIP 1 on slave, and DIP 2 and 3 on master)
RGB_MATRIX_ENABLE = no      # Enable per-key coordinate based RGB effects. Do not enable with RGBlight
RGB_MATRIX_KEYPRESSES = no  # Enable reactive per-key effects. Can be very laggy
RGBLIGHT_FULL_POWER = no    # Allow maximum RGB brightness. Otherwise, limited to a safe level for a normal USB-A port
UNICODE_ENABLE = no         # Unicode
SWAP_HANDS_ENABLE = no      # Enable one-hand typing
ENCODER_ENABLE_CUSTOM = yes # Enable rotary encoder

OLED_ENABLE = yes           # OLED_ENABLE
IOS_DEVICE_ENABLE = no      # Limit max brightness to connect to IOS device (iPad,iPhone)


```
## Compile

go to qmk top directory.
```
$ cd qmk_firmware
```

build
```
$ make sol:xyverz
```

After the initial flash with AVRdudess, you should be able to flash using this:
```
$ make sol:xyverz:flash
```
