# Mattir's keymap & configs for [Kyria](https://github.com/splitkb/kyria)

## Keymap

This is my customized keymap and layer setup for my second Kyria split keyboard. It's based largely on the defaults, but with several things moved to new layers. Keys in the diagrams below that are blank are "transparent" and they drop down to the lowest layer that has them defined.

The PCBs for the Kyria are rev. 1.3
Each half uses an Elite-C low-profile (rev 4) microcontroller with USB-C connector
The boards are outfitted with Kailh Choc Jade switches and MBK keycaps

Unlike my first build, this is a minimal build with no encoders, RGB LEDs, or OLED displays.

### Base layer `QWERTY`

```
,-------------------------------------------.                              ,-------------------------------------------.
| Esc    |   Q  |   W  |   E  |   R  |   T  |                              |   Y  |   U  |   I  |   O  |   P  |  \ |   |
|--------+------+------+------+------+------|                              |------+------+------+------+------+--------|
| Tab    |   A  |   S  |  D   |   F  |   G  |                              |   H  |   J  |   K  |   L  | ;  : |  ' "   |
|--------+------+------+------+------+------+-------------.  ,-------------+------+------+------+------+------+--------|
| Leader |   Z  |   X  |   C  |   V  |   B  | Shft | ` ~  |  | L3   | Shft |   N  |   M  | ,  < | . >  | /  ? |  - _   |
`----------------------+------+------+------+------|------|  |------|------+------+------+------+----------------------'
                       | Shft | Alt  | Supr |L1/Spc|L2/Ent|  |L2/Ent|L1/Spc| Bksp |  Alt | Shft |
                       `----------------------------------'  `----------------------------------'
```

### Symbols layer `LOWER`

```
,-------------------------------------------.                              ,-------------------------------------------.
|        |  !   |  @   |  #   |  {   |  }   |                              |      |      |      |      |      |        |
|--------+------+------+------+------+------|                              |------+------+------+------+------+--------|
|        |  $   |  %   |  ^   |  (   |  )   |                              |   =  |  +   |  -   |  *   |  /   |        |
|--------+------+------+------+------+------+-------------.  ,-------------+------+------+------+------+------+--------|
|        |  &   |      |      |  [   |  ]   |      |      |  |      |      |      |      |      |      |      |        |
`----------------------+------+------+------+------|------|  |------|------+------+------+------+----------------------'
                       |      |      |      |      |      |  |      |      |      |      |      |
                       `----------------------------------'  `----------------------------------'
```

### Numbers and mouse-keys layer `RAISE`

```
,-------------------------------------------.                              ,-------------------------------------------.
|        |   1  |  2   |  3   |  4   |  5   |                              |  6   |  7   |  8   |  9   |  0   |        |
|--------+------+------+------+------+------|                              |------+------+------+------+------+--------|
| Vol Up |      | LMsB | MMsB | RMsB | MW Up|                              | Left | Down | Up   | Right|Bri Up|        |
|--------+------+------+------+------+------+-------------.  ,-------------+------+------+------+------+------+--------|
| Vol Dn | Mute | Prev | Play | Next | MW Dn| MW L | MW R |  |      |      | MLeft| Mdown| MUp  |MRight|Bri Dn|        |
`----------------------+------+------+------+------|------|  |------|------+------+------+------+----------------------'
                       |      |      |      |      |      |  |      |      | Del  |      |      |
                       `----------------------------------'  `----------------------------------'
```

### F-Keys and number-pad layer `FUNCS`

```
,-------------------------------------------.                              ,-------------------------------------------.
|        | F1   |  F2  | F3   | F4   | F5   |                              | np + | np 7 | np 8 | np 9 | np * |        |
|--------+------+------+------+------+------|                              |------+------+------+------+------+--------|
|        | F6   |  F7  | F8   | F9   | F10  |                              | np - | np 4 | np 5 | np 6 | np / |  =     |
|--------+------+------+------+------+------+-------------.  ,-------------+------+------+------+------+------+--------|
|        | F11  |  F12 |      |      |      |      |      |  |      |      | np 0 | np 1 | np 2 | np 3 | np . |  Enter |
`----------------------+------+------+------+------|      |  |      |------+------+------+------+----------------------'
                       |      |      |      |      |      |  |      |      |      |      |      |
                       `----------------------------------'  `----------------------------------'
```
