# Splitography

![Splitography](https://i.imgur.com/NlmR4Gc.jpeg)

A *pay what you will* compact keyboard intended for use with [Plover](https://www.openstenoproject.org/), free and open source stenography software. This is a low-cost keyboard with minimal packaging and design, and arrives fully assembled, ready to use.

* Keyboard Maintainer: [The QMK Community](https://github.com/qmk)
* Hardware Supported: Splitography
* Hardware Availability: [softhruf.love](https://softhruf.love/collections/writers)

Make example for this keyboard (after setting up your build environment):

    make splitography:default

Flashing example for this keyboard:

    make splitography:default:flash

See the [build environment setup](https://docs.qmk.fm/#/getting_started_build_tools) and the [make instructions](https://docs.qmk.fm/#/getting_started_make_guide) for more information. Brand new to QMK? Start with our [Complete Newbs Guide](https://docs.qmk.fm/#/newbs).

## Bootloader

Enter the bootloader in 3 ways:

* **Bootmagic reset**: Hold down the key at (0,0) in the matrix (usually the top left key or Escape) and plug in the keyboard.
* **Physical reset button**: Briefly press the button on the back of the PCB.
* **Keycode in layout**: Press the key mapped to `QK_BOOT` if it is available.

## [Guide](https://softhruf.love/pages/guides)

[Splitography quick start video](https://www.youtube.com/watch?v=ru4cRQ2s_v0)

A short video guide on how to set up the SOFT/HRUF Splitography, a mechanical keyboard intended for use with [Plover](https://www.openstenoproject.org/plover/).

Here is a reference card for the standard keyboard layout:

![Reference card](https://i.imgur.com/ywe8jXR.png)

* While holding down a colored thumb key, the matching colored functions/characters on the remaining keys can be pressed.
* Bottom edge keys are accessed by holding down both keys.
* Numlock locks in the Numpad layer.
* Alt and Shift pressed simultaneously to return to the standard layout.
