/* Copyright 2021 Studio Kestra
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "quantum.h"

#define ___ KC_NO

/*
 *              ┌───┐   ┌───┬───┬───┬───┐ ┌───┬───┬───┬───┐ ┌───┬───┬───┬───┐ ┌───┬───┬───┐
 *              │00 │   │01 │02 │12 │03 │ │13 │04 │14 │05 │ │15 │06 │16 │07 │ │17 │08 │18 │ Standard
 *              └───┘   └───┴───┴───┴───┘ └───┴───┴───┴───┘ └───┴───┴───┴───┘ └───┴───┴───┘
 *              ┌───┐┌───┬───┬───┬───┐┌───┬───┬───┬───┐┌───┬───┬───┬───┐┌───┐ ┌───┬───┬───┐
 *              │00 ││10 │01 │02 │12 ││03 │13 │04 │14 ││05 │15 │06 │16 ││07 │ │17 │08 │18 │ F13
 *              └───┘└───┴───┴───┴───┘└───┴───┴───┴───┘└───┴───┴───┴───┘└───┘ └───┴───┴───┘
 *              ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┐ ┌───┬───┬───┐      ┌───────┐
 *              │20 │30 │21 │31 │22 │32 │23 │33 │24 │34 │25 │35 │26 │36 │27 │ │37 │28 │38 │      │36     │ 2u Backspace
 *              ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┤ ├───┼───┼───┤      └─┬─────┤
 *              │40   │50 │41 │51 │42 │52 │43 │53 │44 │54 │45 │55 │46 │47   │ │57 │48 │58 │        │     │
 *  2.25u       ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤ └───┴───┴───┘     ┌──┴┐47  │ ISO Enter
 *  LShift      │60    │70 │61 │71 │62 │72 │63 │73 │64 │74 │65 │75 │66      │                   │66 │    │
 * ┌────────┐   ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┤     ┌───┐       ┌─┴───┴────┤
 * │80      │   │80  │90 │81 │91 │82 │92 │83 │93 │84 │94 │85 │95 │86    │87 │     │88 │       │86        │ 2.75u RShift
 * └────────┘   ├────┼───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬┴───┤ ┌───┼───┼───┐   └──────────┘
 *              │A0  │B0  │A1  │A3                      │A5  │B5  │A6  │A7  │ │B7 │A8 │B8 │
 *              └────┴────┴────┴────────────────────────┴────┴────┴────┴────┘ └───┴───┴───┘
 *              ┌─────┬───┬─────┬───────────────────────────┬─────┬───┬─────┐
 *              │A0   │B0 │A1   │A3                         │B5   │A6 │A7   │ Tsangan/WKL
 *              └─────┴───┴─────┴───────────────────────────┴─────┴───┴─────┘
 *              ┌────┬────┬───────────────────────────────────────┬────┬────┐
 *              │A0  │B0  │A3                                     │A6  │A7  │ WK 10u Space
 *              └────┴────┴───────────────────────────────────────┴────┴────┘
 *              ┌─────┐   ┌───────────────────────────────────────┐   ┌─────┐
 *              │A0   │   │A3                                     │   │A7   │ WKL 10u Space
 *              └─────┘   └───────────────────────────────────────┘   └─────┘
 */

#define LAYOUT_all(\
    k00, k10,      k01, k02, k12, k03, k13, k04, k14, k05, k15, k06, k16, k07,   k17, k08, k18, \
    k20, k30, k21, k31, k22, k32, k23, k33, k24, k34, k25, k35, k26, k36, k27,   k37, k28, k38, \
    k40, k50, k41, k51, k42, k52, k43, k53, k44, k54, k45, k55, k46,      k47,   k57, k48, k58, \
    k60, k70, k61, k71, k62, k72, k63, k73, k64, k74, k65, k75, k66,                            \
    k80, k90, k81, k91, k82, k92, k83, k93, k84, k94, k85, k95, k86,      k87,        k88,      \
    kA0, kB0, kA1,                kA3,                     kA5, kB5, kA6, kA7,   kB7, kA8, kB8  \
) { \
    { k00, k01, k02, k03, k04, k05, k06, k07, k08 }, \
    { k10, ___, k12, k13, k14, k15, k16, k17, k18 }, \
    { k20, k21, k22, k23, k24, k25, k26, k27, k28 }, \
    { k30, k31, k32, k33, k34, k35, k36, k37, k38 }, \
    { k40, k41, k42, k43, k44, k45, k46, k47, k48 }, \
    { k50, k51, k52, k53, k54, k55, ___, k57, k58 }, \
    { k60, k61, k62, k63, k64, k65, k66, ___, ___ }, \
    { k70, k71, k72, k73, k74, k75, ___, ___, ___ }, \
    { k80, k81, k82, k83, k84, k85, k86, k87, k88 }, \
    { k90, k91, k92, k93, k94, k95, ___, ___, ___ }, \
    { kA0, kA1, ___, kA3, ___, kA5, kA6, kA7, kA8 }, \
    { kB0, ___, ___, ___, ___, kB5, ___, kB7, kB8 }  \
}

#define LAYOUT_tkl_f13_ansi(\
    k00, k10, k01, k02, k12, k03, k13, k04, k14, k05, k15, k06, k16, k07,   k17, k08, k18, \
    k20, k30, k21, k31, k22, k32, k23, k33, k24, k34, k25, k35, k26, k36,   k37, k28, k38, \
    k40, k50, k41, k51, k42, k52, k43, k53, k44, k54, k45, k55, k46, k47,   k57, k48, k58, \
    k60, k70, k61, k71, k62, k72, k63, k73, k64, k74, k65, k75,      k66,                  \
    k80,      k81, k91, k82, k92, k83, k93, k84, k94, k85, k95,      k86,        k88,      \
    kA0, kB0, kA1,                kA3,                kA5, kB5, kA6, kA7,   kB7, kA8, kB8  \
) { \
    { k00, k01, k02, k03, k04, k05, k06, k07, k08 }, \
    { k10, ___, k12, k13, k14, k15, k16, k17, k18 }, \
    { k20, k21, k22, k23, k24, k25, k26, ___, k28 }, \
    { k30, k31, k32, k33, k34, k35, k36, k37, k38 }, \
    { k40, k41, k42, k43, k44, k45, k46, k47, k48 }, \
    { k50, k51, k52, k53, k54, k55, ___, k57, k58 }, \
    { k60, k61, k62, k63, k64, k65, k66, ___, ___ }, \
    { k70, k71, k72, k73, k74, k75, ___, ___, ___ }, \
    { k80, k81, k82, k83, k84, k85, k86, ___, k88 }, \
    { ___, k91, k92, k93, k94, k95, ___, ___, ___ }, \
    { kA0, kA1, ___, kA3, ___, kA5, kA6, kA7, kA8 }, \
    { kB0, ___, ___, ___, ___, kB5, ___, kB7, kB8 }  \
}

#define LAYOUT_tkl_f13_iso(\
    k00, k10, k01, k02, k12, k03, k13, k04, k14, k05, k15, k06, k16, k07,   k17, k08, k18, \
    k20, k30, k21, k31, k22, k32, k23, k33, k24, k34, k25, k35, k26, k36,   k37, k28, k38, \
    k40, k50, k41, k51, k42, k52, k43, k53, k44, k54, k45, k55, k46,        k57, k48, k58, \
    k60, k70, k61, k71, k62, k72, k63, k73, k64, k74, k65, k75, k66, k47,                  \
    k80, k90, k81, k91, k82, k92, k83, k93, k84, k94, k85, k95,      k86,        k88,      \
    kA0, kB0, kA1,                kA3,                kA5, kB5, kA6, kA7,   kB7, kA8, kB8  \
) { \
    { k00, k01, k02, k03, k04, k05, k06, k07, k08 }, \
    { k10, ___, k12, k13, k14, k15, k16, k17, k18 }, \
    { k20, k21, k22, k23, k24, k25, k26, ___, k28 }, \
    { k30, k31, k32, k33, k34, k35, k36, k37, k38 }, \
    { k40, k41, k42, k43, k44, k45, k46, k47, k48 }, \
    { k50, k51, k52, k53, k54, k55, ___, k57, k58 }, \
    { k60, k61, k62, k63, k64, k65, k66, ___, ___ }, \
    { k70, k71, k72, k73, k74, k75, ___, ___, ___ }, \
    { k80, k81, k82, k83, k84, k85, k86, ___, k88 }, \
    { k90, k91, k92, k93, k94, k95, ___, ___, ___ }, \
    { kA0, kA1, ___, kA3, ___, kA5, kA6, kA7, kA8 }, \
    { kB0, ___, ___, ___, ___, kB5, ___, kB7, kB8 }  \
}
