// Copyright 2021 Henry Lum (@suavity)
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "quantum.h"
#define ___ KC_NO

/*
 *              ┌───┐┌───┬───┬───┬───┐┌───┐        ┌───┬───┬───┬───┐┌───┬───┬───┬───┐┌───┬───┬───┐
 *              │00 ││01 │02 │03 │04 ││05 │        │06 │07 │08 │09 ││0A │0B │0C │0D ││0E │0F │0G │
 *              └───┘└───┴───┴───┴───┘└───┘        └───┴───┴───┴───┘└───┴───┴───┴───┘└───┴───┴───┘
 *              ┌───┬───┬───┬───┬───┬───┬───┐       ┌───┬───┬───┬───┬───┬───┬───┬───┐┌───┬───┬───┐      ┌───────┐
 *              │10 │11 │12 │13 │14 │15 │16 │       │17 │18 │19 │1A │1B │1C │1D │3E ││1E │1F │1G │      │3E     │ 2u Backspace
 *              ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┘     ┌─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴───┤├───┼───┼───┤      └─┬─────┤
 *              │20   │21 │22 │23 │24 │25 │       │26 │27 │28 │29 │2A │2B │2C │2D   ││2E │2F │2G │        │     │
 *  2.25u       ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┐      └┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤└───┴───┴───┘     ┌──┴┐3D  │ ISO Enter
 *  LShift      │30    │31 │32 │33 │34 │35 │       │36 │37 │38 │39 │3A │3B │3C      │                  │3C │    │
 * ┌────────┐   ├────┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┐   ┌─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────┬───┤    ┌───┐       ┌─┴───┴────┤
 * │40      │   │40  │41 │42 │43 │44 │45 │46 │   │47 │48 │49 │4A │4B │4C │4D    │4E │    │4F │       │4D        │ 2.75u RShift
 * └────────┘   ├────┴┬──┴─┬─┴───┼───┼───┴───┤   ├───┴───┴───┼───┴─┬─┴─┬─┴──┬───┴─┬─┘┌───┼───┼───┐   └──────────┘
 *              │50   │    │53   │54 │55     │   │58         │5A   │5C │    │5D   │  │5E │5F │5G │
 *              └─────┘    └─────┴───┴───────┘   └───────────┴─────┴───┘    └─────┘  └───┴───┴───┘
 *                               ┌───────────┐   ┌──────────┬─────┬────┐
 *                     3u LSpace │55         │   │58        │5A   │5C  │ 2.75u/1.5u/1.25u
 *                               └───────────┘   └──────────┴─────┴────┘
 */

#define LAYOUT_all( \
    K00, K01, K02, K03, K04, K05,        K06, K07, K08, K09, K0A, K0B, K0C, K0D,   K0E, K0F, K0G, \
    K10, K11, K12, K13, K14, K15, K16,   K17, K18, K19, K1A, K1B, K1C, K1D, K3E,   K1E, K1F, K1G, \
    K20, K21, K22, K23, K24, K25,        K26, K27, K28, K29, K2A, K2B, K2C, K2D,   K2E, K2F, K2G, \
    K30, K31, K32, K33, K34, K35,        K36, K37, K38, K39, K3A, K3B, K3C, K3D,                  \
    K40, K41, K42, K43, K44, K45, K46,   K47, K48, K49, K4A, K4B, K4C, K4D, K4E,        K4F,      \
    K50,           K53, K54,      K55,   K58,           K5A, K5C,           K5D,   K5E, K5F, K5G  \
) { \
    { K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K0F, K0G, }, \
    { K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E, K1F, K1G, }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K2D, K2E, K2F, K2G, }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E, ___, ___, }, \
    { K40, K41, K42, K43, K44, K45, K46, K47, K48, K49, K4A, K4B, K4C, K4D, K4E, K4F, ___, }, \
    { K50, ___, ___, K53, K54, K55, ___, ___, K58, ___, K5A, ___, K5C, K5D, K5E, K5F, K5G, }  \
}

#define LAYOUT_ansi_split_bs_rshift_lspace( \
    K00, K01, K02, K03, K04, K05,        K06, K07, K08, K09, K0A, K0B, K0C, K0D,   K0E, K0F, K0G, \
    K10, K11, K12, K13, K14, K15, K16,   K17, K18, K19, K1A, K1B, K1C, K1D, K3E,   K1E, K1F, K1G, \
    K20, K21, K22, K23, K24, K25,        K26, K27, K28, K29, K2A, K2B, K2C, K2D,   K2E, K2F, K2G, \
    K30, K31, K32, K33, K34, K35,        K36, K37, K38, K39, K3A, K3B,      K3C,                  \
    K40,      K42, K43, K44, K45, K46,   K47, K48, K49, K4A, K4B, K4C, K4D, K4E,        K4F,      \
    K50,           K53, K54,      K55,   K58,           K5A, K5C,           K5D,   K5E, K5F, K5G  \
) { \
    { K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K0F, K0G }, \
    { K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E, K1F, K1G }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K2D, K2E, K2F, K2G }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, ___, K3E, ___, ___ }, \
    { K40, ___, K42, K43, K44, K45, K46, K47, K48, K49, K4A, K4B, K4C, K4D, K4E, K4F, ___ }, \
    { K50, ___, ___, K53, K54, K55, ___, ___, K58, ___, K5A, ___, K5C, K5D, K5E, K5F, K5G }  \
}

#define LAYOUT_iso_split_bs_rshift_lspace( \
    K00, K01, K02, K03, K04, K05,        K06, K07, K08, K09, K0A, K0B, K0C, K0D,   K0E, K0F, K0G, \
    K10, K11, K12, K13, K14, K15, K16,   K17, K18, K19, K1A, K1B, K1C, K1D, K3E,   K1E, K1F, K1G, \
    K20, K21, K22, K23, K24, K25,        K26, K27, K28, K29, K2A, K2B, K2C,        K2E, K2F, K2G, \
    K30, K31, K32, K33, K34, K35,        K36, K37, K38, K39, K3A, K3B, K3C, K3D,                  \
    K40, K41, K42, K43, K44, K45, K46,   K47, K48, K49, K4A, K4B, K4C, K4D, K4E,        K4F,      \
    K50,           K53, K54,      K55,   K58,           K5A, K5C,           K5D,   K5E, K5F, K5G  \
) { \
    { K00, K01, K02, K03, K04, K05, K06, K07, K08, K09, K0A, K0B, K0C, K0D, K0E, K0F, K0G }, \
    { K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E, K1F, K1G }, \
    { K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, ___, K2E, K2F, K2G }, \
    { K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3D, K3E, ___, ___ }, \
    { K40, K41, K42, K43, K44, K45, K46, K47, K48, K49, K4A, K4B, K4C, K4D, K4E, K4F, ___ }, \
    { K50, ___, ___, K53, K54, K55, ___, ___, K58, ___, K5A, ___, K5C, K5D, K5E, K5F, K5G }  \
}
