// Copyright 2022 takashicompany (@takashicompany)
// SPDX-License-Identifier: GPL-2.0-or-later

#include "minizone.h"

#ifdef OLED_ENABLE

oled_rotation_t oled_init_kb(oled_rotation_t rotation) {
    return OLED_ROTATION_270;
}

//Variable that stores the number of times the key was pressed
static uint16_t press_count = 0;

bool process_record_kb(uint16_t keycode, keyrecord_t *record) {

     // Increment the counter when a key is pressed
    if (record->event.pressed) {
        press_count++;
    }

    return process_record_user(keycode, record);
}

bool oled_task_kb(void) {

    if (!oled_task_user()) { return false; }

    static const char PROGMEM my_logo[] = {
        0x00, 0x00, 0x00, 0xf0, 0xf0, 0x30, 0x30, 0xf0, 0xe0, 0x30, 0x30, 0xf0, 0xe0, 0x00, 0x00, 0xf6, 
        0xf6, 0x00, 0x00, 0xf0, 0xf0, 0x20, 0x30, 0x30, 0xf0, 0xe0, 0x00, 0x00, 0xf6, 0xf6, 0x00, 0x00, 
        0x00, 0xc0, 0x40, 0x4f, 0x4f, 0x40, 0x40, 0x4f, 0x4f, 0xc0, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x0f, 
        0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 
        0x00, 0x03, 0xc2, 0x32, 0x0e, 0x82, 0x60, 0x18, 0x06, 0x03, 0xc0, 0xe0, 0x30, 0x30, 0x30, 0xe0, 
        0xc0, 0x00, 0xf0, 0xf0, 0x20, 0x30, 0x30, 0xf0, 0xe0, 0x00, 0xc0, 0xe0, 0xb0, 0xb0, 0xe0, 0xc0, 
        0x1e, 0x13, 0x10, 0x10, 0x12, 0x13, 0x12, 0x12, 0x12, 0x1c, 0x03, 0x07, 0x0c, 0x0c, 0x0c, 0x07, 
        0x03, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x03, 0x07, 0x0d, 0x0d, 0x0d, 0x09
    };

    oled_write_raw_P(my_logo, sizeof(my_logo));
    oled_set_cursor(0, 5);

    oled_write_ln_P(PSTR("Layer"), false);
    oled_write_ln(get_u8_str(get_highest_layer(layer_state), ' '), false);

    oled_write_ln_P(PSTR(" "), false);
    oled_write_ln_P(PSTR(" "), false);

    oled_write_ln_P(PSTR("Count"), false);
    oled_write_ln(get_u16_str(press_count, ' '), false);

    return false;

}
#endif