# Jetpacktuxedo's minivan layout

This differs quite a bit from the stock layout but leaves keys in a more familiar position in my opinion. It is designed to use the arrow+command layout, but I used a fairly similar layout for the normal arrow layout. Additionally, I use an mx lock switch on the key between the right space key and the arrow cluster. If you don't want to use a lock switch you should change MO(4) on the base layer to use TG(4) instead for a similar effect.

## Base Layer (0)

The base layer is pretty simple, straight qwerty layout where available. Of note: /? is to the right of the arrow keys. Yes this is kinda weird sometimes, but you get used to it. Tab is tab when pressed and fn2 when held, Enter is the same. GESC is esc when used alone, but ~ when shifted. Tapping FN 1 is space
```
|GESC| Q  | W  | E  | R  | T  | Y  | U  | I  | O  | P  | BSPC |
| TAB | A  | S  | D  | F  | G  | H  | J  | K  | L  | ;  |ENTER|
|SHIFT | Z  | X  | C  | V  | B  | N  | M  | ,  | .  | UP | /  |
|CTRL|WIN |ALT |FN 3|   FN 1   |  SPACE | FN 4 |LEFT|DOWN|RIGH|
```
## Numeric Layer (1)

This layer has the numrow as well as swapping the arrow keys for a nav cluster, and swapping ;: for '" and /? for \|. With that almost all of the missing keys are accounted for.
```
| `  | 1  | 2  | 3  | 4  | 5  | 6  | 7  | 8  | 9  | 0  |  DEL |
|     |    |    |    |    |    |    |    | -  | =  | '  |     |
|      |    |    |    |    |    |    |    | [  |  ] |PGUP| \  |
|    |    |    |    |          |        |      |HOME|PGDN|END |
```
## Symbolic Layer (2)

I don't want to be using two key combos constantly, so I also added this symbol layer that is basically shift+numeric layer
```
| ~  | !  | @  | #  | $  | %  | ^  | &  | *  | (  | )  |  DEL |
|     |    |    |    |    |    |    |    | _  | +  | "  |     |
|      |    |    |    |    |    |    |    | {  |  } |PGUP| |  |
|    |    |    |    |          |        |      |HOME|PGDN|END |
```
## Fkeys (3)

I very rarely use Fkeys, but figured I'd throw them on anyway just in case. The setup basically mimics the way Fkeys are usually done on a 60%, with F11 and F12 still on - and =, even though the location of those keys has moved.
```
|    | F1 | F2 | F3 | F4 | F5 | F6 | F7 | F8 | F9 |F10 |      |
|     |    |    |    |    |    |    |    |F11 |F12 |    |     |
|      |    |    |    |    |    |    |    |    |    |    |    |
|    |    |    |    |          |        |      |    |    |    |
```
## Gaming Layer (4)

Originally this was just going to be a gaming layer (make esc just esc, make tab just tab, move space to the left side), but I ended up in a hotel without a usb mouse, so I added mousekeys to it as well.
```
|ESC |    |    |    |    |    |MWUP|MRCK|M_UP|MLCK|    |      |
| TAB |    |    |    |    |    |MWDN|M_LF|M_DN|M_RG|    |     |
|      |    |    |    |    |    |    |    |    |    |    |    |
|    |    |    |    |   SPACE  |        |      |    |    |    |
```
