# Minifan layout

Compiled for: Qwerty
====================

This file details the compile version `#define BASE_QWERTY__DEF_BASE, BASE_QWERTY__ALT_BASE`.
This is a Qwerty layout.

Dual layout combination with Qwerty Base Arrow
==============================================
⚠ If you also compile `base_qwerty_basearrow`, the key for `/?` on `_NSY` layer in that
`base_qwerty_basearrow` layout, will be replicated in _this_ Qwerty layout on the `_NSY`
layer. It will displace the key `RCTL_T ( KC_GRV )`. Right Control, unless tapped for
‛\`’ or tapped with shift for ‛~’ ➡ becomes `/?` (slash/questionmark). 

The reason for this is that when you switch from one or the other Qwerty variation
(with or without arrows on ‛Base’ layer), it will likely be confusing to type ‛/?’
on that key in one version of Qwerty, and suddenly get a ‛\`~’ in the other. The reason
it is not in the normal position on ‛Qwerty Base Arrow’, is because it gets displaced
by ‛Up Arrow’. 

You will likely switch from the Base Arrow variation to the regular version, due to a need
for the row of keys displaced by the arrow cluster, or the other way around to get Base
access to the arrows, rather than a need for this side effect: ‛/?’ being substituted for
‛\`~’.

This means you will loose `_NSY` layer access to ‛\`’, in both versions of Qwerty. You will
 have to use the key for ‛\`~’ on the `_BON` layer, which is an uncluttered version of this 
key (it repeats). It also means that you have two keys toward ‛/?’ in standard Qwerty: the
default position for Qwerty, and this additional one to harmonize with ‛Qwerty Base Arrow’.

This harmonization can be disabled in ![./base_qwerty_basearrow.h](./base_qwerty_basearrow.h),
with `QWERTY_BASEARROW_HARMONIZE`.

See also: ![./base_qwerty_basearrow.md](./base_qwerty_basearrow.md)

Qwerty keymaps
--------------

──────────Qwerty───────────────

![Minivan layout Image BASEdef](http://socialism.nl/misc/minivan/minivan_base_layer_qwerty_ve.jpg)
Layer: `..._BASE`

![Minivan layout Image BASEdef](http://socialism.nl/misc/minivan/minivan_nsy_layer_qwerty_vc.jpg)
Layer: `..._NSY`

──────────in common────────────

(…)

For more about the other layers, see ➡ ![readme.md](./readme.md) ⬅

![Minivan illustration Overview layers by key, Qwerty](http://socialism.nl/misc/minivan/minivan-all-layers-clear-visualization-by-key_qwerty_2000_vi.jpg)

Layers (text)
=============

        ───────────────Qwerty─────────────────

         Layer _..._BASE (Letters). This is standard Qwerty 
                                                  | Right hand
         <pink2     <pinky<ring <middl<index<indx2| indx2>index>middl>ring> pinky>pinky2>   // Keys by finger
         -o-                                     <|>                                    ... //-o- BASE access
         Esc        qQ    wW    eE    rR    tT    | yY    uU    iI    oO    pP         Bksp
         Tab+LCtl   aA    sS    dD    fF    gG    | hH    jJ    kK    lL    ;:           '"
         LSht+_PAD  zZ    xX    cC    vV    bB    | nN    mM    ,<    .>    /?    RSht+_FUN
             +_MOV⁵                               |                                   +_RAR⁶
     ---------------------------------------------------------------------------------------
     Left+LAlt Del;_ACC _DEF_NSY(_DRA)  Enter+_MOV| Space  _DEF_NSY(_DRA) RGUI    Right;_RAR 
               hold     hold₍₁,₂٭₎      hold      |        hold₍₁,₂٭₎             hold     // switch type
               hold₍₂₎  ^-┃-----------------------+--------^ ┃                          // ₁₎ both = _DRA
               ┗━━━_BON━━━╋┅───────────┄┄┄«or»┄┄┄─+─────────┅┛                          // ₂₎ both = _BON
     <1   ±    <2       <3              <4        | 4>     3>             2>   ±  1>    // Keys by number
          ^³                                                                   ^⁴   // Optional more keys
        (LGUI)                                                               (_MOV)

     ₁) Dual hold for _DRA, single hold for _DEF_NSY. Marked by: ^--…--^
     ₂) Hold key “<2” with either٭ key “<3” or “3>” for _BON, single hold “<2” for _ACC. Marked: ┗━━…━━┛
     ₃) 'South paw' hardware configuration. Configurable, default shown.
     ₄) 'Arrow' hardware configuration  Configurable, default shown.
     ₃ ₄) There are two more optional hardware keys, to make it easier to compile for
          a 12x12x12x11 or 12x12x12x12 layouts.
     ₅) Left Shift when pressed with another key. Medium long: to toggle _PAD. Long: toggle _MOV.
     ₆) Right shift when pressed with another key. medium long: to toggle _FUN. Long: toggle _RAR.

Remarks: The left modifiers have a slight delay in combination with an outside pointer device (mouse, stylus).
It seems this will be difficult to fix, because it is spread over two devices. To avoid the
±0.2 second delay, activate a layer where the modifiers are direct (`_PAD`), using the layer toggle on left shift. 

The two keys with ';' (Del;`_ACC`, Right;`_RAR`) do not auto-repeat on double tap, like QMK normal layer-tap keys.
There is an uncluttered _Delete_ on `_PAD`, an uncluttered _Right_ arrow on the `_MOV` layer.

Holding both `_DEF_NSY` keys left and right of the "split space bar" (enter, space) results in layer `_DRA`.

Holding either one of the just above mentioned `_DEF_NSY` layer keys (<3 and 3>), with the `_ACC` layer key
(on <2) results in layer `_BON`.


- - -


     Layer _..._NSY (Numbers and SYmbols). This fits the above Qwerty layer _DEF_BASE
    
     <pink2   <pinky<ring <middl<index<indx2| indx2>index>middl>ring>pin>pink2>
              -*-                          <|>                                  //(toggle) Access on _FUN
     BASE     !     @     #     $     %     | ^     &     *     (    )       Del
     Tab+LCtl 1!    2@    3#    4$    5%    | 6^    7&    8*    9(   0)  `~+RCtl // `~+RCtl becomes /? in dual …
     -+LSht   [{    ]}    -_    \|    =+    | +     |     _     {     }   ~+RSht //  … layout with Qwerty Base Arrow
     ---------------------------------------------------------------------------
                 Left+LAlt ___   ___   Ent  | .   ___   RGUI  Right+RAlt
                                 -*-       <|>    -*-                 u      //(hold) Access on _DEF_BASE
                   <1   ±  <2    <3    <4   | 4>  3>    2>  ± 1>  
                        ^                                   ^
                      (LGUI)                              (_MOV)



- - -

Key associations
----------------
Key placement associations between layers for Qwerty.

![Minivan layout Image associations](http://socialism.nl/misc/minivan/minivan-relationships_qwerty_1500_ve.jpg)


