# BifbofII 60% ISO Layout

![BifbofII 60% ISO](https://i.imgur.com/jz4s3iR.jpeg)

This layout is for the DZ60 and other keyboards with ISO keycaps in a US layout.

The first layer is a standard US QWERTY Layout.
By holding down the spacebar, a set of function keys as arrow keys become available.
By holding right shift and space, a second layer of function keys becomes available.
ESC is mapped to the Caps Lock key.
If the Caps Lock key is held, a selection of unicode Characters, such as Umlauts become available.
By pressing Special and G you can toggle a layer for gaming that has normal keymappings.

## QWERTY Layer

```
,-----------------------------------------------------------------------------------------.
| ` ~ |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  0  |  -  |  =  |   Bkspc   |
|-----------------------------------------------------------------------------------------+
| Tab    |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  |  [  |  ]  |  Enter |
|-----------------------------------------------------------------------------------+     +
| Esc/Unic|  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  |  ;  |  '  |    \  |     |
|-----------------------------------------------------------------------------------------+
| Shift     |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  ,  |  .  |  /  |      RShift     |
|-----------------------------------------------------------------------------------------+
| Ctrl | Super |  Alt  |              Space/Fnc            |  Alt  | Super |  Ctrl | Spec |
`-----------------------------------------------------------------------------------------'
```

## Function Layer 1

```
,-----------------------------------------------------------------------------------------.
|     | F1  | F2  | F3  | F4  | F5  | F6  | F7  | F8  | F9  | F10 | F11 | F12 |    Del    |
|-----------------------------------------------------------------------------------------+
|        |     |     |     |     |Mute | Prev| V-  | V+  | Next| Play|     |     |  Enter |
|-----------------------------------------------------------------------------------+     +
| Caps    |     |  <  |     |     |  >  |Left |Down | Up  |Right|     |     |       |     |
|-----------------------------------------------------------------------------------------+
| Shift     |     |     |     |     |     |Home |Page-|Page+| End |     |         Fnc2    |
|-----------------------------------------------------------------------------------------+
| Ctrl | Super |  Alt  |             Trans                 |  Alt  | Super |  Ctrl |      |
`-----------------------------------------------------------------------------------------'
```

## Function Layer 2

```
,-----------------------------------------------------------------------------------------.
|     | F13 | F14 | F15 | F16 | F17 | F18 | F19 | F20 | F21 | F22 | F23 | F24 |    Del    |
|-----------------------------------------------------------------------------------------+
|        |     |     |     |     |     |     |     |     |     |     |     |     |  Enter |
|-----------------------------------------------------------------------------------+     +
| Caps    |     |     |     |     |     |     |     |     |     |     |     |       |     |
|-----------------------------------------------------------------------------------------+
| Shift     |     |     |     |     |     |     |     |     |     |     |      Trans      |
|-----------------------------------------------------------------------------------------+
| Ctrl | Super |  Alt  |              Trans                |  Alt  | Super |  Ctrl |      |
`-----------------------------------------------------------------------------------------'
```

## Unicode Layer

```
,-----------------------------------------------------------------------------------------.
|     |     |     |     |     |     |     |     |     |     |     |     |     |   Bkspc   |
|-----------------------------------------------------------------------------------------+
|        |     |     |  €  |     |     |     |  Ü  |     |  Ö  |     |     |     |  Enter |
|-----------------------------------------------------------------------------------+     +
| Trans   |  Ä  |  ß  |     |     |     |     |     |     |     |     |     |       |     |
|-----------------------------------------------------------------------------------------+
| Trans     |     |     |  ©  |     |     |     |     |     |     |     |      Trans      |
|-----------------------------------------------------------------------------------------+
| Ctrl | Super |  Alt  |              Space                |  Alt  | Super |  Ctrl |      |
`-----------------------------------------------------------------------------------------'
```

## Specials Layer

```
,-----------------------------------------------------------------------------------------.
|     |     |     |     |     |     |     |     |     |     |     | RGB-|RGB+ |           |
|-----------------------------------------------------------------------------------------+
|        |     | Win |     |     |     |     |     |     | OSX |     |     |     |  RGB   |
|-----------------------------------------------------------------------------------+ tog +
|         |     |     |     |     |Gamin|     |     |     | Lnx |     |     |       |     |
|-----------------------------------------------------------------------------------------+
|           |     |     |     |     |QK_BOOT|     |     |     |     |     |                 |
|-----------------------------------------------------------------------------------------+
|      |       |       |                                   |       |       |       | Trans|
`-----------------------------------------------------------------------------------------'
```

## Gaming Layer

```
,-----------------------------------------------------------------------------------------.
| Esc |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  0  |  -  |  =  |   Bkspc   |
|-----------------------------------------------------------------------------------------+
| Tab    |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  |  [  |  ]  |  Enter |
|-----------------------------------------------------------------------------------+     +
| Caps    |  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  |  ;  |  '  |    \  |     |
|-----------------------------------------------------------------------------------------+
| Shift     |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  ,  |  .  |  /  |      RShift     |
|-----------------------------------------------------------------------------------------+
| Ctrl |  Cmd  |  Alt  |              Space                |  Alt  | Super |  Ctrl | Spec |
`-----------------------------------------------------------------------------------------'
```
