# Bernardo's modified version of the OSX defaults

I map F19 to spotlight so I like having that handy

## Base


```
 ,--------------------------------------------------.           ,--------------------------------------------------.
 |        |      |      |      |      |      |      |           | Power|      |      |      |      |      |        |
 |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
 | Tab    |   Q  |   W  |   E  |   R  |   T  |  [   |           |   ]  |   Y  |   U  |   I  |   O  |   P  |   \    |
 |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
 |Ctrl/Esc|   A  |   S  |   D  |   F  |   G  |------|           |------|   H  |   J  |   K  |   L  |;/MOVE|   '    |
 |--------+------+------+------+------+------|  (   |           |   )  |------+------+------+------+------+--------|
 | LShift |   Z  |   X  |   C  |   V  |   B  |      |           |      |   N  |   M  |   ,  |   .  |   /  | RShift |
 `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
   |Hyper |  F19 |AltShf|      | NUMS |                                       | NUMS |      |Ctrl/E|  F19 |  Meh |
   `----------------------------------'                                       `----------------------------------'
                                        ,-------------.       ,-------------.
                                        |  V-  |  V+  |       | Next |Play/Pau|
                                 ,------|------|------|       |------+--------+------.
                                 |      |      |  Vx  |       | Prev |        |      |
                                 | Space| LGUI |------|       |------|  Bsp   | Enter|
                                 |      |      | LAlt |       | LAlt |        |      |
                                 `--------------------'       `----------------------'
```

## Numbers and Symbols


```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |  F1  |  F2  |  F3  |  F4  |  F5  |      |           |      |  F6  |  F7  |  F8  |  F9  | F10  |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
|   ⌘-`  |   `  |      |      |      |      |      |           |      |      |      |      |   -  |   =  |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |   1  |   2  |   3  |   4  |   5  |------|           |------|   6  |   7  |   8  |   9  |   0  |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        | F11  | F12  | F13  | F14  | F15  |      |           |      | F16  | F17  | F18  | F19  | F20  |        |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |      |      |      |      |                                       |      |      |      |      |      |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------|------|------|       |------+------+------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |      |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

## Movement

```
,--------------------------------------------------.           ,--------------------------------------------------.
|        |      |      |      |      |      |      |           |      |      |      |      |      |      |        |
|--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------|
|        |      |  ⌥ ← |      |      |      |      |           |      |  ⌘ ← |  ⌥ ← |  ⌥ → |  ⌘ → |      |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |      | HOME | PGUP | PGDW | END  |------|           |------|   ←  |   ↓  |   ↑  |   →  |      |        |
|--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------|
|        |      |      |      |      |  ⌥ → |      |           |      |      |      |      |      |      |        |
`--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------'
  |      |      |      |      |      |                                       |      |      |      |      |      |
  `----------------------------------'                                       `----------------------------------'
                                       ,-------------.       ,-------------.
                                       |      |      |       |      |      |
                                ,------|------|------|       |------+------+------.
                                |      |      |      |       |      |      |      |
                                |      |      |------|       |------|      |      |
                                |      |      |      |       |      |      |      |
                                `--------------------'       `--------------------'
```

## Building

In order to be able to make frequent updates, I maintain this layout [in its own
repository](berfarah:ergodox-layout)

```sh
git clone https://github.com/qmk/qmk_firmware.git
cd qmk_firmware
git clone https://github.com/berfarah/ergodox-layout.git \
          layouts/community/ergodox/berfarah_master
make ergodox_ez-berfarah_master
```

To use this keyboard, run `make ergodox_ez:berfarah`

## Using on Windows

The keymap default to forcing NKRO, which seems to upset Windows, and except the modifiers, none of them work. If you experience this problem, recompile the firmware with `FORCE_NKRO=no` added to the `make` command line.
